/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.BlockBase;
import me.desht.modularrouters.block.tile.ICamouflageable;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.PropertyObject;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Optional;
import team.chisel.ctm.api.IFacade;

@Optional.Interface(iface="team.chisel.ctm.api.IFacade", modid="ctm-api")
public abstract class BlockCamo
extends BlockBase
implements IFacade {
    public static final PropertyObject<IBlockState> CAMOUFLAGE_STATE = new PropertyObject<IBlockState>("held_state", IBlockState.class);

    public BlockCamo(Material materialIn, String blockName) {
        super(materialIn, blockName);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{CAMOUFLAGE_STATE});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        ICamouflageable camo = this.getCamoState(world, pos);
        if (camo == null) {
            return state;
        }
        IBlockState camoState = camo.getCamouflage().func_185899_b(world, pos);
        return ((IExtendedBlockState)state).withProperty(CAMOUFLAGE_STATE, (Object)camoState);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        ICamouflageable camo = this.getCamoState(source, pos);
        return camo != null ? camo.getCamouflage().func_185900_c(source, pos) : super.func_185496_a(state, source, pos);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        ICamouflageable camo = this.getCamoState(worldIn, pos);
        return camo != null ? camo.getCamouflage().func_185890_d(worldIn, pos) : super.func_180646_a(blockState, worldIn, pos);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        ICamouflageable camo = this.getCamoState((IBlockAccess)worldIn, pos);
        if (camo != null) {
            BlockCamo.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)camo.getCamouflage().func_185900_c((IBlockAccess)worldIn, pos));
        } else {
            super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, p_185477_7_);
        }
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        ICamouflageable camo = this.getCamoState(world, pos);
        return camo == null || camo.getCamouflage().doesSideBlockRendering(world, pos, face);
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        ICamouflageable camo = this.getCamoState(world, pos);
        return camo == null || camo.getCamouflage().isSideSolid(world, pos, side);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        ICamouflageable camo = this.getCamoState(world, pos);
        return camo == null ? super.getLightOpacity(state, world, pos) : camo.getCamouflage().getLightOpacity(world, pos);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        ICamouflageable camo = this.getCamoState(world, pos);
        return camo == null || !camo.extendedMimic() ? super.getLightValue(state, world, pos) : camo.getCamouflage().getLightValue(world, pos);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        ICamouflageable camo = this.getCamoState((IBlockAccess)worldIn, pos);
        return camo == null || !camo.extendedMimic() ? super.func_176195_g(blockState, worldIn, pos) : camo.getCamouflage().func_185887_b(worldIn, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        ICamouflageable camo = this.getCamoState((IBlockAccess)world, pos);
        return camo == null || !camo.extendedMimic() ? super.getExplosionResistance(world, pos, exploder, explosion) : camo.getCamouflage().func_177230_c().func_149638_a(exploder);
    }

    private ICamouflageable getCamoState(IBlockAccess blockAccess, BlockPos pos) {
        TileEntity te = MiscUtil.getTileEntitySafely(blockAccess, pos);
        return te instanceof ICamouflageable && ((ICamouflageable)te).getCamouflage() != null ? (ICamouflageable)te : null;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        ICamouflageable camo = this.getCamoState(blockAccess, pos);
        return camo == null || !camo.extendedMimic() ? super.func_180656_a(blockState, blockAccess, pos, side) : camo.getCamouflage().func_185911_a(blockAccess, pos, side);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        ICamouflageable camo = this.getCamoState(blockAccess, pos);
        return camo == null || !camo.extendedMimic() ? super.func_180656_a(blockState, blockAccess, pos, side) : camo.getCamouflage().func_185893_b(blockAccess, pos, side);
    }

    @Nullable
    public String getHarvestTool(IBlockState state) {
        return "pickaxe";
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    @Nonnull
    @Optional.Method(modid="ctm-api")
    public IBlockState getFacade(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ICamouflageable && ((ICamouflageable)te).getCamouflage() != null) {
            return ((ICamouflageable)te).getCamouflage();
        }
        return world.func_180495_p(pos);
    }
}

