/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.shape;

import com.phylogeny.extrabitmanipulation.shape.AsymmetricalShape;
import net.minecraft.util.math.BlockPos;

public class PrismIsoscelesTriangular
extends AsymmetricalShape {
    private float offsetCenter;
    private boolean isTwisted;

    @Override
    public void init(float centerX, float centerY, float centerZ, float a, float b, float c, int direction, boolean sculptHollowShape, float wallThickness, boolean openEnds) {
        int rotation = direction / 6;
        this.isTwisted = rotation % 2 == ((direction %= 6) == 2 || direction == 3 ? 0 : 1);
        super.init(centerX, centerY, centerZ, a, b, c, direction, sculptHollowShape, wallThickness, openEnds);
        if (this.isEquilateral) {
            float contract = this.b - this.b * (float)Math.cos(0.523599);
            this.centerY -= this.inverted ? -contract : contract;
            this.b -= contract;
            this.bInset = this.reduceLength(this.b);
        }
        float hsq = this.b * 2.0f;
        hsq *= hsq;
        float offset = this.isTwisted ? (float)Math.sqrt(hsq + this.a * this.a) * wallThickness / this.a : (float)Math.sqrt(hsq + this.c * this.c) * wallThickness / this.c;
        this.offsetCenter = this.centerY - (this.inverted ? -offset : offset);
        if (this.inverted) {
            this.b *= -1.0f;
        }
    }

    @Override
    public boolean isPointInsideShape(BlockPos pos, int i, int j, int k) {
        if (this.isTwisted) {
            float z = this.getBitPosZ(pos, j, k);
            if (this.isPointOffLine(z, this.centerZ, this.c)) {
                return false;
            }
            float x = this.getBitPosX(pos, i, j);
            float y = this.getBitPosY(pos, i, j, k);
            boolean inShape = this.isPointInTriangle(x, y, this.centerX, this.centerY, this.a, this.b);
            return this.sculptHollowShape ? inShape && (!(this.inverted ? y <= this.centerY + this.bInset : y >= this.centerY - this.bInset) || !this.isPointInTriangle(x, y, this.centerX, this.offsetCenter, this.a, this.b) || !this.openEnds && this.isPointOffLine(z, this.centerZ, this.cInset)) : inShape;
        }
        float x = this.getBitPosX(pos, i, j);
        if (this.isPointOffLine(x, this.centerX, this.a)) {
            return false;
        }
        float z = this.getBitPosZ(pos, j, k);
        float y = this.getBitPosY(pos, i, j, k);
        boolean inShape = this.isPointInTriangle(z, y, this.centerZ, this.centerY, this.c, this.b);
        return this.sculptHollowShape ? inShape && (!(this.inverted ? y <= this.centerY + this.bInset : y >= this.centerY - this.bInset) || !this.isPointInTriangle(z, y, this.centerZ, this.offsetCenter, this.c, this.b) || !this.openEnds && this.isPointOffLine(x, this.centerX, this.aInset)) : inShape;
    }
}

