/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.helper;

import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.config.ConfigBitStack;
import com.phylogeny.extrabitmanipulation.config.ConfigBitToolSettingBoolean;
import com.phylogeny.extrabitmanipulation.config.ConfigBitToolSettingInt;
import com.phylogeny.extrabitmanipulation.config.ConfigHandlerExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.config.ConfigReplacementBits;
import com.phylogeny.extrabitmanipulation.helper.BitAreaHelper;
import com.phylogeny.extrabitmanipulation.helper.BitIOHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.item.ItemModelingTool;
import com.phylogeny.extrabitmanipulation.item.ItemSculptingTool;
import com.phylogeny.extrabitmanipulation.packet.PacketSetArmorMode;
import com.phylogeny.extrabitmanipulation.packet.PacketSetArmorMovingPart;
import com.phylogeny.extrabitmanipulation.packet.PacketSetArmorScale;
import com.phylogeny.extrabitmanipulation.packet.PacketSetBitStack;
import com.phylogeny.extrabitmanipulation.packet.PacketSetDirection;
import com.phylogeny.extrabitmanipulation.packet.PacketSetEndsOpen;
import com.phylogeny.extrabitmanipulation.packet.PacketSetHollowShape;
import com.phylogeny.extrabitmanipulation.packet.PacketSetModelAreaMode;
import com.phylogeny.extrabitmanipulation.packet.PacketSetModelGuiOpen;
import com.phylogeny.extrabitmanipulation.packet.PacketSetModelSnapMode;
import com.phylogeny.extrabitmanipulation.packet.PacketSetSculptMode;
import com.phylogeny.extrabitmanipulation.packet.PacketSetSemiDiameter;
import com.phylogeny.extrabitmanipulation.packet.PacketSetShapeOffset;
import com.phylogeny.extrabitmanipulation.packet.PacketSetShapeType;
import com.phylogeny.extrabitmanipulation.packet.PacketSetTargetArmorBits;
import com.phylogeny.extrabitmanipulation.packet.PacketSetTargetBitGridVertexes;
import com.phylogeny.extrabitmanipulation.packet.PacketSetWallThickness;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import com.phylogeny.extrabitmanipulation.shape.Shape;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import javax.annotation.Nullable;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class BitToolSettingsHelper {
    public static String[] getDirectionNames() {
        String[] directionTexts = new String[6];
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            directionTexts[facing.func_176745_a()] = facing.func_176610_l().substring(0, 1).toUpperCase() + facing.func_176610_l().substring(1);
        }
        return directionTexts;
    }

    public static NBTTagCompound initNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    private static int getInt(NBTTagCompound nbt, int intValue, String key) {
        if (nbt != null && nbt.func_74764_b(key)) {
            intValue = nbt.func_74762_e(key);
        }
        return intValue;
    }

    private static void setInt(EntityPlayer player, ItemStack stack, int intValue, String key) {
        NBTTagCompound nbt = BitToolSettingsHelper.initNBT(stack);
        nbt.func_74768_a(key, intValue);
        player.field_71069_bz.func_75142_b();
    }

    private static boolean getBoolean(NBTTagCompound nbt, boolean booleanValue, String key) {
        if (nbt != null && nbt.func_74764_b(key)) {
            booleanValue = nbt.func_74767_n(key);
        }
        return booleanValue;
    }

    private static void setBoolean(EntityPlayer player, ItemStack stack, boolean booleanValue, String key) {
        NBTTagCompound nbt = BitToolSettingsHelper.initNBT(stack);
        nbt.func_74757_a(key, booleanValue);
        player.field_71069_bz.func_75142_b();
    }

    private static ItemStack getStack(NBTTagCompound nbt, ItemStack stack, String key) {
        if (nbt != null && nbt.func_74764_b(key)) {
            stack = ItemStackHelper.loadStackFromNBT(nbt, key);
        }
        return stack;
    }

    private static void setStack(EntityPlayer player, ItemStack stack, ItemStack stackToSet, String key) {
        NBTTagCompound nbt = BitToolSettingsHelper.initNBT(stack);
        ItemStackHelper.saveStackToNBT(nbt, stackToSet, key);
        player.field_71069_bz.func_75142_b();
    }

    private static int getInt(ConfigBitToolSettingInt config, NBTTagCompound nbt, String nbtKey) {
        return config.isPerTool() ? BitToolSettingsHelper.getInt(nbt, (Integer)config.getDefaultValue(), nbtKey) : (Integer)config.getValue();
    }

    private static boolean getBoolean(ConfigBitToolSettingBoolean config, NBTTagCompound nbt, String nbtKey) {
        return config.isPerTool() ? BitToolSettingsHelper.getBoolean(nbt, (Boolean)config.getDefaultValue(), nbtKey) : (Boolean)config.getValue();
    }

    private static ItemStack getStack(ConfigBitStack config, NBTTagCompound nbt, String nbtKey) {
        return config.isPerTool() ? BitToolSettingsHelper.getStack(nbt, (ItemStack)config.getDefaultValue(), nbtKey) : (ItemStack)config.getValue();
    }

    private static void setIntProperty(World world, Configuration configFile, ConfigBitToolSettingInt config, String catagory, int value) {
        if (!world.field_72995_K) {
            return;
        }
        Property prop = configFile.get(catagory, config.getTitle(), ((Integer)config.getDefaultValue()).intValue());
        if (prop != null) {
            config.setValue(value);
            prop.setValue(value);
            configFile.save();
        }
    }

    private static void setBooleanProperty(World world, Configuration configFile, ConfigBitToolSettingBoolean config, String catagory, boolean value) {
        if (!world.field_72995_K) {
            return;
        }
        Property prop = configFile.get(catagory, config.getTitle(), ((Boolean)config.getDefaultValue()).booleanValue());
        if (prop != null) {
            config.setValue(value);
            prop.setValue(value);
            configFile.save();
        }
    }

    private static void setStackProperty(World world, Configuration configFile, ConfigBitStack config, String catagory, IBitBrush value) {
        if (!world.field_72995_K) {
            return;
        }
        Property prop = configFile.get(catagory, config.getTitle(), config.getStringDeafult());
        if (prop != null) {
            config.setValue(value == null ? null : value.getItemStack(1));
            prop.setValue(BitIOHelper.getStringFromState(value == null ? null : value.getState()));
            configFile.save();
        }
    }

    public static void setBitMapProperty(boolean isStateMap, String[] stringEntries) {
        Configuration configFile = ConfigHandlerExtraBitManipulation.modelingMapConfigFile;
        Property prop = configFile.get("Modeling Tool Manual Mappings", isStateMap ? "State To Bit Map" : "Block To Bit Map", new String[0]);
        if (prop != null) {
            prop.setValues(stringEntries);
            configFile.save();
        }
    }

    public static int getModelAreaMode(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getInt(Configs.modelAreaMode, nbt, "modelAreaMode");
    }

    public static void setModelAreaMode(EntityPlayer player, ItemStack stack, int mode, @Nullable ConfigBitToolSettingInt modelAreaMode) {
        World world = player.field_70170_p;
        if (modelAreaMode == null || modelAreaMode.isPerTool()) {
            if (world.field_72995_K) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetModelAreaMode(mode));
            } else {
                BitToolSettingsHelper.setInt(player, stack, mode, "modelAreaMode");
            }
        } else if (world.field_72995_K) {
            BitToolSettingsHelper.setIntProperty(world, ConfigHandlerExtraBitManipulation.modelingMapConfigFile, modelAreaMode, "Modeling Tool", mode);
        }
    }

    public static int getModelSnapMode(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getInt(Configs.modelSnapMode, nbt, "modelSnapMode");
    }

    public static void setModelSnapMode(EntityPlayer player, ItemStack stack, int mode, @Nullable ConfigBitToolSettingInt modelSnapMode) {
        World world = player.field_70170_p;
        if (modelSnapMode == null || modelSnapMode.isPerTool()) {
            if (world.field_72995_K) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetModelSnapMode(mode));
            } else {
                BitToolSettingsHelper.setInt(player, stack, mode, "modelSnapMode");
            }
        } else if (world.field_72995_K) {
            BitToolSettingsHelper.setIntProperty(world, ConfigHandlerExtraBitManipulation.modelingMapConfigFile, modelSnapMode, "Modeling Tool", mode);
        }
    }

    public static boolean getModelGuiOpen(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getBoolean(Configs.modelGuiOpen, nbt, "modelGuiOpen");
    }

    public static void setModelGuiOpen(EntityPlayer player, ItemStack stack, boolean isOpen, @Nullable ConfigBitToolSettingBoolean modelGuiOpen) {
        World world = player.field_70170_p;
        if (modelGuiOpen == null || modelGuiOpen.isPerTool()) {
            if (world.field_72995_K) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetModelGuiOpen(isOpen));
            } else {
                BitToolSettingsHelper.setBoolean(player, stack, isOpen, "modelGuiOpen");
            }
        } else if (world.field_72995_K) {
            BitToolSettingsHelper.setBooleanProperty(world, ConfigHandlerExtraBitManipulation.modelingMapConfigFile, modelGuiOpen, "Modeling Tool", isOpen);
        }
    }

    public static int getSculptMode(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getInt(Configs.sculptMode, nbt, "sculptingMode");
    }

    public static void setSculptMode(EntityPlayer player, ItemStack stack, int mode, @Nullable ConfigBitToolSettingInt sculptMode) {
        World world = player.field_70170_p;
        if (sculptMode == null || sculptMode.isPerTool()) {
            if (world.field_72995_K) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetSculptMode(mode));
            } else {
                BitToolSettingsHelper.setInt(player, stack, mode, "sculptingMode");
            }
        } else if (world.field_72995_K) {
            BitToolSettingsHelper.setIntProperty(world, ConfigHandlerExtraBitManipulation.sculptingConfigFile, sculptMode, "Sculpting Tool", mode);
        }
    }

    public static int getDirection(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getInt(Configs.sculptDirection, nbt, "direction");
    }

    public static void setDirection(EntityPlayer player, ItemStack stack, int direction, @Nullable ConfigBitToolSettingInt sculptDirection) {
        World world = player.field_70170_p;
        if (sculptDirection == null || sculptDirection.isPerTool()) {
            if (world.field_72995_K) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetDirection(direction));
            } else {
                BitToolSettingsHelper.setInt(player, stack, direction, "direction");
            }
        } else if (world.field_72995_K) {
            BitToolSettingsHelper.setIntProperty(world, ConfigHandlerExtraBitManipulation.sculptingConfigFile, sculptDirection, "Sculpting Tool", direction);
        }
    }

    public static int getShapeType(NBTTagCompound nbt, boolean isCurved) {
        int shapeType = BitToolSettingsHelper.getInt(isCurved ? Configs.sculptShapeTypeCurved : Configs.sculptShapeTypeFlat, nbt, "shapeType");
        return isCurved && shapeType > 2 ? (Integer)Configs.sculptShapeTypeCurved.getDefaultValue() : (!isCurved && shapeType < 3 ? (Integer)Configs.sculptShapeTypeFlat.getDefaultValue() : shapeType);
    }

    public static void setShapeType(EntityPlayer player, ItemStack stack, boolean isCurved, int shapeType, @Nullable ConfigBitToolSettingInt sculptShapeType) {
        World world = player.field_70170_p;
        if (sculptShapeType == null || sculptShapeType.isPerTool()) {
            if (world.field_72995_K) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetShapeType(isCurved, shapeType));
            } else {
                BitToolSettingsHelper.setInt(player, stack, shapeType, "shapeType");
            }
        } else if (world.field_72995_K) {
            BitToolSettingsHelper.setIntProperty(world, ConfigHandlerExtraBitManipulation.sculptingConfigFile, sculptShapeType, "Sculpting Tool", shapeType);
        }
    }

    public static boolean isBitGridTargeted(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getBoolean(Configs.sculptTargetBitGridVertexes, nbt, "targetBitGridVertexes");
    }

    public static void setBitGridTargeted(EntityPlayer player, ItemStack stack, boolean isTargeted, @Nullable ConfigBitToolSettingBoolean sculptTargetBitGridVertexes) {
        World world = player.field_70170_p;
        if (sculptTargetBitGridVertexes == null || sculptTargetBitGridVertexes.isPerTool()) {
            if (world.field_72995_K) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetTargetBitGridVertexes(isTargeted));
            } else {
                BitToolSettingsHelper.setBoolean(player, stack, isTargeted, "targetBitGridVertexes");
            }
        } else if (world.field_72995_K) {
            BitToolSettingsHelper.setBooleanProperty(world, ConfigHandlerExtraBitManipulation.sculptingConfigFile, sculptTargetBitGridVertexes, "Sculpting Tool", isTargeted);
        }
    }

    public static int getSemiDiameter(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getInt(Configs.sculptSemiDiameter, nbt, "sculptSemiDiameter");
    }

    public static void setSemiDiameter(EntityPlayer player, ItemStack stack, int semiDiameter, @Nullable ConfigBitToolSettingInt sculptSemiDiameter) {
        World world = player.field_70170_p;
        if (sculptSemiDiameter == null || sculptSemiDiameter.isPerTool()) {
            if (world.field_72995_K) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetSemiDiameter(semiDiameter));
            } else {
                BitToolSettingsHelper.setInt(player, stack, semiDiameter, "sculptSemiDiameter");
            }
        } else if (world.field_72995_K) {
            BitToolSettingsHelper.setIntProperty(world, ConfigHandlerExtraBitManipulation.sculptingConfigFile, sculptSemiDiameter, "Sculpting Tool", semiDiameter);
        }
    }

    public static boolean isHollowShape(NBTTagCompound nbt, boolean isWire) {
        return BitToolSettingsHelper.getBoolean(isWire ? Configs.sculptHollowShapeWire : Configs.sculptHollowShapeSpade, nbt, "sculptHollowShape");
    }

    public static void setHollowShape(EntityPlayer player, ItemStack stack, boolean isWire, boolean hollowShape, @Nullable ConfigBitToolSettingBoolean sculptHollowShape) {
        World world = player.field_70170_p;
        if (sculptHollowShape == null || sculptHollowShape.isPerTool()) {
            if (world.field_72995_K) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetHollowShape(hollowShape, isWire));
            } else {
                BitToolSettingsHelper.setBoolean(player, stack, hollowShape, "sculptHollowShape");
            }
        } else if (world.field_72995_K) {
            BitToolSettingsHelper.setBooleanProperty(world, ConfigHandlerExtraBitManipulation.sculptingConfigFile, sculptHollowShape, "Sculpting Tool", hollowShape);
        }
    }

    public static boolean areEndsOpen(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getBoolean(Configs.sculptOpenEnds, nbt, "openEnds");
    }

    public static void setEndsOpen(EntityPlayer player, ItemStack stack, boolean openEnds, @Nullable ConfigBitToolSettingBoolean sculptOpenEnds) {
        World world = player.field_70170_p;
        if (sculptOpenEnds == null || sculptOpenEnds.isPerTool()) {
            if (world.field_72995_K) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetEndsOpen(openEnds));
            } else {
                BitToolSettingsHelper.setBoolean(player, stack, openEnds, "openEnds");
            }
        } else if (world.field_72995_K) {
            BitToolSettingsHelper.setBooleanProperty(world, ConfigHandlerExtraBitManipulation.sculptingConfigFile, sculptOpenEnds, "Sculpting Tool", openEnds);
        }
    }

    public static int getWallThickness(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getInt(Configs.sculptWallThickness, nbt, "wallThickness");
    }

    public static void setWallThickness(EntityPlayer player, ItemStack stack, int wallThickness, @Nullable ConfigBitToolSettingInt sculptWallThickness) {
        World world = player.field_70170_p;
        if (sculptWallThickness == null || sculptWallThickness.isPerTool()) {
            if (world.field_72995_K) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetWallThickness(wallThickness));
            } else {
                BitToolSettingsHelper.setInt(player, stack, wallThickness, "wallThickness");
            }
        } else if (world.field_72995_K) {
            BitToolSettingsHelper.setIntProperty(world, ConfigHandlerExtraBitManipulation.sculptingConfigFile, sculptWallThickness, "Sculpting Tool", wallThickness);
        }
    }

    public static ItemStack getBitStack(NBTTagCompound nbt, boolean isWire) {
        return BitToolSettingsHelper.getStack(isWire ? Configs.sculptSetBitWire : Configs.sculptSetBitSpade, nbt, "setBit");
    }

    public static void setBitStack(EntityPlayer player, ItemStack stack, boolean isWire, IBitBrush bit, @Nullable ConfigBitStack sculptSetBit) {
        World world = player.field_70170_p;
        if (sculptSetBit == null || sculptSetBit.isPerTool()) {
            if (world.field_72995_K) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetBitStack(isWire, bit));
            } else {
                BitToolSettingsHelper.setStack(player, stack, bit == null ? null : bit.getItemStack(1), "setBit");
            }
        } else if (world.field_72995_K) {
            BitToolSettingsHelper.setStackProperty(world, ConfigHandlerExtraBitManipulation.sculptingConfigFile, sculptSetBit, "Sculpting Tool", bit);
        }
    }

    public static boolean isShapeOffset(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getBoolean(Configs.sculptOffsetShape, nbt, "offsetShape");
    }

    public static void setShapeOffset(EntityPlayer player, ItemStack stack, boolean offsetShape, @Nullable ConfigBitToolSettingBoolean sculptOffsetShape) {
        World world = player.field_70170_p;
        if (sculptOffsetShape == null || sculptOffsetShape.isPerTool()) {
            if (world.field_72995_K) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetShapeOffset(offsetShape));
            } else {
                BitToolSettingsHelper.setBoolean(player, stack, offsetShape, "offsetShape");
            }
        } else if (world.field_72995_K) {
            BitToolSettingsHelper.setBooleanProperty(world, ConfigHandlerExtraBitManipulation.sculptingConfigFile, sculptOffsetShape, "Sculpting Tool", offsetShape);
        }
    }

    public static int getArmorMode(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getInt(Configs.armorMode, nbt, "mode");
    }

    public static void setArmorMode(EntityPlayer player, ItemStack stack, int mode, @Nullable ConfigBitToolSettingInt armorMode) {
        World world = player.field_70170_p;
        if (armorMode == null || armorMode.isPerTool()) {
            if (world.field_72995_K) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetArmorMode(mode));
            } else {
                BitToolSettingsHelper.setInt(player, stack, mode, "mode");
            }
        } else if (world.field_72995_K) {
            BitToolSettingsHelper.setIntProperty(world, ConfigHandlerExtraBitManipulation.chiseledArmorConfigFile, armorMode, "Chiseled Armor", mode);
        }
    }

    public static int getArmorScale(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getInt(Configs.armorScale, nbt, "scale");
    }

    public static void setArmorScale(EntityPlayer player, ItemStack stack, int scale, @Nullable ConfigBitToolSettingInt armorScale) {
        BitToolSettingsHelper.setArmorScale(player, stack, scale, armorScale, null, false);
    }

    public static void setArmorScale(EntityPlayer player, ItemStack stack, int scale, @Nullable ConfigBitToolSettingInt armorScale, @Nullable EntityEquipmentSlot slot, boolean mainArmor) {
        World world = player.field_70170_p;
        if (armorScale == null || armorScale.isPerTool()) {
            if (world.field_72995_K) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetArmorScale(scale, slot, mainArmor));
            }
            BitToolSettingsHelper.setInt(player, stack, scale, "scale");
        } else if (world.field_72995_K) {
            BitToolSettingsHelper.setIntProperty(world, ConfigHandlerExtraBitManipulation.chiseledArmorConfigFile, armorScale, "Chiseled Armor", scale);
        }
    }

    public static ConfigBitToolSettingInt getArmorMovingPartConfig(ItemChiseledArmor.ArmorType armorType) {
        return armorType == ItemChiseledArmor.ArmorType.HELMET ? Configs.armorMovingPartHelmet : (armorType == ItemChiseledArmor.ArmorType.CHESTPLATE ? Configs.armorMovingPartChestplate : (armorType == ItemChiseledArmor.ArmorType.LEGGINGS ? Configs.armorMovingPartLeggings : Configs.armorMovingPartBoots));
    }

    public static ItemChiseledArmor.ArmorMovingPart getArmorMovingPart(NBTTagCompound nbt, ItemChiseledArmor armorPiece) {
        return armorPiece.MOVING_PARTS[BitToolSettingsHelper.getInt(BitToolSettingsHelper.getArmorMovingPartConfig(armorPiece.field_77881_a), nbt, "movingPart")];
    }

    public static void setArmorMovingPart(EntityPlayer player, ItemStack stack, ItemChiseledArmor armorPiece, int partIndex) {
        BitToolSettingsHelper.setArmorMovingPart(player, stack, partIndex, BitToolSettingsHelper.getArmorMovingPartConfig(armorPiece.field_77881_a), null, false);
    }

    public static void setArmorMovingPart(EntityPlayer player, ItemStack stack, int partIndex, @Nullable ConfigBitToolSettingInt armorMovingPart, @Nullable EntityEquipmentSlot slot, boolean mainArmor) {
        World world = player.field_70170_p;
        if (armorMovingPart == null || armorMovingPart.isPerTool()) {
            if (world.field_72995_K) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetArmorMovingPart(partIndex, slot, mainArmor));
            }
            BitToolSettingsHelper.setInt(player, stack, partIndex, "movingPart");
        } else if (world.field_72995_K) {
            BitToolSettingsHelper.setIntProperty(world, ConfigHandlerExtraBitManipulation.chiseledArmorConfigFile, armorMovingPart, "Chiseled Armor", partIndex);
        }
    }

    public static boolean areArmorBitsTargeted(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getBoolean(Configs.armorTargetBits, nbt, "targetBits");
    }

    public static void setArmorBitsTargeted(EntityPlayer player, ItemStack stack, boolean isTargeted, @Nullable ConfigBitToolSettingBoolean armorTargetBits) {
        World world = player.field_70170_p;
        if (armorTargetBits == null || armorTargetBits.isPerTool()) {
            if (world.field_72995_K) {
                ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetTargetArmorBits(isTargeted));
            } else {
                BitToolSettingsHelper.setBoolean(player, stack, isTargeted, "targetBits");
            }
        } else if (world.field_72995_K) {
            BitToolSettingsHelper.setBooleanProperty(world, ConfigHandlerExtraBitManipulation.chiseledArmorConfigFile, armorTargetBits, "Chiseled Armor", isTargeted);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static int getArmorTabIndex() {
        return (Integer)Configs.armorTabIndex.getValue();
    }

    @SideOnly(value=Side.CLIENT)
    public static void setArmorTabIndex(int armorTabIndex) {
        BitToolSettingsHelper.setIntProperty(ClientHelper.getWorld(), ConfigHandlerExtraBitManipulation.chiseledArmorConfigFile, Configs.armorTabIndex, "Chiseled Armor", armorTabIndex);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean getArmorPixelTranslation() {
        return (Boolean)Configs.armorPixelTranslation.getValue();
    }

    @SideOnly(value=Side.CLIENT)
    public static void setArmorPixelTranslation(boolean pixelTranslation) {
        BitToolSettingsHelper.setBooleanProperty(ClientHelper.getWorld(), ConfigHandlerExtraBitManipulation.chiseledArmorConfigFile, Configs.armorPixelTranslation, "Chiseled Armor", pixelTranslation);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean getArmorFullIllumination() {
        return (Boolean)Configs.armorFullIllumination.getValue();
    }

    @SideOnly(value=Side.CLIENT)
    public static void setArmorFullIllumination(boolean armorFullIllumination) {
        BitToolSettingsHelper.setBooleanProperty(ClientHelper.getWorld(), ConfigHandlerExtraBitManipulation.chiseledArmorConfigFile, Configs.armorFullIllumination, "Chiseled Armor", armorFullIllumination);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean getArmorLookAtCursor() {
        return (Boolean)Configs.armorLookAtCursor.getValue();
    }

    @SideOnly(value=Side.CLIENT)
    public static void setArmorLookAtCursor(boolean armorLookAtCursor) {
        BitToolSettingsHelper.setBooleanProperty(ClientHelper.getWorld(), ConfigHandlerExtraBitManipulation.chiseledArmorConfigFile, Configs.armorLookAtCursor, "Chiseled Armor", armorLookAtCursor);
    }

    @SideOnly(value=Side.CLIENT)
    public static Pair<Integer, Integer> getArmorButtonPosition() {
        return new ImmutablePair(Configs.armorButtonX.getValue(), Configs.armorButtonY.getValue());
    }

    @SideOnly(value=Side.CLIENT)
    public static void setArmorButtonPosition(int armorButtonX, int armorButtonY) {
        BitToolSettingsHelper.setArmorButtonInt(Configs.armorButtonX, armorButtonX);
        BitToolSettingsHelper.setArmorButtonInt(Configs.armorButtonY, armorButtonY);
    }

    private static void setArmorButtonInt(ConfigBitToolSettingInt config, int armorButtonAxis) {
        BitToolSettingsHelper.setIntProperty(ClientHelper.getWorld(), ConfigHandlerExtraBitManipulation.chiseledArmorConfigFile, config, "Chiseled Armor", armorButtonAxis);
    }

    public static String getArmorModeText(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getArmorModeText(BitToolSettingsHelper.getArmorMode(nbt));
    }

    public static String getArmorModeText(int mode) {
        return "Mode: " + ItemChiseledArmor.MODE_TITLES[mode].toLowerCase();
    }

    public static String getArmorScaleText(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getArmorScaleText(BitToolSettingsHelper.getArmorScale(nbt));
    }

    public static String getArmorScaleText(int scale) {
        return "Scale: " + ItemChiseledArmor.SCALE_TITLES[scale].toLowerCase();
    }

    public static String getArmorMovingPartText(NBTTagCompound nbt, ItemChiseledArmor armorPiece) {
        return BitToolSettingsHelper.getArmorMovingPartText(BitToolSettingsHelper.getArmorMovingPart(nbt, armorPiece), armorPiece);
    }

    public static String getArmorMovingPartText(ItemChiseledArmor.ArmorMovingPart part, ItemChiseledArmor armorPiece) {
        return "Moving Part: " + armorPiece.MOVING_PART_TITLES[part.getPartIndex()].toLowerCase();
    }

    public static String getArmorBitsTargetedText(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getArmorBitsTargetedText(BitToolSettingsHelper.areArmorBitsTargeted(nbt));
    }

    public static String getArmorBitsTargetedText(boolean targetBits) {
        return "Targeting: " + (targetBits ? "bits" : "blocks");
    }

    public static String getModeText(String[] titles, String pefaceText, int mode) {
        return pefaceText + " Mode: " + titles[mode].toLowerCase();
    }

    public static String getModelAreaModeText(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getModelAreaModeText(BitToolSettingsHelper.getModelAreaMode(nbt));
    }

    public static String getModelAreaModeText(int mode) {
        return BitToolSettingsHelper.getModeText(ItemModelingTool.AREA_MODE_TITLES, "Area", mode);
    }

    public static String getModelSnapModeText(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getModelSnapModeText(BitToolSettingsHelper.getModelSnapMode(nbt));
    }

    public static String getModelSnapModeText(int mode) {
        return BitToolSettingsHelper.getModeText(ItemModelingTool.SNAP_MODE_TITLES, "Chunk Snap", mode);
    }

    public static String getModelGuiOpenText(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getModelGuiOpenText(BitToolSettingsHelper.getModelGuiOpen(nbt));
    }

    public static String getModelGuiOpenText(boolean openGui) {
        return "Open GUI Upon Read: " + (openGui ? "true" : "false");
    }

    public static String getSculptModeText(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getSculptModeText(BitToolSettingsHelper.getSculptMode(nbt));
    }

    public static String getSculptModeText(int mode) {
        return BitToolSettingsHelper.getModeText(ItemSculptingTool.MODE_TITLES, "Sculpting", mode);
    }

    public static String getDirectionText(NBTTagCompound nbt, boolean showRotation) {
        return BitToolSettingsHelper.getDirectionText(BitToolSettingsHelper.getDirection(nbt), showRotation);
    }

    public static String getDirectionText(int direction, boolean showRotation) {
        int rotation;
        String text = "Direction: " + EnumFacing.func_82600_a((int)(direction % 6)).func_176610_l().toLowerCase();
        if (showRotation && (rotation = direction / 6) > 0) {
            text = text + " (rotation " + rotation * 90 + "\u00b0)";
        }
        return text;
    }

    public static String getShapeTypeText(NBTTagCompound nbt, ItemSculptingTool item) {
        return BitToolSettingsHelper.getShapeTypeText(BitToolSettingsHelper.getShapeType(nbt, item.isCurved()));
    }

    public static String getShapeTypeText(int shapeType) {
        return "Shape: " + Shape.SHAPE_NAMES[shapeType].toLowerCase();
    }

    public static String getBitGridTargetedText(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getBitGridTargetedText(BitToolSettingsHelper.isBitGridTargeted(nbt));
    }

    public static String getBitGridTargetedText(boolean targetBitGrid) {
        return "Targeting: " + (targetBitGrid ? "bit grid vertiecies" : "bits");
    }

    public static String getSemiDiameterText(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getSemiDiameterText(nbt, BitToolSettingsHelper.getSemiDiameter(nbt));
    }

    public static String getSemiDiameterText(NBTTagCompound nbt, int semiDiameter) {
        double size = semiDiameter;
        boolean targetBitGrid = BitToolSettingsHelper.isBitGridTargeted(nbt);
        String diameterText = "Semi-Diameter: ";
        if (Configs.displayNameDiameter) {
            size *= 2.0;
            if (!targetBitGrid) {
                size += 1.0;
            }
            diameterText = diameterText.substring(5);
        } else if (!targetBitGrid) {
            size += 0.5;
        }
        diameterText = Configs.displayNameUseMeterUnits ? diameterText + (double)Math.round(size * 0.0625 * 100.0) / 100.0 + " meters" : BitToolSettingsHelper.addBitLengthString(size, diameterText);
        return diameterText;
    }

    public static String getHollowShapeText(NBTTagCompound nbt, ItemSculptingTool item) {
        return BitToolSettingsHelper.getHollowShapeText(BitToolSettingsHelper.isHollowShape(nbt, item.removeBits()));
    }

    public static String getHollowShapeText(boolean isHollowShape) {
        return "Interior: " + (isHollowShape ? "hollow" : "solid");
    }

    public static String getOpenEndsText(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getOpenEndsText(BitToolSettingsHelper.areEndsOpen(nbt));
    }

    public static String getOpenEndsText(boolean areEndsOpen) {
        return "Ends: " + (areEndsOpen ? "open" : "closed");
    }

    public static String getWallThicknessText(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getWallThicknessText(BitToolSettingsHelper.getWallThickness(nbt));
    }

    public static String getWallThicknessText(int wallThickness) {
        return BitToolSettingsHelper.addBitLengthString(wallThickness, "Wall Thickness: ");
    }

    public static String getOffsetShapeText(NBTTagCompound nbt) {
        return BitToolSettingsHelper.getOffsetShapeText(BitToolSettingsHelper.isShapeOffset(nbt));
    }

    public static String getOffsetShapeText(boolean offsetShape) {
        return "Shape Placement: " + (offsetShape ? "offset" : "centered");
    }

    public static int cycleData(int intValue, boolean forward, int max) {
        return (intValue + (forward ? 1 : max - 1)) % max;
    }

    private static String addBitLengthString(double size, String diameterText) {
        if (size >= 16.0) {
            int size2 = (int)size / 16;
            diameterText = diameterText + size2 + " meter";
            if (size2 > 1) {
                diameterText = diameterText + "s";
            }
            if ((size %= 16.0) > 0.0) {
                diameterText = diameterText + " & ";
            }
        }
        if (size > 0.0) {
            diameterText = size == (double)((int)size) ? diameterText + (int)size : diameterText + size;
            diameterText = diameterText + " bits";
        }
        return diameterText;
    }

    public static String getBitName(ItemStack bitStack) {
        return bitStack.func_82833_r().replace("Chiseled Bit - ", "");
    }

    public static class SculptingData {
        private int sculptMode;
        private int direction;
        private int shapeType;
        private int semiDiameter;
        private int wallThickness;
        private boolean targetBitGridVertexes;
        private boolean hollowShape;
        private boolean openEnds;
        private boolean offsetShape;
        private ItemStack setBitStack;
        private float semiDiameterPadding;

        public SculptingData() {
        }

        public SculptingData(NBTTagCompound nbt, ItemSculptingTool toolItem) {
            this.sculptMode = BitToolSettingsHelper.getSculptMode(nbt);
            this.direction = BitToolSettingsHelper.getDirection(nbt);
            this.shapeType = BitToolSettingsHelper.getShapeType(nbt, toolItem.isCurved());
            this.targetBitGridVertexes = BitToolSettingsHelper.isBitGridTargeted(nbt);
            this.semiDiameter = BitToolSettingsHelper.getSemiDiameter(nbt);
            this.hollowShape = BitToolSettingsHelper.isHollowShape(nbt, toolItem.removeBits());
            this.openEnds = BitToolSettingsHelper.areEndsOpen(nbt);
            this.wallThickness = BitToolSettingsHelper.getWallThickness(nbt);
            this.setBitStack = BitToolSettingsHelper.getBitStack(nbt, toolItem.removeBits());
            this.semiDiameterPadding = Configs.semiDiameterPadding;
            this.offsetShape = BitToolSettingsHelper.isShapeOffset(nbt);
        }

        public void toBytes(ByteBuf buffer) {
            buffer.writeInt(this.sculptMode);
            buffer.writeInt(this.direction);
            buffer.writeInt(this.shapeType);
            buffer.writeBoolean(this.targetBitGridVertexes);
            buffer.writeInt(this.semiDiameter);
            buffer.writeBoolean(this.hollowShape);
            buffer.writeBoolean(this.openEnds);
            buffer.writeInt(this.wallThickness);
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.setBitStack);
            buffer.writeFloat(this.semiDiameterPadding);
            buffer.writeBoolean(this.offsetShape);
        }

        public void fromBytes(ByteBuf buffer) {
            this.sculptMode = buffer.readInt();
            this.direction = buffer.readInt();
            this.shapeType = buffer.readInt();
            this.targetBitGridVertexes = buffer.readBoolean();
            this.semiDiameter = buffer.readInt();
            this.hollowShape = buffer.readBoolean();
            this.openEnds = buffer.readBoolean();
            this.wallThickness = buffer.readInt();
            this.setBitStack = ByteBufUtils.readItemStack((ByteBuf)buffer);
            this.semiDiameterPadding = buffer.readFloat();
            this.offsetShape = buffer.readBoolean();
        }

        public int getSculptMode() {
            return this.sculptMode;
        }

        public int getDirection() {
            return this.direction;
        }

        public int getShapeType() {
            return this.shapeType;
        }

        public int getSemiDiameter() {
            return this.semiDiameter;
        }

        public int getWallThickness() {
            return this.wallThickness;
        }

        public boolean isBitGridTargeted() {
            return this.targetBitGridVertexes;
        }

        public boolean isHollowShape() {
            return this.hollowShape;
        }

        public boolean areEndsOpen() {
            return this.openEnds;
        }

        public ItemStack getBitStack() {
            return this.setBitStack;
        }

        public float getSemiDiameterPadding() {
            return this.semiDiameterPadding;
        }

        public boolean isShapeOffset() {
            return this.offsetShape;
        }
    }

    public static class ModelWriteData {
        private ConfigReplacementBits replacementBitsUnchiselable = new ConfigReplacementBits();
        private ConfigReplacementBits replacementBitsInsufficient = new ConfigReplacementBits();
        private Map<IBlockState, IBitBrush> stateToBitMap;
        private Map<IBlockState, IBitBrush> blockToBitMap;
        private boolean bitMapPerTool;

        public ModelWriteData() {
        }

        public ModelWriteData(boolean bitMapPerTool) {
            this.bitMapPerTool = bitMapPerTool;
            this.replacementBitsUnchiselable = Configs.replacementBitsUnchiselable;
            this.replacementBitsInsufficient = Configs.replacementBitsInsufficient;
            this.stateToBitMap = Configs.modelStateToBitMap;
            this.blockToBitMap = Configs.modelBlockToBitMap;
        }

        public void toBytes(ByteBuf buffer) {
            this.replacementBitsUnchiselable.toBytes(buffer);
            this.replacementBitsInsufficient.toBytes(buffer);
            buffer.writeBoolean(this.bitMapPerTool);
            if (!this.bitMapPerTool) {
                BitIOHelper.stateToBitMapToBytes(buffer, this.stateToBitMap);
                BitIOHelper.stateToBitMapToBytes(buffer, this.blockToBitMap);
            }
        }

        public void fromBytes(ByteBuf buffer) {
            this.replacementBitsUnchiselable.fromBytes(buffer);
            this.replacementBitsInsufficient.fromBytes(buffer);
            this.bitMapPerTool = buffer.readBoolean();
            this.stateToBitMap = this.bitMapPerTool ? null : BitIOHelper.stateToBitMapFromBytes(buffer);
            this.blockToBitMap = this.bitMapPerTool ? null : BitIOHelper.stateToBitMapFromBytes(buffer);
        }

        public ConfigReplacementBits getReplacementBitsUnchiselable() {
            return this.replacementBitsUnchiselable;
        }

        public ConfigReplacementBits getReplacementBitsInsufficient() {
            return this.replacementBitsInsufficient;
        }

        public Map<IBlockState, IBitBrush> getStateToBitMap(IChiselAndBitsAPI api, ItemStack stack) {
            return this.bitMapPerTool ? BitIOHelper.readStateToBitMapFromNBT(api, stack, "stateToBitMapPermanent") : this.stateToBitMap;
        }

        public Map<IBlockState, IBitBrush> getBlockToBitMap(IChiselAndBitsAPI api, ItemStack stack) {
            return this.bitMapPerTool ? BitIOHelper.readStateToBitMapFromNBT(api, stack, "blockToBitMapPermanent") : this.blockToBitMap;
        }
    }

    public static class ModelReadData {
        private int areaMode;
        private int chunkSnapMode;
        private boolean guiOpen;

        public ModelReadData() {
        }

        public ModelReadData(NBTTagCompound nbt) {
            this.areaMode = BitToolSettingsHelper.getModelAreaMode(nbt);
            this.chunkSnapMode = BitToolSettingsHelper.getModelSnapMode(nbt);
            this.guiOpen = BitToolSettingsHelper.getModelGuiOpen(nbt);
        }

        public void toBytes(ByteBuf buffer) {
            buffer.writeInt(this.areaMode);
            buffer.writeInt(this.chunkSnapMode);
            buffer.writeBoolean(this.guiOpen);
        }

        public void fromBytes(ByteBuf buffer) {
            this.areaMode = buffer.readInt();
            this.chunkSnapMode = buffer.readInt();
            this.guiOpen = buffer.readBoolean();
        }

        public int getAreaMode() {
            return this.areaMode;
        }

        public int getSnapMode() {
            return this.chunkSnapMode;
        }

        public boolean getGuiOpen() {
            return this.guiOpen;
        }
    }

    public static class ArmorBodyPartTemplateBoxData {
        private EnumFacing facingBox;
        AxisAlignedBB boxTemplate;

        public ArmorBodyPartTemplateBoxData(NBTTagCompound nbt, ItemChiseledArmor armorPiece) {
            this.facingBox = BitAreaHelper.readFacingFromNBT(nbt, "facingBox");
            this.boxTemplate = ItemChiseledArmor.getBodyPartTemplateBox(nbt.func_74760_g("yaw"), nbt.func_74767_n("useBitGrid"), this.facingBox, BitAreaHelper.readFacingFromNBT(nbt, "facingPlacement"), BitAreaHelper.readBlockPosFromNBT(nbt, "pos"), BitAreaHelper.readVecFromNBT(nbt, "hit"), BitToolSettingsHelper.getArmorScale(nbt), BitToolSettingsHelper.getArmorMovingPart(nbt, armorPiece));
        }

        public EnumFacing getFacingBox() {
            return this.facingBox;
        }

        public AxisAlignedBB getBox() {
            return this.boxTemplate;
        }
    }

    public static class ArmorCollectionData
    extends ArmorData {
        private AxisAlignedBB boxCollection;
        private EnumFacing facing;
        private Vec3d originBodyPart;

        public ArmorCollectionData() {
        }

        public ArmorCollectionData(NBTTagCompound nbt, ItemChiseledArmor armor, AxisAlignedBB boxCollection) {
            super(nbt, armor);
            float offsetY;
            float offsetX;
            float offsetZ;
            ArmorBodyPartTemplateBoxData boxData = new ArmorBodyPartTemplateBoxData(nbt, armor);
            this.facing = boxData.getFacingBox();
            this.boxCollection = boxCollection;
            this.originBodyPart = new Vec3d(boxData.getBox().field_72340_a, boxData.getBox().field_72338_b, boxData.getBox().field_72339_c);
            ItemChiseledArmor.ArmorMovingPart movingPart = this.part;
            int scale = (int)Math.pow(2.0, this.scale);
            if (movingPart == ItemChiseledArmor.ArmorMovingPart.HEAD) {
                offsetX = offsetZ = (float)(8 - scale * 4);
                offsetY = 8 - scale * 8;
            } else if (movingPart.getBodyPartTemplate() == ItemChiseledArmor.BodyPartTemplate.TORSO) {
                if (this.facing.func_176740_k() == EnumFacing.Axis.Z) {
                    offsetX = 8 - scale * 4;
                    offsetZ = 8 - scale * 2;
                } else {
                    offsetX = 8 - scale * 2;
                    offsetZ = 8 - scale * 4;
                }
                offsetY = 8 - scale * (movingPart == ItemChiseledArmor.ArmorMovingPart.PELVIS ? 8 : 4);
            } else {
                offsetX = offsetZ = (float)(8 - scale * 2);
                offsetY = 8 - scale * (movingPart == ItemChiseledArmor.ArmorMovingPart.FOOT_RIGHT || movingPart == ItemChiseledArmor.ArmorMovingPart.FOOT_LEFT ? 8 : 4);
            }
            this.originBodyPart = this.originBodyPart.func_178786_a((double)offsetX * 0.0625, (double)offsetY * 0.0625, (double)offsetZ * 0.0625);
        }

        @Override
        public void toBytes(ByteBuf buffer) {
            super.toBytes(buffer);
            buffer.writeDouble(this.boxCollection.field_72340_a);
            buffer.writeDouble(this.boxCollection.field_72338_b);
            buffer.writeDouble(this.boxCollection.field_72339_c);
            buffer.writeDouble(this.boxCollection.field_72336_d);
            buffer.writeDouble(this.boxCollection.field_72337_e);
            buffer.writeDouble(this.boxCollection.field_72334_f);
            buffer.writeInt(this.facing.ordinal());
            buffer.writeDouble(this.originBodyPart.field_72450_a);
            buffer.writeDouble(this.originBodyPart.field_72448_b);
            buffer.writeDouble(this.originBodyPart.field_72449_c);
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            super.fromBytes(buffer);
            this.boxCollection = new AxisAlignedBB(buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            this.facing = EnumFacing.values()[buffer.readInt()];
            this.originBodyPart = new Vec3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }

        public EnumFacing getFacing() {
            return this.facing;
        }

        public AxisAlignedBB getCollectionBox() {
            return this.boxCollection;
        }

        public Vec3d getOriginBodyPart() {
            return this.originBodyPart;
        }
    }

    public static class ArmorBodyPartTemplateData
    extends ArmorData {
        private int mode;
        private boolean bitsTargeted;

        public ArmorBodyPartTemplateData() {
        }

        public ArmorBodyPartTemplateData(NBTTagCompound nbt, ItemChiseledArmor armor) {
            super(nbt, armor);
            this.mode = BitToolSettingsHelper.getArmorMode(nbt);
            this.bitsTargeted = BitToolSettingsHelper.areArmorBitsTargeted(nbt);
        }

        @Override
        public void toBytes(ByteBuf buffer) {
            super.toBytes(buffer);
            buffer.writeInt(this.mode);
            buffer.writeBoolean(this.bitsTargeted);
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            super.fromBytes(buffer);
            this.mode = buffer.readInt();
            this.bitsTargeted = buffer.readBoolean();
        }

        public int getMode() {
            return this.mode;
        }

        public boolean areBitsTargeted() {
            return this.bitsTargeted;
        }
    }

    public static class ArmorData {
        protected int scale;
        protected ItemChiseledArmor.ArmorMovingPart part;

        public ArmorData() {
        }

        public ArmorData(NBTTagCompound nbt, ItemChiseledArmor armorPiece) {
            this.scale = BitToolSettingsHelper.getArmorScale(nbt);
            this.part = BitToolSettingsHelper.getArmorMovingPart(nbt, armorPiece);
        }

        public void toBytes(ByteBuf buffer) {
            buffer.writeInt(this.scale);
            buffer.writeInt(this.part.ordinal());
        }

        public void fromBytes(ByteBuf buffer) {
            this.scale = buffer.readInt();
            this.part = ItemChiseledArmor.ArmorMovingPart.values()[buffer.readInt()];
        }

        public int getScale() {
            return this.scale;
        }

        public ItemChiseledArmor.ArmorMovingPart getMovingPart() {
            return this.part;
        }
    }
}

