/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorageaddons.apiimpl.network.item;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemHandler;
import com.raoulvdberge.refinedstorage.api.network.item.NetworkItemAction;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.apiimpl.network.item.NetworkItemWirelessGrid;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import com.raoulvdberge.refinedstorageaddons.RSAddons;
import com.raoulvdberge.refinedstorageaddons.item.WirelessCraftingGrid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class NetworkItemWirelessCraftingGrid
extends NetworkItemWirelessGrid {
    private INetworkItemHandler handler;
    private ItemStack stack;

    public NetworkItemWirelessCraftingGrid(INetworkItemHandler handler, EntityPlayer player, ItemStack stack) {
        super(handler, player, stack);
        this.handler = handler;
        this.stack = stack;
    }

    public boolean onOpen(INetwork network, EntityPlayer player, EnumHand hand) {
        if (RSAddons.INSTANCE.config.wirelessCraftingGridUsesEnergy && this.stack.func_77952_i() != 1 && ((IEnergyStorage)this.stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored() <= RSAddons.INSTANCE.config.wirelessCraftingGridOpenUsage) {
            return false;
        }
        if (!network.getSecurityManager().hasPermission(Permission.MODIFY, player)) {
            WorldUtils.sendNoPermissionMessage((EntityPlayer)player);
            return false;
        }
        RSAddons.RSAPI.openWirelessGrid(player, hand, network.world().field_73011_w.getDimension(), WirelessCraftingGrid.ID);
        this.drainEnergy(RSAddons.INSTANCE.config.wirelessCraftingGridOpenUsage);
        return true;
    }

    public void onAction(NetworkItemAction action) {
        switch (action) {
            case ITEM_INSERTED: {
                this.drainEnergy(RSAddons.INSTANCE.config.wirelessCraftingGridInsertUsage);
                break;
            }
            case ITEM_EXTRACTED: {
                this.drainEnergy(RSAddons.INSTANCE.config.wirelessCraftingGridExtractUsage);
                break;
            }
            case ITEM_CRAFTED: {
                this.drainEnergy(RSAddons.INSTANCE.config.wirelessCraftingGridCraftUsage);
            }
        }
    }

    private void drainEnergy(int energy) {
        if (RSAddons.INSTANCE.config.wirelessCraftingGridUsesEnergy && this.stack.func_77952_i() != 1) {
            IEnergyStorage energyStorage = (IEnergyStorage)this.stack.getCapability(CapabilityEnergy.ENERGY, null);
            energyStorage.extractEnergy(energy, false);
            if (energyStorage.getEnergyStored() <= 0) {
                this.handler.onClose(this.getPlayer());
                this.getPlayer().func_71053_j();
            }
        }
    }
}

