/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.villager;

import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.module.BaseModule;
import com.lothrazar.cyclicmagic.registry.VillagerProfRegistry;
import com.lothrazar.cyclicmagic.villager.VillagerDruid;
import com.lothrazar.cyclicmagic.villager.VillagerSage;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class VillagerCreateModule
extends BaseModule
implements IHasConfig {
    private boolean sageEnabled;
    private boolean druidEnabled;

    private void addVillager(String name, EntityVillager.ITradeList[][] trades) {
        VillagerRegistry.VillagerProfession prof = new VillagerRegistry.VillagerProfession("cyclicmagic:" + name, "cyclicmagic:textures/entity/villager/" + name + ".png", "minecraft:textures/entity/zombie_villager/zombie_villager.png");
        VillagerProfRegistry.register(prof);
        VillagerRegistry.VillagerCareer villager = new VillagerRegistry.VillagerCareer(prof, name);
        for (int i = 0; i < trades.length; ++i) {
            villager.addTrade(i + 1, trades[i]);
        }
    }

    @Override
    public void onPreInit() {
        if (this.sageEnabled) {
            this.addVillager("sage", VillagerSage.buildTrades());
        }
        if (this.druidEnabled) {
            this.addVillager("druid", VillagerDruid.buildTrades());
        }
    }

    @Override
    public void syncConfig(Configuration c) {
        String category = "cyclicmagic.villagers";
        c.addCustomCategoryComment(category, "Two new villagers with more trades");
        this.sageEnabled = c.getBoolean("SageVillagers", category, true, "Adds new villager type Sage.  Spawns naturally and from mob eggs. ");
        this.druidEnabled = c.getBoolean("DruidVillagers", category, true, "Adds new villager type Druid.  Spawns naturally and from mob eggs. ");
    }
}

