/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.tweak;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.core.util.UtilItemStack;
import com.lothrazar.cyclicmagic.core.util.UtilNBT;
import com.lothrazar.cyclicmagic.module.BaseEventModule;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MobChangesModule
extends BaseEventModule
implements IHasConfig {
    private boolean endermanDrop;
    private boolean endermanPickupBlocks;
    private boolean nameTagDeath;

    @SubscribeEvent
    public void onLivingDropsEvent(LivingDropsEvent event) {
        EntityEnderman mob;
        IBlockState bs;
        Entity entity = event.getEntity();
        World world = entity.func_130014_f_();
        if (this.nameTagDeath && entity.func_95999_t() != null && entity.func_95999_t() != "" && !world.field_72995_K) {
            ItemStack nameTag = UtilNBT.buildEnchantedNametag(entity.func_95999_t());
            UtilItemStack.dropItemStackInWorld(world, entity.func_180425_c(), nameTag);
        }
        if (this.endermanDrop && entity instanceof EntityEnderman && (bs = (mob = (EntityEnderman)entity).func_175489_ck()) != null && bs.func_177230_c() != null && !world.field_72995_K) {
            UtilItemStack.dropItemStackInWorld(world, mob.func_180425_c(), bs.func_177230_c());
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "cyclicmagic.mobs";
        config.addCustomCategoryComment(category, "Changes to vanilla mobs");
        this.nameTagDeath = config.getBoolean("Name Tag Death", category, true, "When an entity dies that is named with a tag, it drops the nametag");
        this.endermanDrop = config.getBoolean("Enderman Block", category, true, "Enderman will always drop block they are carrying 100%");
        this.endermanPickupBlocks = config.getBoolean("Enderman Pickup Blocker", category, true, "False is the same as vanilla behavior.  True means that this mod will block enderman from picking up all registered blocks (does not listen to mob actions, this scans registry only once on startup and sets properties).  ");
    }

    @Override
    public void onPostInit() {
        if (this.endermanPickupBlocks) {
            for (Block registeredBlock : Block.field_149771_c) {
                if (registeredBlock == null) continue;
                try {
                    EntityEnderman.setCarriable((Block)registeredBlock, (boolean)false);
                }
                catch (Exception e) {
                    ModCyclic.logger.error("MobChangesModule: error trying to disable enderman pickup ability on ", registeredBlock.func_149739_a());
                    e.printStackTrace();
                }
            }
        }
    }
}

