/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry;

import com.lothrazar.cyclicmagic.core.util.UtilSpellCaster;
import com.lothrazar.cyclicmagic.item.cyclicwand.ItemCyclicWand;
import com.lothrazar.cyclicmagic.spell.ISpell;
import com.lothrazar.cyclicmagic.spell.SpellInventory;
import com.lothrazar.cyclicmagic.spell.SpellRangeBuild;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class SpellRegistry {
    private static Map<Integer, ISpell> hashbook;
    public static boolean doParticles;

    public static void register(ItemCyclicWand wand) {
        hashbook = new HashMap<Integer, ISpell>();
        Spells.inventory = new SpellInventory(0, "inventory");
        SpellRegistry.registerSpell(Spells.inventory);
        Spells.reachup = new SpellRangeBuild(4, "reachup", SpellRangeBuild.PlaceType.UP);
        SpellRegistry.registerSpell(Spells.reachup);
        Spells.reachplace = new SpellRangeBuild(5, "reachplace", SpellRangeBuild.PlaceType.PLACE);
        SpellRegistry.registerSpell(Spells.reachplace);
        Spells.reachdown = new SpellRangeBuild(6, "reachdown", SpellRangeBuild.PlaceType.DOWN);
        SpellRegistry.registerSpell(Spells.reachdown);
        Spells.reachleft = new SpellRangeBuild(7, "reachleft", SpellRangeBuild.PlaceType.LEFT);
        SpellRegistry.registerSpell(Spells.reachleft);
        Spells.reachright = new SpellRangeBuild(8, "reachright", SpellRangeBuild.PlaceType.RIGHT);
        SpellRegistry.registerSpell(Spells.reachright);
        ArrayList<ISpell> spellbookBuild = new ArrayList<ISpell>();
        spellbookBuild.add(Spells.inventory);
        spellbookBuild.add(Spells.reachup);
        spellbookBuild.add(Spells.reachplace);
        spellbookBuild.add(Spells.reachdown);
        spellbookBuild.add(Spells.reachleft);
        spellbookBuild.add(Spells.reachright);
        wand.setSpells(spellbookBuild);
    }

    private static void registerSpell(ISpell spell) {
        hashbook.put(spell.getID(), spell);
    }

    public static boolean spellsEnabled(EntityPlayer player) {
        return UtilSpellCaster.getPlayerWandIfHeld(player) != null;
    }

    public static ISpell getSpellFromID(int id) {
        if (hashbook.containsKey(id)) {
            return hashbook.get(id);
        }
        return null;
    }

    public static List<ISpell> getSpellbook(ItemStack wand) {
        if (!(wand.func_77973_b() instanceof ItemCyclicWand)) {
            return new ArrayList<ISpell>();
        }
        return ((ItemCyclicWand)wand.func_77973_b()).getSpells();
    }

    public static ISpell next(ItemStack wand, ISpell spell) {
        List<ISpell> book = SpellRegistry.getSpellbook(wand);
        int indexCurrent = book.indexOf(spell);
        int indexNext = indexCurrent + 1;
        if (indexNext >= book.size()) {
            indexNext = 0;
        }
        return book.get(indexNext);
    }

    public static ISpell prev(ItemStack wand, ISpell spell) {
        List<ISpell> book = SpellRegistry.getSpellbook(wand);
        int indexCurrent = book.indexOf(spell);
        int indexPrev = indexCurrent <= 0 ? book.size() - 1 : indexCurrent - 1;
        ISpell ret = book.get(indexPrev);
        return ret;
    }

    public static class Spells {
        private static SpellInventory inventory;
        private static SpellRangeBuild reachdown;
        private static SpellRangeBuild reachup;
        private static SpellRangeBuild reachplace;
        private static SpellRangeBuild reachleft;
        private static SpellRangeBuild reachright;
    }
}

