/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.cable.BlockCableBase;
import com.lothrazar.cyclicmagic.block.ore.BlockDimensionOre;
import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.core.IHasOreDict;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.block.IBlockHasTESR;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.guide.GuideRegistry;
import com.lothrazar.cyclicmagic.item.cannon.EntityGolemLaser;
import com.lothrazar.cyclicmagic.item.cannon.RenderEmberPacket;
import com.lothrazar.cyclicmagic.item.crashtestdummy.EntityRobot;
import com.lothrazar.cyclicmagic.item.crashtestdummy.RenderRobot;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.ConfigRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemRegistry {
    public static List<Item> itemList = new ArrayList<Item>();

    public static void register(Item item, String key, GuideCategory cat) {
        item.func_77655_b(key);
        item.setRegistryName(new ResourceLocation("cyclicmagic", key));
        itemList.add(item);
        item.func_77637_a((CreativeTabs)ModCyclic.TAB);
        if (item instanceof IHasConfig) {
            ConfigRegistry.register((IHasConfig)item);
        }
        IRecipe recipe = null;
        if (item instanceof IHasRecipe) {
            recipe = ((IHasRecipe)item).addRecipe();
        }
        if (cat != null) {
            GuideRegistry.register(cat, item, recipe, null);
        }
    }

    public static void register(Item item, String key) {
        ItemRegistry.register(item, key, GuideCategory.ITEM);
    }

    @SubscribeEvent
    public static void onRegistryEvent(RegistryEvent.Register<Item> event) {
        for (Item item : itemList) {
            BlockDimensionOre ore;
            Block blockItem;
            event.getRegistry().register((IForgeRegistryEntry)item);
            if (item instanceof IHasOreDict) {
                OreDictionary.registerOre((String)((IHasOreDict)item).getOreDict(), (Item)item);
            }
            if ((blockItem = Block.func_149634_a((Item)item)) == null || blockItem == Blocks.field_150350_a) continue;
            if (blockItem instanceof IHasOreDict) {
                String oreName = ((IHasOreDict)blockItem).getOreDict();
                OreDictionary.registerOre((String)oreName, (Block)blockItem);
                ModCyclic.logger.info("Registered ore dict entry " + oreName + " : " + blockItem);
            }
            if (blockItem instanceof BlockDimensionOre && (ore = (BlockDimensionOre)blockItem).getSmeltingOutput() != null) {
                GameRegistry.addSmelting((Item)item, (ItemStack)ore.getSmeltingOutput(), (float)1.0f);
            }
            if (!(blockItem instanceof IHasRecipe)) continue;
            ((IHasRecipe)blockItem).addRecipe();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        String name;
        RenderingRegistry.registerEntityRenderingHandler(EntityRobot.class, (IRenderFactory)new RenderRobot.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityGolemLaser.class, (Render)new RenderEmberPacket(Minecraft.func_71410_x().func_175598_ae()));
        StateMapperBase STATE_MAPPER = new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(state.func_177230_c().getRegistryName(), "normal");
            }
        };
        for (Item item : itemList) {
            if (item instanceof ItemBlock) continue;
            name = "cyclicmagic:" + item.func_77658_a().replaceAll("item.", "");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
        }
        for (Block b : BlockRegistry.blocks) {
            Item item = Item.func_150898_a((Block)b);
            if (b instanceof BlockCableBase) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("cyclicmagic", b.func_149739_a().replaceAll("tile.", "")), "inventory"));
                ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)STATE_MAPPER);
                continue;
            }
            name = "cyclicmagic:" + b.func_149739_a().replaceAll("tile.", "");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(name));
            if (!(b instanceof IBlockHasTESR)) continue;
            ((IBlockHasTESR)b).initModel();
        }
    }
}

