/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.playerupgrade;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilParticle;
import com.lothrazar.cyclicmagic.core.util.UtilSound;
import com.lothrazar.cyclicmagic.registry.CapabilityRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAppleStep
extends ItemFood
implements IHasRecipe,
IHasConfig {
    public static boolean defaultPlayerStepUp = false;

    public ItemAppleStep() {
        super(4, false);
        this.func_77848_i();
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        CapabilityRegistry.IPlayerExtendedProperties data;
        boolean previousOn = (data = CapabilityRegistry.getPlayerProperties(player)).isStepHeightOn();
        data.setStepHeightOn(!previousOn);
        if (previousOn) {
            UtilSound.playSound(player, player.func_180425_c(), SoundRegistry.step_height_down, SoundCategory.PLAYERS, 1.0f);
            data.setForceStepOff(true);
        } else {
            UtilSound.playSound(player, SoundRegistry.step_height_up);
        }
        UtilParticle.spawnParticle(world, EnumParticleTypes.CRIT_MAGIC, player.func_180425_c());
        UtilParticle.spawnParticle(world, EnumParticleTypes.CRIT_MAGIC, player.func_180425_c().func_177984_a());
        if (player.func_130014_f_().field_72995_K) {
            UtilChat.addChatMessage(player, "unlocks.stepheight." + !previousOn);
        }
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapelessRecipe(new ItemStack((Item)this), "dyeCyan", "dyeOrange", Blocks.field_150329_H, Items.field_151034_e);
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            CapabilityRegistry.IPlayerExtendedProperties data = CapabilityRegistry.getPlayerProperties(player);
            if (data.isStepHeightOn()) {
                player.field_70138_W = player.func_70093_af() ? 0.9f : 1.0625f;
            } else if (data.doForceStepOff()) {
                data.setForceStepOff(false);
                player.field_70138_W = 0.6f;
                ModCyclic.logger.log(player.field_70138_W + "disabled step height" + player.field_70170_p.field_72995_K);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(UtilChat.lang(this.func_77658_a() + ".tooltip"));
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    @Override
    public void syncConfig(Configuration config) {
        defaultPlayerStepUp = config.getBoolean("StepHeightDefault", "cyclicmagic.player", false, "Set the players default step height value.  False is just like normal minecraft, true means step height is one full block.   Only applies to new players the first time they join the world.  Regardless of setting this can still be toggled with Apple of Lofty Stature.  ");
    }
}

