/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.net;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilItemStack;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketEntityDropRandom
implements IMessage,
IMessageHandler<PacketEntityDropRandom, IMessage> {
    private int entityId;
    private int slot;
    private ItemStack stack;

    public PacketEntityDropRandom() {
    }

    public PacketEntityDropRandom(int entityid, int level, ItemStack st) {
        this.entityId = entityid;
        this.slot = level;
        this.stack = st;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        this.entityId = tags.func_74762_e("entityId");
        this.slot = tags.func_74762_e("level");
        this.stack = new ItemStack(tags.func_74775_l("stack"));
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("entityId", this.entityId);
        tags.func_74768_a("level", this.slot);
        tags.func_74782_a("stack", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    public IMessage onMessage(final PacketEntityDropRandom message, final MessageContext ctx) {
        if (ctx.side.isServer()) {
            MinecraftServer s = FMLCommonHandler.instance().getMinecraftServerInstance();
            s.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    PacketEntityDropRandom.this.handle(message, ctx);
                }
            });
        }
        return null;
    }

    private void handle(PacketEntityDropRandom message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        World world = player.func_130014_f_();
        ModCyclic.logger.log("packet entityid" + message.entityId);
        Entity entityTarget = world.func_73045_a(message.entityId);
        if (entityTarget != null && entityTarget instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)entityTarget;
            EntityEquipmentSlot slot = EntityEquipmentSlot.values()[message.slot];
            ModCyclic.logger.log(entity.func_70005_c_() + "!PACKET!!!DROP SLOT " + slot + " " + message.stack.func_82833_r());
            UtilItemStack.dropItemStackInWorld(world, entity.func_180425_c().func_177981_b(5), message.stack);
            entity.func_184201_a(slot, ItemStack.field_190927_a);
            if (entity instanceof EntityPlayer) {
                UtilChat.addChatMessage((EntityPlayer)entity, "potion.butter.oops");
            }
        } else {
            ModCyclic.logger.log("NOT FOUND packet entityid" + message.entityId);
        }
    }
}

