/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.storagesack;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.item.BaseItem;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilInventoryTransfer;
import com.lothrazar.cyclicmagic.core.util.UtilNBT;
import com.lothrazar.cyclicmagic.core.util.UtilSound;
import com.lothrazar.cyclicmagic.item.storagesack.InventoryStorage;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemStorageBag
extends BaseItem
implements IHasRecipe {
    private static final String GUI_ID = "guiID";

    public ItemStorageBag() {
        this.func_77625_d(1);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        int size = InventoryStorage.countNonEmpty(stack);
        tooltip.add(UtilChat.lang("item.storage_bag.tooltip") + size);
        tooltip.add(UtilChat.lang("item.storage_bag.tooltip2") + UtilChat.lang(StorageActionType.getName(stack)));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        StorageActionType.tickTimeout(stack);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @SubscribeEvent
    public void onHit(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (held != null && held.func_77973_b() == this) {
            World world = event.getWorld();
            TileEntity tile = event.getWorld().func_175625_s(event.getPos());
            if (tile != null && tile instanceof IInventory) {
                int depositType = StorageActionType.get(held);
                if (depositType == StorageActionType.NOTHING.ordinal()) {
                    if (world.field_72995_K) {
                        UtilChat.addChatMessage(player, UtilChat.lang("item.storage_bag.disabled"));
                    }
                    return;
                }
                if (!world.field_72995_K) {
                    NonNullList<ItemStack> inv = InventoryStorage.readFromNBT(held);
                    UtilInventoryTransfer.BagDepositReturn ret = null;
                    if (depositType == StorageActionType.DEPOSIT.ordinal()) {
                        ret = UtilInventoryTransfer.dumpFromListToIInventory(world, (IInventory)tile, inv, false);
                    } else if (depositType == StorageActionType.MERGE.ordinal()) {
                        ret = UtilInventoryTransfer.dumpFromListToIInventory(world, (IInventory)tile, inv, true);
                    }
                    if (ret != null && ret.moved > 0) {
                        InventoryStorage.writeToNBT(held, ret.stacks);
                        UtilChat.addChatMessage(player, UtilChat.lang("item.storage_bag.success") + ret.moved);
                    }
                }
                UtilSound.playSound(player, SoundRegistry.sack_holding);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack wand = player.func_184586_b(hand);
        this.setIdIfEmpty(wand);
        if (!world.field_72995_K && wand.func_77973_b() instanceof ItemStorageBag && hand == EnumHand.MAIN_HAND) {
            BlockPos pos = player.func_180425_c();
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            player.openGui((Object)ModCyclic.instance, 3, world, x, y, z);
        }
        return super.func_77659_a(world, player, hand);
    }

    private void setIdIfEmpty(ItemStack wand) {
        if (!UtilNBT.getItemStackNBT(wand).func_74764_b(GUI_ID) || UtilNBT.getItemStackNBT(wand).func_74779_i(GUI_ID) == null) {
            UtilNBT.setItemStackNBTVal(wand, GUI_ID, UUID.randomUUID().toString());
        }
    }

    public static String getId(ItemStack wand) {
        return UtilNBT.getItemStackNBT(wand).func_74779_i(GUI_ID);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), "lsl", "ldl", "lrl", Character.valueOf('l'), "leather", Character.valueOf('s'), "string", Character.valueOf('r'), "dustRedstone", Character.valueOf('d'), "ingotGold");
    }

    public static enum StorageActionType {
        NOTHING,
        DEPOSIT,
        MERGE;

        private static final String NBT_COLOUR = "COLOUR";
        private static final String NBT = "build";
        private static final String NBTTIMEOUT = "timeout";

        public static int getTimeout(ItemStack wand) {
            return UtilNBT.getItemStackNBT(wand).func_74762_e(NBTTIMEOUT);
        }

        public static void setTimeout(ItemStack wand) {
            UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, 15);
        }

        public static void tickTimeout(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int t = tags.func_74762_e(NBTTIMEOUT);
            if (t > 0) {
                UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, t - 1);
            }
        }

        public static int get(ItemStack wand) {
            if (wand == null) {
                return 0;
            }
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            return tags.func_74762_e(NBT);
        }

        public static String getName(ItemStack wand) {
            try {
                NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
                return "item.storage_bag." + StorageActionType.values()[tags.func_74762_e(NBT)].toString().toLowerCase();
            }
            catch (Exception e) {
                return "item.storage_bag." + NOTHING.toString().toLowerCase();
            }
        }

        public static void toggle(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            int type = tags.func_74762_e(NBT);
            if (++type > MERGE.ordinal()) {
                type = NOTHING.ordinal();
            }
            tags.func_74768_a(NBT, type);
            wand.func_77982_d(tags);
        }

        public static int getColour(ItemStack wand) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            if (!tags.func_74764_b(NBT_COLOUR)) {
                return EnumDyeColor.BROWN.func_193350_e();
            }
            return tags.func_74762_e(NBT_COLOUR);
        }

        public static void setColour(ItemStack wand, int color) {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            tags.func_74768_a(NBT_COLOUR, color);
            wand.func_77982_d(tags);
        }
    }
}

