/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.sleep;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.item.BaseTool;
import com.lothrazar.cyclicmagic.core.item.IHasClickToggle;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilNBT;
import com.lothrazar.cyclicmagic.item.sleep.PacketSleepClient;
import com.lothrazar.cyclicmagic.registry.CapabilityRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUseBed;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSleepingMat
extends BaseTool
implements IHasRecipe,
IHasConfig,
IHasClickToggle {
    private static final String NBT_STATUS = "cyclic_spawn";
    private static int seconds;
    public static boolean doPotions;

    public ItemSleepingMat() {
        super(100);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        if (!world.field_72995_K) {
            EntityPlayerMP mp = (EntityPlayerMP)player;
            EntityPlayer.SleepResult result = this.canPlayerSleep(player, world);
            if (result == EntityPlayer.SleepResult.OK) {
                CapabilityRegistry.IPlayerExtendedProperties sleep = CapabilityRegistry.getPlayerProperties(player);
                if (sleep != null) {
                    this.onSleepSuccess(world, hand, stack, mp, sleep);
                } else {
                    UtilChat.sendStatusMessage(player, "tile.bed.noSleep");
                }
            } else {
                UtilChat.sendStatusMessage(player, "tile.bed.noSleep");
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public void onSleepSuccess(World world, EnumHand hand, ItemStack stack, EntityPlayerMP player, CapabilityRegistry.IPlayerExtendedProperties sleep) {
        sleep.setSleeping(true);
        if (doPotions) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, seconds * 20, 0));
            player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, seconds * 20, 0));
        }
        this.onUse(stack, (EntityPlayer)player, world, hand);
        ObfuscationReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)true, (String[])new String[]{"sleeping", "field_71083_bS"});
        ObfuscationReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)0, (String[])new String[]{"sleepTimer", "field_71076_b"});
        UtilChat.sendStatusMessage((EntityPlayer)player, this.func_77658_a() + ".trying");
        player.field_71081_bT = player.func_180425_c();
        ModCyclic.network.sendTo((IMessage)new PacketSleepClient(player.field_71081_bT), player);
        player.field_70181_x = 0.0;
        player.field_70179_y = 0.0;
        player.field_70159_w = 0.0;
        world.func_72854_c();
        SPacketUseBed sleepPacket = new SPacketUseBed((EntityPlayer)player, player.func_180425_c());
        player.func_71121_q().func_73039_n().func_151247_a((Entity)player, (Packet)sleepPacket);
        player.field_71135_a.func_147359_a((Packet)sleepPacket);
        if (this.isOn(stack)) {
            player.func_180473_a(player.func_180425_c(), true);
        }
    }

    private EntityPlayer.SleepResult canPlayerSleep(EntityPlayer player, World world) {
        if (!player.func_70089_S()) {
            return EntityPlayer.SleepResult.OTHER_PROBLEM;
        }
        if (world.func_72935_r()) {
            return EntityPlayer.SleepResult.NOT_POSSIBLE_NOW;
        }
        PlayerSleepInBedEvent event = new PlayerSleepInBedEvent(player, player.func_180425_c());
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResultStatus() != null) {
            return event.getResultStatus();
        }
        return EntityPlayer.SleepResult.OK;
    }

    @SubscribeEvent
    public void onBedCheck(SleepingLocationCheckEvent event) {
        EntityPlayer p = event.getEntityPlayer();
        CapabilityRegistry.IPlayerExtendedProperties sleep = (CapabilityRegistry.IPlayerExtendedProperties)p.getCapability(ModCyclic.CAPABILITYSTORAGE, null);
        if (sleep != null && sleep.isSleeping()) {
            if (p.func_70093_af()) {
                sleep.setSleeping(false);
            } else {
                p.field_71081_bT = p.func_180425_c();
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public void handleSleepInBed(PlayerSleepInBedEvent event) {
        EntityPlayer p = event.getEntityPlayer();
        CapabilityRegistry.IPlayerExtendedProperties sleep = (CapabilityRegistry.IPlayerExtendedProperties)p.getCapability(ModCyclic.CAPABILITYSTORAGE, null);
        if (sleep != null && sleep.isSleeping()) {
            event.setResult(EntityPlayer.SleepResult.OK);
        }
    }

    @SubscribeEvent
    public void onWakeUp(PlayerWakeUpEvent evt) {
        EntityPlayer p = evt.getEntityPlayer();
        CapabilityRegistry.IPlayerExtendedProperties sleep = (CapabilityRegistry.IPlayerExtendedProperties)p.getCapability(ModCyclic.CAPABILITYSTORAGE, null);
        if (sleep != null && sleep.isSleeping()) {
            sleep.setSleeping(false);
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        doPotions = config.getBoolean("SleepingMatPotions", "cyclicmagic.items", false, "False will disable the potion effects given by the Sleeping Mat");
        seconds = config.getInt("SleepingMatPotion", "modpacks", 20, 0, 600, "Seconds of potion effect caused by using the sleeping mat");
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapelessRecipe(new ItemStack((Item)this), new ItemStack(Blocks.field_150325_L, 1, EnumDyeColor.RED.func_176765_a()), "leather");
    }

    public static void setRenderOffsetForSleep(EntityPlayer mp, EnumFacing fac) {
        mp.field_71079_bU = -1.8f * (float)fac.func_82601_c();
        mp.field_71089_bV = -1.8f * (float)fac.func_82599_e();
        try {
            Method m = ReflectionHelper.findMethod(Entity.class, (String)"setSize", (String)"func_70105_a", (Class[])new Class[]{Float.TYPE, Float.TYPE});
            if (m != null) {
                m.invoke((Object)mp, Float.valueOf(0.2f), Float.valueOf(0.2f));
            } else {
                ModCyclic.logger.error("Private function not found on " + Entity.class.getName() + " : setSize");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void toggle(EntityPlayer player, ItemStack held) {
        NBTTagCompound tags = UtilNBT.getItemStackNBT(held);
        int vnew = this.isOn(held) ? 0 : 1;
        tags.func_74768_a(NBT_STATUS, vnew);
    }

    @Override
    public boolean isOn(ItemStack held) {
        NBTTagCompound tags = UtilNBT.getItemStackNBT(held);
        if (!tags.func_74764_b(NBT_STATUS)) {
            return false;
        }
        return tags.func_74762_e(NBT_STATUS) == 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack held, World player, List<String> list, ITooltipFlag par4) {
        super.func_77624_a(held, player, list, par4);
        String onoff = this.isOn(held) ? "on" : "off";
        list.add(UtilChat.lang("item.sleeping_mat.tooltip.info") + UtilChat.lang("item.sleeping_mat.tooltip." + onoff));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isOn(stack);
    }
}

