/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.signcolor;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.core.gui.GuiButtonTooltip;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.gui.ITooltipButton;
import com.lothrazar.cyclicmagic.net.PacketTileClientToServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiSignEditor
extends GuiScreen {
    private static final int rowHeight = 22;
    protected ArrayList<GuiTextField> txtBoxes = new ArrayList();
    private final EntityPlayer entityPlayer;
    private ItemStack bookStack;
    final int maxNameLen = 100;
    private TileEntitySign sign;
    List<Map<TextFormatting, GuiButtonTooltip>> buttonMaps = new ArrayList<Map<TextFormatting, GuiButtonTooltip>>();
    public static int buttonIdNew;
    GuiButton buttonNew;
    final int DELETE_OFFSET = 1000;

    public GuiSignEditor(EntityPlayer entityPlayer, ItemStack book, TileEntitySign te) {
        this.entityPlayer = entityPlayer;
        this.bookStack = book;
        this.sign = te;
        this.buttonMaps.add(new HashMap());
        this.buttonMaps.add(new HashMap());
        this.buttonMaps.add(new HashMap());
        this.buttonMaps.add(new HashMap());
    }

    public void func_73866_w_() {
        int predictedWidth = 398;
        int leftover = this.field_146294_l - predictedWidth;
        Keyboard.enableRepeatEvents((boolean)true);
        if (!this.bookStack.func_77942_o()) {
            this.bookStack.func_77982_d(new NBTTagCompound());
        }
        int buttonID = 700;
        int w = 100;
        int h = 20;
        int x = leftover / 2;
        int y = 20;
        GuiTextField txtNew0 = new GuiTextField(buttonID++, this.field_146289_q, x, y, w, h);
        txtNew0.func_146203_f(100);
        txtNew0.func_146195_b(true);
        txtNew0.func_146180_a(this.sign.field_145915_a[0].func_150260_c());
        this.txtBoxes.add(txtNew0);
        GuiTextField txtNew1 = new GuiTextField(buttonID++, this.field_146289_q, x, y += 22, w, h);
        txtNew1.func_146203_f(100);
        this.txtBoxes.add(txtNew1);
        txtNew1.func_146180_a(this.sign.field_145915_a[1].func_150260_c());
        GuiTextField txtNew2 = new GuiTextField(buttonID++, this.field_146289_q, x, y += 22, w, h);
        txtNew2.func_146203_f(100);
        txtNew2.func_146180_a(this.sign.field_145915_a[2].func_150260_c());
        this.txtBoxes.add(txtNew2);
        GuiTextField txtNew3 = new GuiTextField(buttonID++, this.field_146289_q, x, y += 22, w, h);
        txtNew3.func_146203_f(100);
        txtNew3.func_146180_a(this.sign.field_145915_a[3].func_150260_c());
        this.txtBoxes.add(txtNew3);
        this.addButtonRowForTextbox(0, 24, x + w - 16);
        this.addButtonRowForTextbox(1, 46, x + w - 16);
        this.addButtonRowForTextbox(2, 68, x + w - 16);
        this.addButtonRowForTextbox(3, 90, x + w - 16);
        GuiButtonTooltip buttonSave = new GuiButtonTooltip(800, this.field_146294_l / 2 - w, 150, w, h, "gui.signs.save");
        this.func_189646_b((GuiButton)buttonSave);
        GuiButtonTooltip buttonClose = new GuiButtonTooltip(801, this.field_146294_l / 2, 150, w, h, "gui.signs.cancel");
        this.func_189646_b((GuiButton)buttonClose);
    }

    private void addButtonRowForTextbox(int signRowNum, int height, int leftMost) {
        GuiButtonTooltip btn;
        Map<TextFormatting, GuiButtonTooltip> rowButtons = this.buttonMaps.get(signRowNum);
        int buttonID = signRowNum * 100;
        int x = leftMost;
        int y = height;
        int h = 14;
        int w = 14;
        for (TextFormatting color : TextFormatting.values()) {
            if (!color.func_96302_c()) continue;
            btn = new GuiButtonTooltip(buttonID++, x + 40, y, w, h, GuiSignEditor.getColorChar(color));
            btn.allowPressedIfDisabled().setTooltip(color + color.func_96297_d());
            btn.packedFGColour = GuiSignEditor.toHex(color);
            this.func_189646_b((GuiButton)btn);
            x += w - 1;
            rowButtons.put(color, btn);
        }
        x += w * 3 + 2;
        y = height;
        for (TextFormatting color : TextFormatting.values()) {
            if (color.func_96302_c() || color == TextFormatting.RESET) continue;
            btn = new GuiButtonTooltip(buttonID++, x, y, w, h, GuiSignEditor.getFontChar(color));
            btn.allowPressedIfDisabled().setTooltip(color + color.func_96297_d());
            this.func_189646_b((GuiButton)btn);
            x += w;
            rowButtons.put(color, btn);
        }
    }

    public static String getColorChar(TextFormatting color) {
        if (color == null) {
            return "";
        }
        return color + Integer.toHexString(color.ordinal()).toUpperCase();
    }

    public static String getFontChar(TextFormatting color) {
        if (color == null) {
            return "";
        }
        return color + color.func_96297_d().substring(0, 1);
    }

    public static int toHex(TextFormatting color) {
        switch (color) {
            case BLACK: {
                return 65793;
            }
            case DARK_BLUE: {
                return 170;
            }
            case DARK_GREEN: {
                return 43520;
            }
            case DARK_AQUA: {
                return 43690;
            }
            case DARK_RED: {
                return 0xAA0000;
            }
            case DARK_PURPLE: {
                return 0xAA00AA;
            }
            case GOLD: {
                return 0xFFAA00;
            }
            case GRAY: {
                return 0xAAAAAA;
            }
            case DARK_GRAY: {
                return 0x555555;
            }
            case BLUE: {
                return 0x5555FF;
            }
            case GREEN: {
                return 0x55FF55;
            }
            case AQUA: {
                return 0x55FFFF;
            }
            case RED: {
                return 0xFF5555;
            }
            case LIGHT_PURPLE: {
                return 0xFF55FF;
            }
            case YELLOW: {
                return 0xFFFF55;
            }
            case WHITE: {
                return 0xFFFFFF;
            }
        }
        return -1;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int x, int y, float par3) {
        this.func_146276_q_();
        super.func_73863_a(x, y, par3);
        this.func_73732_a(this.field_146289_q, UtilChat.lang("gui.signs.title"), this.field_146294_l / 2, 6, 0xFFFFFF);
        for (GuiTextField txtNew : this.txtBoxes) {
            if (txtNew == null) continue;
            txtNew.func_146194_f();
        }
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            if (!((GuiButton)this.field_146292_n.get(i)).func_146115_a() || !(this.field_146292_n.get(i) instanceof ITooltipButton)) continue;
            ITooltipButton btn = (ITooltipButton)this.field_146292_n.get(i);
            this.drawHoveringText(btn.getTooltips(), x, y, this.field_146289_q);
        }
        for (int row = 0; row < this.sign.field_145915_a.length; ++row) {
            ITextComponent text = this.sign.field_145915_a[row];
            Style style = text.func_150256_b();
            Map<TextFormatting, GuiButtonTooltip> buttons = this.buttonMaps.get(row);
            buttons.get((Object)TextFormatting.ITALIC).field_146124_l = !style.func_150242_c();
            buttons.get((Object)TextFormatting.BOLD).field_146124_l = !style.func_150223_b();
            buttons.get((Object)TextFormatting.OBFUSCATED).field_146124_l = !style.func_150233_f();
            buttons.get((Object)TextFormatting.STRIKETHROUGH).field_146124_l = !style.func_150236_d();
            buttons.get((Object)TextFormatting.UNDERLINE).field_146124_l = !style.func_150234_e();
            for (TextFormatting color : TextFormatting.values()) {
                if (!color.func_96302_c()) continue;
                buttons.get((Object)color).field_146124_l = style.func_150215_a() != color;
            }
        }
    }

    protected void func_146284_a(GuiButton btn) {
        if (btn.field_146127_k == 800) {
            this.syncTextboxesToSign();
            NBTTagCompound tags = new NBTTagCompound();
            this.sign.func_189515_b(tags);
            ModCyclic.network.sendToServer((IMessage)new PacketTileClientToServer(this.sign.func_174877_v(), tags));
            this.entityPlayer.func_71053_j();
            return;
        }
        if (btn.field_146127_k == 801) {
            this.entityPlayer.func_71053_j();
            return;
        }
        int row = btn.field_146127_k / 100;
        int col = btn.field_146127_k % 100;
        Style style = this.sign.field_145915_a[row].func_150256_b();
        TextComponentString text = new TextComponentString(this.txtBoxes.get(row).func_146179_b());
        if (col <= 15) {
            style.func_150238_a(TextFormatting.values()[col]);
        } else {
            TextFormatting font = TextFormatting.values()[col];
            switch (font) {
                case BOLD: {
                    style.func_150227_a(Boolean.valueOf(!style.func_150223_b()));
                    break;
                }
                case OBFUSCATED: {
                    style.func_150237_e(Boolean.valueOf(!style.func_150233_f()));
                    break;
                }
                case STRIKETHROUGH: {
                    style.func_150225_c(Boolean.valueOf(!style.func_150236_d()));
                    break;
                }
                case UNDERLINE: {
                    style.func_150228_d(Boolean.valueOf(!style.func_150234_e()));
                    break;
                }
                case ITALIC: {
                    style.func_150217_b(Boolean.valueOf(!style.func_150242_c()));
                }
            }
        }
        text.func_150255_a(style);
        this.sign.field_145915_a[row] = text;
    }

    private void syncTextboxesToSign() {
        for (GuiTextField txtNew : this.txtBoxes) {
            int id = txtNew.func_175206_d() - 700;
            Style style = this.sign.field_145915_a[id].func_150256_b();
            TextComponentString text = new TextComponentString(txtNew.func_146179_b());
            text.func_150255_a(style);
            this.sign.field_145915_a[id] = text;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiTextField txtNew : this.txtBoxes) {
            if (txtNew == null) continue;
            txtNew.func_146178_a();
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        for (GuiTextField txtNew : this.txtBoxes) {
            if (txtNew == null) continue;
            txtNew.func_146201_a(par1, par2);
        }
    }

    protected void func_73864_a(int x, int y, int btn) throws IOException {
        super.func_73864_a(x, y, btn);
        for (GuiTextField txtNew : this.txtBoxes) {
            if (txtNew == null) continue;
            txtNew.func_146192_a(x, y, btn);
        }
    }
}

