/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.scythe;

import com.lothrazar.cyclicmagic.core.util.UtilScythe;
import com.lothrazar.cyclicmagic.item.scythe.ItemScythe;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketScythe
implements IMessage,
IMessageHandler<PacketScythe, IMessage> {
    private BlockPos pos;
    private ItemScythe.ScytheType type;
    private int radius;

    public PacketScythe() {
    }

    public PacketScythe(BlockPos mouseover, ItemScythe.ScytheType t, int r) {
        this.pos = mouseover;
        this.type = t;
        this.radius = r;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        int x = tags.func_74762_e("x");
        int y = tags.func_74762_e("y");
        int z = tags.func_74762_e("z");
        this.pos = new BlockPos(x, y, z);
        int t = tags.func_74762_e("t");
        this.type = ItemScythe.ScytheType.values()[t];
        this.radius = tags.func_74762_e("s");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("x", this.pos.func_177958_n());
        tags.func_74768_a("y", this.pos.func_177956_o());
        tags.func_74768_a("z", this.pos.func_177952_p());
        tags.func_74768_a("t", this.type.ordinal());
        tags.func_74768_a("s", this.radius);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    public IMessage onMessage(final PacketScythe message, final MessageContext ctx) {
        MinecraftServer s = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (s == null) {
            this.handle(message, ctx);
        } else {
            s.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    PacketScythe.this.handle(message, ctx);
                }
            });
        }
        return null;
    }

    private void handle(PacketScythe message, MessageContext ctx) {
        if (ctx.side.isServer() && message != null && message.pos != null) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.func_130014_f_();
            List<BlockPos> shape = ItemScythe.getShape(message.pos, message.radius);
            for (BlockPos posCurrent : shape) {
                UtilScythe.harvestSingle(world, (EntityPlayer)player, posCurrent, message.type);
            }
        }
    }
}

