/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.scythe;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.item.BaseTool;
import com.lothrazar.cyclicmagic.core.util.UtilHarvester;
import com.lothrazar.cyclicmagic.core.util.UtilItemStack;
import com.lothrazar.cyclicmagic.core.util.UtilShape;
import com.lothrazar.cyclicmagic.item.scythe.PacketScythe;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemScythe
extends BaseTool
implements IHasRecipe {
    private static final int RADIUS = 6;
    private static final int RADIUS_SNEAKING = 2;
    private ScytheType harvestType;

    public ItemScythe(ScytheType c) {
        super(1000);
        this.harvestType = c;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        BlockPos offset = pos;
        if (side != null) {
            offset = pos.func_177972_a(side);
        }
        int radius = player.func_70093_af() ? 2 : 6;
        List<BlockPos> shape = ItemScythe.getShape(offset, radius);
        switch (this.harvestType) {
            case CROPS: {
                NonNullList drops = NonNullList.func_191196_a();
                for (BlockPos p : shape) {
                    drops.addAll(UtilHarvester.harvestSingle(world, p));
                }
                for (ItemStack d : drops) {
                    UtilItemStack.dropItemStackInWorld(world, player.func_180425_c(), d);
                }
                break;
            }
            case LEAVES: 
            case WEEDS: {
                if (!world.field_72995_K) break;
                ModCyclic.network.sendToServer((IMessage)new PacketScythe(pos, this.harvestType, radius));
            }
        }
        super.onUse(stack, player, world, hand);
        return super.func_180614_a(player, world, offset, hand, side, hitX, hitY, hitZ);
    }

    public static List<BlockPos> getShape(BlockPos center, int radius) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        shape.addAll(UtilShape.squareHorizontalFull(center.func_177977_b().func_177977_b(), radius));
        shape.addAll(UtilShape.squareHorizontalFull(center.func_177977_b(), radius));
        shape.addAll(UtilShape.squareHorizontalFull(center, radius));
        shape.addAll(UtilShape.squareHorizontalFull(center.func_177984_a(), radius));
        shape.addAll(UtilShape.squareHorizontalFull(center.func_177984_a().func_177984_a(), radius));
        return shape;
    }

    @Override
    public IRecipe addRecipe() {
        switch (this.harvestType) {
            case CROPS: {
                return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " gs", " bg", "b  ", Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('g'), "gemQuartz", Character.valueOf('s'), Items.field_151018_J);
            }
            case LEAVES: {
                return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " gs", " bg", "b  ", Character.valueOf('b'), Items.field_151055_y, Character.valueOf('g'), "string", Character.valueOf('s'), Items.field_151049_t);
            }
            case WEEDS: {
                return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " gs", " bg", "b  ", Character.valueOf('b'), Items.field_151055_y, Character.valueOf('g'), "string", Character.valueOf('s'), Items.field_151018_J);
            }
        }
        return null;
    }

    public static enum ScytheType {
        WEEDS,
        LEAVES,
        CROPS;

    }
}

