/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.merchant;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.core.gui.GuiBaseContainer;
import com.lothrazar.cyclicmagic.core.util.Const;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.gui.ITooltipButton;
import com.lothrazar.cyclicmagic.item.merchant.ContainerMerchantBetter;
import com.lothrazar.cyclicmagic.item.merchant.InventoryMerchantBetter;
import com.lothrazar.cyclicmagic.item.merchant.PacketVillagerTrade;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiMerchantBetter
extends GuiBaseContainer {
    public static final ResourceLocation TRADE_REDX = new ResourceLocation("cyclicmagic", "textures/gui/tradex.png");
    private int btnColCount = 4;
    private int yBtnStart;
    private int lastUnusedButtonId;
    private int xBtnStart;
    EntityPlayer player;
    private int selectedMerchantRecipe;
    private List<GuiButtonPurchase> merchButtons = new ArrayList<GuiButtonPurchase>();

    public GuiMerchantBetter(InventoryPlayer ip, EntityVillager merch, InventoryMerchantBetter im, World worldIn) {
        super(new ContainerMerchantBetter(ip, merch, im, worldIn));
        this.player = ip.field_70458_d;
        this.setScreenSize(Const.ScreenSize.LARGEWIDE);
        this.field_146999_f = this.getScreenSize().width();
        this.field_147000_g = this.getScreenSize().height();
    }

    public ContainerMerchantBetter getContainer() {
        return (ContainerMerchantBetter)this.field_147002_h;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.xBtnStart = this.field_147003_i;
        this.yBtnStart = this.getMiddleY();
        this.lastUnusedButtonId = 1;
    }

    private void validateMerchantButtons() {
        MerchantRecipeList merchantrecipelist = this.getContainer().getTrades();
        int s = merchantrecipelist.size();
        int btnH = 20;
        int btnW = 56;
        int x = this.xBtnStart;
        int y = this.yBtnStart;
        for (int i = 0; i < s; ++i) {
            if (i < this.merchButtons.size()) continue;
            int currRow = i / this.btnColCount;
            int currCol = i % this.btnColCount;
            x = this.xBtnStart + currCol * btnW;
            y = this.yBtnStart + currRow * btnH;
            GuiButtonPurchase slotBtn = this.func_189646_b(new GuiButtonPurchase(this.lastUnusedButtonId, x, y, btnW, btnH, i, this));
            this.merchButtons.add(slotBtn);
            ++this.lastUnusedButtonId;
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.getContainer().setCurrentRecipeIndex(this.selectedMerchantRecipe);
        this.validateMerchantButtons();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof GuiButtonPurchase) {
            this.setAndTryPurchase((GuiButtonPurchase)button);
        }
    }

    private void setAndTryPurchase(GuiButtonPurchase button) {
        this.selectedMerchantRecipe = button.getRecipeIndex();
        this.getContainer().setCurrentRecipeIndex(this.selectedMerchantRecipe);
        ModCyclic.network.sendToServer((IMessage)new PacketVillagerTrade(this.selectedMerchantRecipe));
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.getScreenSize().texture());
        int thisX = this.getMiddleX();
        int thisY = this.getMiddleY();
        boolean u = false;
        boolean v = false;
        Gui.func_146110_a((int)thisX, (int)thisY, (float)((float)u), (float)((float)v), (int)this.getScreenSize().width(), (int)this.getScreenSize().height(), (float)this.getScreenSize().width(), (float)this.getScreenSize().height());
    }

    @SideOnly(value=Side.CLIENT)
    static class GuiButtonPurchase
    extends GuiButton
    implements ITooltipButton {
        static final int rowCount = 4;
        static final int spacing = 18;
        private int recipeIndex;
        private GuiMerchantBetter parent;

        public GuiButtonPurchase(int buttonId, int x, int y, int widthIn, int heightIn, int r, GuiMerchantBetter p) {
            super(buttonId, x, y, widthIn, heightIn, "");
            this.recipeIndex = r;
            this.parent = p;
        }

        public int getRecipeIndex() {
            return this.recipeIndex;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float p) {
            super.func_191745_a(mc, mouseX, mouseY, p);
            if (this.field_146125_m) {
                MerchantRecipeList merchantrecipelist = this.parent.getContainer().getTrades();
                if (merchantrecipelist == null) {
                    return;
                }
                if (this.recipeIndex >= merchantrecipelist.size()) {
                    this.field_146125_m = false;
                    return;
                }
                this.field_146125_m = true;
                MerchantRecipe r = (MerchantRecipe)merchantrecipelist.get(this.recipeIndex);
                if (r == null) {
                    return;
                }
                int x = this.field_146128_h + 2;
                int y = this.field_146129_i + 1;
                GlStateManager.func_179094_E();
                ModCyclic.proxy.renderItemOnGui(r.func_77394_a(), this.parent.field_146296_j, this.parent.field_146289_q, x, y);
                ModCyclic.proxy.renderItemOnGui(r.func_77396_b(), this.parent.field_146296_j, this.parent.field_146289_q, x += 18, y);
                ModCyclic.proxy.renderItemOnGui(r.func_77397_d(), this.parent.field_146296_j, this.parent.field_146289_q, x += 18, y);
                GlStateManager.func_179121_F();
                RenderHelper.func_74520_c();
                if (r.func_82784_g()) {
                    this.parent.field_146297_k.func_110434_K().func_110577_a(TRADE_REDX);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179140_f();
                    int sizeOfX = 15;
                    Gui.func_146110_a((int)(x - 18), (int)(y + 1), (float)0.0f, (float)0.0f, (int)sizeOfX, (int)sizeOfX, (float)sizeOfX, (float)sizeOfX);
                }
            }
        }

        @Override
        public List<String> getTooltips() {
            Map map;
            ArrayList<String> tt = new ArrayList<String>();
            MerchantRecipeList merchantrecipelist = this.parent.getContainer().getTrades();
            if (merchantrecipelist == null) {
                return tt;
            }
            MerchantRecipe r = (MerchantRecipe)merchantrecipelist.get(this.recipeIndex);
            if (r == null) {
                return tt;
            }
            if (r.func_82784_g()) {
                tt.add(UtilChat.lang("merchant.deprecated"));
            } else {
                tt.add(UtilChat.lang("tile.tool_trade.button.tooltip"));
            }
            if (r.func_77397_d() != null && (map = EnchantmentHelper.func_82781_a((ItemStack)r.func_77397_d())) != null) {
                for (Map.Entry entry : map.entrySet()) {
                    tt.add(((Enchantment)entry.getKey()).func_77316_c(((Integer)entry.getValue()).intValue()));
                }
            }
            return tt;
        }
    }
}

