/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.fishing;

import com.lothrazar.cyclicmagic.core.entity.EntityThrowableDispensable;
import com.lothrazar.cyclicmagic.core.entity.RenderBall;
import com.lothrazar.cyclicmagic.core.util.UtilParticle;
import com.lothrazar.cyclicmagic.core.util.UtilSound;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class EntityFishingBolt
extends EntityThrowableDispensable {
    static final double plainChance = 60.0;
    static final double salmonChance = 85.0;
    static final double clownfishChance = 87.0;

    public EntityFishingBolt(World worldIn) {
        super(worldIn);
    }

    public EntityFishingBolt(World worldIn, EntityLivingBase ent) {
        super(worldIn, ent);
    }

    public EntityFishingBolt(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    @Override
    protected void processImpact(RayTraceResult mop) {
        BlockPos pos = mop.func_178782_a();
        if (pos == null) {
            return;
        }
        World world = this.func_130014_f_();
        if (this.func_70090_H()) {
            UtilParticle.spawnParticle(this.func_130014_f_(), EnumParticleTypes.WATER_BUBBLE, pos);
            EntityItem ei = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.getRandomFish());
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)ei);
            }
            UtilSound.playSound(world, pos, SoundEvents.field_187806_ee, SoundCategory.BLOCKS);
            this.func_70106_y();
        }
    }

    private ItemStack getRandomFish() {
        ItemStack fishSpawned = null;
        double diceRoll = this.field_70146_Z.nextDouble() * 100.0;
        fishSpawned = diceRoll < 60.0 ? new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.COD.func_150976_a()) : (diceRoll < 85.0 ? new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()) : (diceRoll < 87.0 ? new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.CLOWNFISH.func_150976_a()) : new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.PUFFERFISH.func_150976_a())));
        return fishSpawned;
    }

    public static class FactoryFish
    implements IRenderFactory<EntityFishingBolt> {
        public Render<? super EntityFishingBolt> createRenderFor(RenderManager rm) {
            return new RenderBall(rm, "fishing");
        }
    }
}

