/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.item.BaseTool;
import com.lothrazar.cyclicmagic.core.item.IHasClickToggle;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilEntity;
import com.lothrazar.cyclicmagic.core.util.UtilItemStack;
import com.lothrazar.cyclicmagic.core.util.UtilSound;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEnderWing
extends BaseTool
implements IHasRecipe,
IHasClickToggle {
    private static final int cooldown = 600;
    private static final int durability = 16;
    private WarpType warpType;

    public ItemEnderWing(WarpType type) {
        super(16);
        this.warpType = type;
    }

    @Override
    public void toggle(EntityPlayer player, ItemStack held) {
        this.tryActivate(player, held);
    }

    private boolean tryActivate(EntityPlayer player, ItemStack held) {
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return false;
        }
        World world = player.func_130014_f_();
        if (player.field_71093_bK != 0) {
            UtilChat.addChatMessage(player, "command.worldhome.dim");
            return false;
        }
        BlockPos target = null;
        switch (this.warpType) {
            case BED: {
                target = player.getBedLocation(0);
                if (target != null) break;
                UtilChat.addChatMessage(player, "command.gethome.bed");
                return false;
            }
            case SPAWN: {
                target = world.func_175694_M();
            }
        }
        if (target == null) {
            return false;
        }
        boolean success = UtilEntity.enderTeleportEvent((EntityLivingBase)player, world, target);
        if (success) {
            UtilItemStack.damageItem(player, held);
            UtilSound.playSound(player, SoundRegistry.warp);
            player.func_184811_cZ().func_185145_a((Item)this, 600);
        }
        return success;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.tryActivate(player, stack)) {
            super.onUse(stack, player, world, hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        switch (this.warpType) {
            case BED: {
                tooltip.add(UtilChat.lang("item.tool_warp_home.tooltip"));
                break;
            }
            case SPAWN: {
                tooltip.add(UtilChat.lang("item.tool_warp_spawn.tooltip"));
                break;
            }
        }
    }

    @Override
    public IRecipe addRecipe() {
        switch (this.warpType) {
            case BED: {
                return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " ft", "ggf", "dg ", Character.valueOf('t'), "blockQuartz", Character.valueOf('f'), "feather", Character.valueOf('g'), "ingotGold", Character.valueOf('d'), new ItemStack(Items.field_151061_bv));
            }
            case SPAWN: {
                return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " ff", "ggf", "dg ", Character.valueOf('f'), "feather", Character.valueOf('g'), "nuggetGold", Character.valueOf('d'), "gemDiamond");
            }
        }
        return null;
    }

    @Override
    public boolean isOn(ItemStack held) {
        return true;
    }

    public static enum WarpType {
        BED,
        SPAWN;

    }
}

