/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.guide;

import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.guide.GuidePage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.brewing.BrewingRecipe;

public class GuideItem {
    public GuideCategory cat;
    public Item icon;
    public String title;
    public List<GuidePage> pages = new ArrayList<GuidePage>();

    public GuideItem(@Nonnull GuideCategory cat, @Nonnull Item icon, @Nonnull String title, @Nonnull String text, @Nullable IRecipe recipe) {
        this.cat = cat;
        this.icon = icon;
        this.title = UtilChat.lang(title);
        if (text != null) {
            this.pages.add(new GuidePage(UtilChat.lang(text)));
        }
        if (recipe != null) {
            this.pages.add(new GuidePage(recipe));
        }
    }

    public void addRecipePage(IRecipe t) {
        if (t == null) {
            return;
        }
        this.pages.add(new GuidePage(t));
    }

    public void addRecipePage(BrewingRecipe t) {
        if (t == null) {
            return;
        }
        this.pages.add(new GuidePage(t));
    }

    public void addTextPage(String t) {
        this.pages.add(new GuidePage(t));
    }
}

