/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.enchant;

import com.lothrazar.cyclicmagic.core.enchant.EnchantBase;
import com.lothrazar.cyclicmagic.core.util.UtilExperience;
import com.lothrazar.cyclicmagic.guide.GuideRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantXpBoost
extends EnchantBase {
    private static final int XP_PER_LVL = 8;

    public EnchantXpBoost() {
        super("expboost", Enchantment.Rarity.VERY_RARE, EnumEnchantmentType.DIGGER, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
        GuideRegistry.register(this, new ArrayList<String>(Arrays.asList("8")));
    }

    public int func_77325_b() {
        return 3;
    }

    @SubscribeEvent
    public void onEntityKill(LivingDeathEvent event) {
        if (event.getSource() == null) {
            return;
        }
        if (event.getSource().func_76346_g() instanceof EntityPlayer && event.getEntity() instanceof EntityLivingBase) {
            EntityPlayer attacker = (EntityPlayer)event.getSource().func_76346_g();
            int level = this.getCurrentLevelTool((EntityLivingBase)attacker);
            if (level <= 0) {
                return;
            }
            EntityLivingBase target = (EntityLivingBase)event.getEntity();
            World world = attacker.func_130014_f_();
            BlockPos pos = target.func_180425_c();
            this.dropExp(world, pos, 8 * level);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBreakEvent(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        EntityPlayer player = event.getPlayer();
        if (player == null) {
            return;
        }
        BlockPos pos = event.getPos();
        int level = this.getCurrentLevelTool((EntityLivingBase)player);
        if (level <= 0) {
            return;
        }
        Block block = event.getState().func_177230_c();
        int xpDropped = block.getExpDrop(event.getState(), (IBlockAccess)world, pos, 0);
        int bonus = xpDropped * 8 * level;
        UtilExperience.incrementExp(player, bonus);
    }

    private void dropExp(World world, BlockPos pos, int xp) {
        if (!world.field_72995_K) {
            EntityXPOrb orb = new EntityXPOrb(world);
            orb.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            orb.field_70530_e = xp;
            world.func_72838_d((Entity)orb);
        }
    }
}

