/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.core.util;

import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilEntity;
import com.lothrazar.cyclicmagic.core.util.UtilItemStack;
import com.lothrazar.cyclicmagic.core.util.UtilShape;
import com.lothrazar.cyclicmagic.core.util.UtilSound;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.command.ICommandSender;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class UtilWorld {
    public static int blockToChunk(int blockVal) {
        return blockVal >> 4;
    }

    public static int chunkToBlock(int chunkVal) {
        return chunkVal << 4;
    }

    public static boolean isNight(World world) {
        long t = world.func_72820_D();
        int timeOfDay = (int)t % 24000;
        return timeOfDay > 12000;
    }

    public static BlockPos convertIposToBlockpos(IPosition here) {
        return new BlockPos(here.func_82615_a(), here.func_82617_b(), here.func_82616_c());
    }

    public static BlockPos getFirstBlockAbove(World world, BlockPos pos) {
        BlockPos posCurrent = null;
        for (int y = pos.func_177956_o() + 1; y < 256; ++y) {
            posCurrent = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
            if (world.func_180495_p(posCurrent).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(posCurrent.func_177984_a()).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(posCurrent.func_177977_b()).func_177230_c() == Blocks.field_150350_a) continue;
            return posCurrent;
        }
        return null;
    }

    public static List<BlockPos> getPositionsInRange(BlockPos center, int xMin, int xMax, int yMin, int yMax, int zMin, int zMax) {
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        for (int x = xMin; x <= xMax; ++x) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int z = zMin; z <= zMax; ++z) {
                    found.add(new BlockPos(x, y, z));
                }
            }
        }
        return found;
    }

    public static BlockPos getRandomPos(Random rand, BlockPos here, int hRadius) {
        int x = here.func_177958_n();
        int z = here.func_177952_p();
        int xMin = x - hRadius;
        int xMax = x + hRadius;
        int zMin = z - hRadius;
        int zMax = z + hRadius;
        int posX = MathHelper.func_76136_a((Random)rand, (int)xMin, (int)xMax);
        int posZ = MathHelper.func_76136_a((Random)rand, (int)zMin, (int)zMax);
        return new BlockPos(posX, here.func_177956_o(), posZ);
    }

    public static boolean tryTpPlayerToBed(World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return false;
        }
        if (player.field_71093_bK != 0) {
            UtilChat.addChatMessage(player, "command.home.overworld");
            return false;
        }
        BlockPos pos = player.getBedLocation(0);
        if (pos == null) {
            UtilChat.addChatMessage(player, "command.gethome.bed");
            return false;
        }
        UtilEntity.teleportWallSafe((EntityLivingBase)player, world, pos);
        UtilSound.playSound(player, pos, SoundEvents.field_187534_aX);
        return true;
    }

    public static Map<IInventory, BlockPos> findTileEntityInventories(ICommandSender player, int RADIUS) {
        HashMap<IInventory, BlockPos> found = new HashMap<IInventory, BlockPos>();
        int xMin = player.func_180425_c().func_177958_n() - RADIUS;
        int xMax = player.func_180425_c().func_177958_n() + RADIUS;
        int yMin = player.func_180425_c().func_177956_o() - RADIUS;
        int yMax = player.func_180425_c().func_177956_o() + RADIUS;
        int zMin = player.func_180425_c().func_177952_p() - RADIUS;
        int zMax = player.func_180425_c().func_177952_p() + RADIUS;
        BlockPos posCurrent = null;
        for (int xLoop = xMin; xLoop <= xMax; ++xLoop) {
            for (int yLoop = yMin; yLoop <= yMax; ++yLoop) {
                for (int zLoop = zMin; zLoop <= zMax; ++zLoop) {
                    posCurrent = new BlockPos(xLoop, yLoop, zLoop);
                    if (!(player.func_130014_f_().func_175625_s(posCurrent) instanceof IInventory)) continue;
                    found.put((IInventory)player.func_130014_f_().func_175625_s(posCurrent), posCurrent);
                }
            }
        }
        return found;
    }

    public static int searchTileInventory(String search, IInventory inventory) {
        int foundQty = 0;
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            String invItemName;
            ItemStack invItem = inventory.func_70301_a(slot);
            if (invItem == null || !search.equals(invItemName = invItem.func_82833_r().toLowerCase()) && !search.contains(invItemName) && !invItemName.contains(search)) continue;
            foundQty += invItem.func_190916_E();
        }
        return foundQty;
    }

    public static BlockPos findClosestBlock(EntityPlayer player, Block blockHunt, int RADIUS) {
        BlockPos found = null;
        int xMin = (int)player.field_70165_t - RADIUS;
        int xMax = (int)player.field_70165_t + RADIUS;
        int yMin = (int)player.field_70163_u - RADIUS;
        int yMax = (int)player.field_70163_u + RADIUS;
        int zMin = (int)player.field_70161_v - RADIUS;
        int zMax = (int)player.field_70161_v + RADIUS;
        int distance = 0;
        int distanceClosest = RADIUS * RADIUS;
        BlockPos posCurrent = null;
        for (int xLoop = xMin; xLoop <= xMax; ++xLoop) {
            for (int yLoop = yMin; yLoop <= yMax; ++yLoop) {
                for (int zLoop = zMin; zLoop <= zMax; ++zLoop) {
                    posCurrent = new BlockPos(xLoop, yLoop, zLoop);
                    if (!player.func_130014_f_().func_180495_p(posCurrent).func_177230_c().equals(blockHunt)) continue;
                    if (found == null) {
                        found = posCurrent;
                        continue;
                    }
                    distance = (int)UtilWorld.distanceBetweenHorizontal(player.func_180425_c(), posCurrent);
                    if (distance >= distanceClosest) continue;
                    found = posCurrent;
                    distanceClosest = distance;
                }
            }
        }
        return found;
    }

    public static ArrayList<BlockPos> findBlocks(World world, BlockPos start, Block blockHunt, int RADIUS) {
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        int xMin = start.func_177958_n() - RADIUS;
        int xMax = start.func_177958_n() + RADIUS;
        int yMin = start.func_177956_o() - RADIUS;
        int yMax = start.func_177956_o() + RADIUS;
        int zMin = start.func_177952_p() - RADIUS;
        int zMax = start.func_177952_p() + RADIUS;
        BlockPos posCurrent = null;
        for (int xLoop = xMin; xLoop <= xMax; ++xLoop) {
            for (int yLoop = yMin; yLoop <= yMax; ++yLoop) {
                for (int zLoop = zMin; zLoop <= zMax; ++zLoop) {
                    posCurrent = new BlockPos(xLoop, yLoop, zLoop);
                    if (!world.func_180495_p(posCurrent).func_177230_c().equals(blockHunt)) continue;
                    found.add(posCurrent);
                }
            }
        }
        return found;
    }

    public static double distanceBetweenHorizontal(BlockPos start, BlockPos end) {
        int xDistance = Math.abs(start.func_177958_n() - end.func_177958_n());
        int zDistance = Math.abs(start.func_177952_p() - end.func_177952_p());
        return Math.sqrt(xDistance * xDistance + zDistance * zDistance);
    }

    public static double distanceBetweenVertical(BlockPos start, BlockPos end) {
        return Math.abs(start.func_177956_o() - end.func_177956_o());
    }

    public static boolean doBlockStatesMatch(IBlockState replaced, IBlockState newToPlace) {
        return replaced.func_177230_c() == newToPlace.func_177230_c() && replaced.func_177230_c().func_176201_c(replaced) == newToPlace.func_177230_c().func_176201_c(newToPlace);
    }

    public static boolean isAirOrWater(World world, BlockPos pos) {
        ArrayList<Object> waterBoth = new ArrayList<Object>();
        waterBoth.add(Blocks.field_150358_i);
        waterBoth.add(Blocks.field_150355_j);
        if (pos == null) {
            return false;
        }
        return world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c().func_149739_a().equalsIgnoreCase("tile.water") || world.func_180495_p(pos) != null && waterBoth.contains(world.func_180495_p(pos).func_177230_c());
    }

    public static BlockPos nextAirInDirection(World world, BlockPos posIn, EnumFacing facing, int max, @Nullable Block blockMatch) {
        BlockPos posToPlaceAt = new BlockPos((Vec3i)posIn);
        BlockPos posLoop = new BlockPos((Vec3i)posIn);
        for (int i = 0; i < max; ++i) {
            if (world.func_175623_d(posLoop)) {
                posToPlaceAt = posLoop;
                break;
            }
            posLoop = posLoop.func_177972_a(facing);
        }
        return posToPlaceAt;
    }

    public static BlockPos nextReplaceableInDirection(World world, BlockPos posIn, EnumFacing facing, int max, @Nullable Block blockMatch) {
        BlockPos posToPlaceAt = new BlockPos((Vec3i)posIn);
        BlockPos posLoop = new BlockPos((Vec3i)posIn);
        for (int i = 0; i < max; ++i) {
            if (world.func_180495_p(posLoop).func_177230_c() != null && world.func_180495_p(posLoop).func_177230_c().func_176200_f((IBlockAccess)world, posLoop)) {
                posToPlaceAt = posLoop;
                break;
            }
            posLoop = posLoop.func_177972_a(facing);
        }
        return posToPlaceAt;
    }

    public static boolean isBlockTorch(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Block blockHit = blockState.func_177230_c();
        String blockId = UtilItemStack.getStringForItemStack(new ItemStack(blockHit));
        return blockHit == Blocks.field_150478_aa || blockId.equals("tconstruct:stone_torch/0") || blockId.equals("actuallyadditions:block_tiny_torch/0");
    }

    public static List<BlockPos> getMatchingInRange(World world, BlockPos pos, Block blockToMatch, int maxRange) {
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        List<BlockPos> searchRange = UtilShape.cubeFilled(pos, maxRange, maxRange);
        for (BlockPos p : searchRange) {
            if (world.func_180495_p(p).func_177230_c() != blockToMatch) continue;
            found.add(p);
        }
        return found;
    }

    public static class RenderShadow {
        public static void renderBlockPos(final BlockPos p, BlockPos center, double relX, double relY, double relZ, float red, float green, float blue) {
            RenderShadow.renderBlockList((List<BlockPos>)new ArrayList<BlockPos>(){
                {
                    this.add(p);
                }
            }, center, relX, relY, relZ, red, green, blue);
        }

        public static void renderBlockPhantom(World world, BlockPos pos, ItemStack stack, double relX, double relY, double relZ, BlockPos target, boolean isSolid) {
            if (stack.func_77973_b() instanceof ItemBlock) {
                ItemBlock ib = (ItemBlock)stack.func_77973_b();
                IBlockState stateFromStack = ib.func_179223_d().getStateForPlacement(world, pos, EnumFacing.DOWN, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p(), stack.func_77952_i(), null, EnumHand.MAIN_HAND);
                RenderShadow.renderBlockPhantom(world, pos, stateFromStack, relX, relY, relZ, target, isSolid);
            }
        }

        public static void renderBlockPhantom(World world, BlockPos pos, IBlockState state, double relX, double relY, double relZ, BlockPos target, boolean isSolid) {
            int xOffset = target.func_177958_n() - pos.func_177958_n();
            int yOffset = target.func_177956_o() - pos.func_177956_o();
            int zOffset = target.func_177952_p() - pos.func_177952_p();
            BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
            IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferBuilder = tessellator.func_178180_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(relX + 0.5), (double)(relY + 0.5), (double)(relZ + 0.5));
            RenderHelper.func_74518_a();
            if (!isSolid) {
                GlStateManager.func_179112_b((int)770, (int)775);
                GlStateManager.func_179147_l();
                GlStateManager.func_179129_p();
            }
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            bufferBuilder.func_178969_c(-0.5 - (double)pos.func_177958_n() + (double)xOffset, -0.5 - (double)pos.func_177956_o() + (double)yOffset, -0.5 - (double)pos.func_177952_p() + (double)zOffset);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            blockRenderer.func_175019_b().func_178267_a((IBlockAccess)world, model, state, pos, bufferBuilder, false);
            bufferBuilder.func_178969_c(0.0, 0.0, 0.0);
            tessellator.func_78381_a();
            RenderHelper.func_74519_b();
            GlStateManager.func_179121_F();
        }

        public static void renderBlockList(List<BlockPos> blockPosList, BlockPos center, double relX, double relY, double relZ, float red, float green, float blue) {
            GlStateManager.func_179123_a();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(relX + 0.5), (double)(relY + 0.5), (double)(relZ + 0.5));
            GlStateManager.func_179140_f();
            GlStateManager.func_179090_x();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179147_l();
            float alpha = 0.5f;
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
            if (Minecraft.func_71379_u()) {
                GlStateManager.func_179103_j((int)7425);
            } else {
                GlStateManager.func_179103_j((int)7424);
            }
            for (BlockPos p : blockPosList) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)(center.func_177958_n() - p.func_177958_n()) * -1.0f), (float)((float)(center.func_177956_o() - p.func_177956_o()) * -1.0f), (float)((float)(center.func_177952_p() - p.func_177952_p()) * -1.0f));
                RenderShadow.shadedCube(0.4f);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179098_w();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
            GlStateManager.func_179099_b();
        }

        private static void shadedCube(float scale) {
            float size = 1.0f * scale;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldRenderer = tessellator.func_178180_c();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            worldRenderer.func_181662_b((double)(-size), (double)(-size), (double)size).func_181675_d();
            worldRenderer.func_181662_b((double)size, (double)(-size), (double)size).func_181675_d();
            worldRenderer.func_181662_b((double)size, (double)size, (double)size).func_181675_d();
            worldRenderer.func_181662_b((double)(-size), (double)size, (double)size).func_181675_d();
            worldRenderer.func_181662_b((double)(-size), (double)(-size), (double)(-size)).func_181675_d();
            worldRenderer.func_181662_b((double)(-size), (double)size, (double)(-size)).func_181675_d();
            worldRenderer.func_181662_b((double)size, (double)size, (double)(-size)).func_181675_d();
            worldRenderer.func_181662_b((double)size, (double)(-size), (double)(-size)).func_181675_d();
            worldRenderer.func_181662_b((double)(-size), (double)(-size), (double)(-size)).func_181675_d();
            worldRenderer.func_181662_b((double)(-size), (double)(-size), (double)size).func_181675_d();
            worldRenderer.func_181662_b((double)(-size), (double)size, (double)size).func_181675_d();
            worldRenderer.func_181662_b((double)(-size), (double)size, (double)(-size)).func_181675_d();
            worldRenderer.func_181662_b((double)size, (double)(-size), (double)(-size)).func_181675_d();
            worldRenderer.func_181662_b((double)size, (double)size, (double)(-size)).func_181675_d();
            worldRenderer.func_181662_b((double)size, (double)size, (double)size).func_181675_d();
            worldRenderer.func_181662_b((double)size, (double)(-size), (double)size).func_181675_d();
            worldRenderer.func_181662_b((double)(-size), (double)size, (double)(-size)).func_181675_d();
            worldRenderer.func_181662_b((double)(-size), (double)size, (double)size).func_181675_d();
            worldRenderer.func_181662_b((double)size, (double)size, (double)size).func_181675_d();
            worldRenderer.func_181662_b((double)size, (double)size, (double)(-size)).func_181675_d();
            worldRenderer.func_181662_b((double)(-size), (double)(-size), (double)(-size)).func_181675_d();
            worldRenderer.func_181662_b((double)size, (double)(-size), (double)(-size)).func_181675_d();
            worldRenderer.func_181662_b((double)size, (double)(-size), (double)size).func_181675_d();
            worldRenderer.func_181662_b((double)(-size), (double)(-size), (double)size).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    public static class OutlineRenderer {
        public static void renderOutlines(RenderWorldLastEvent evt, EntityPlayerSP p, Set<BlockPos> coordinates, int r, int g, int b) {
            double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)evt.getPartialTicks();
            double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)evt.getPartialTicks();
            double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)evt.getPartialTicks();
            GlStateManager.func_179123_a();
            GlStateManager.func_179097_i();
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
            OutlineRenderer.renderOutlines(coordinates, r, g, b, 4);
            GlStateManager.func_179121_F();
            GlStateManager.func_179099_b();
        }

        private static void renderOutlines(Set<BlockPos> coordinates, int r, int g, int b, int thickness) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            GL11.glLineWidth((float)thickness);
            for (BlockPos coordinate : coordinates) {
                float x = coordinate.func_177958_n();
                float y = coordinate.func_177956_o();
                float z = coordinate.func_177952_p();
                OutlineRenderer.renderHighLightedBlocksOutline(buffer, x, y, z, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
            }
            tessellator.func_78381_a();
        }

        public static void renderHighLightedBlocksOutline(BufferBuilder buffer, float mx, float my, float mz, float r, float g, float b, float a) {
            buffer.func_181662_b((double)mx, (double)my, (double)mz).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)mz).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)mx, (double)my, (double)mz).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)mz).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)mx, (double)my, (double)mz).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)mx, (double)my, (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)mz).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)mz).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)mz).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)mz).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)mx, (double)my, (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)mx, (double)my, (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        }
    }
}

