/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.wireless;

import com.lothrazar.cyclicmagic.block.wireless.TileEntityWirelessRec;
import com.lothrazar.cyclicmagic.block.wireless.TileEntityWirelessTr;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.block.BlockBaseHasTile;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilItemStack;
import com.lothrazar.cyclicmagic.core.util.UtilNBT;
import com.lothrazar.cyclicmagic.core.util.UtilParticle;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRedstoneWireless
extends BlockBaseHasTile
implements IHasRecipe {
    private static final int PARTICLE_DENSITY = 2;
    public static final PropertyBool POWERED = BlockLever.field_176359_b;
    WirelessType type;

    public BlockRedstoneWireless(WirelessType t) {
        super(Material.field_151573_f);
        this.type = t;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0;
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        if (this.type == WirelessType.TRANSMITTER) {
            return new TileEntityWirelessTr();
        }
        return new TileEntityWirelessRec();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)POWERED)).booleanValue()) {
            UtilParticle.spawnParticle(worldIn, EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 2);
        }
    }

    private int getPower(IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (world.func_175625_s(pos) instanceof TileEntityWirelessRec) {
            return 15;
        }
        return 0;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? this.getPower(blockAccess, pos, side.func_176734_d()) : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? this.getPower(blockAccess, pos, side.func_176734_d()) : 0;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.func_175625_s(pos) instanceof TileEntityWirelessTr) {
            TileEntityWirelessTr te = (TileEntityWirelessTr)world.func_175625_s(pos);
            if (te.getTargetPos() == null) {
                UtilChat.sendStatusMessage(player, "tile.wireless_transmitter.empty");
            } else {
                UtilChat.sendStatusMessage(player, UtilChat.lang("tile.wireless_transmitter.saved") + UtilChat.blockPosToString(te.getTargetPos()));
            }
        }
        return true;
    }

    @Override
    public IRecipe addRecipe() {
        if (this.type == WirelessType.TRANSMITTER) {
            return RecipeRegistry.addShapedOreRecipe(new ItemStack((Block)this), "isi", "sqs", "isi", Character.valueOf('i'), "ingotIron", Character.valueOf('s'), "stone", Character.valueOf('q'), Items.field_151107_aW);
        }
        return RecipeRegistry.addShapedOreRecipe(new ItemStack((Block)this), "isi", "sqs", "isi", Character.valueOf('i'), "ingotIron", Character.valueOf('s'), "stone", Character.valueOf('q'), Blocks.field_150429_aA);
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        ItemStack stack = event.getItemStack();
        if (world.func_175625_s(pos) instanceof TileEntityWirelessRec && stack.func_77973_b() == Item.func_111206_d((String)"cyclicmagic:wireless_transmitter")) {
            UtilNBT.setItemStackBlockPos(stack, pos);
            UtilChat.sendStatusMessage(event.getEntityPlayer(), UtilChat.lang("tile.wireless_transmitter.saved") + UtilChat.blockPosToString(pos));
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        stack.func_77973_b().func_179215_a(stack.func_77978_p());
        TileEntity tile = worldIn.func_175625_s(pos);
        BlockPos posTarget = UtilNBT.getItemStackBlockPos(stack);
        if (tile != null && posTarget != null && tile instanceof TileEntityWirelessTr) {
            ((TileEntityWirelessTr)tile).setTargetPos(posTarget);
        }
    }

    @SubscribeEvent
    public static void onBreakEvent(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null && event.getPlayer().field_71075_bZ.field_75098_d) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getState();
        TileEntity ent = world.func_175625_s(pos);
        if (ent != null && ent instanceof TileEntityWirelessTr) {
            TileEntityWirelessTr t = (TileEntityWirelessTr)ent;
            ItemStack stack = new ItemStack(state.func_177230_c());
            if (t.getTargetPos() != null) {
                UtilNBT.setItemStackBlockPos(stack, t.getTargetPos());
            }
            UtilItemStack.dropItemStackInWorld(world, pos, stack);
        } else if (ent != null && ent instanceof TileEntityWirelessRec) {
            ItemStack stack = new ItemStack(state.func_177230_c());
            UtilItemStack.dropItemStackInWorld(world, pos, stack);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public static enum WirelessType {
        TRANSMITTER,
        RECEIVER;

    }
}

