/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.vector;

import com.lothrazar.cyclicmagic.block.vector.TileEntityVector;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.block.BlockBaseHasTile;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilEntity;
import com.lothrazar.cyclicmagic.core.util.UtilItemStack;
import com.lothrazar.cyclicmagic.core.util.UtilNBT;
import com.lothrazar.cyclicmagic.core.util.UtilSound;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockVectorPlate
extends BlockBaseHasTile
implements IHasRecipe {
    private static final int TICKS_MOMENTUM = 15;
    private static final double VERTICAL_MOMENTUM_FACTOR = 0.917;
    private static final String NBT_MOMENTUM = "momentum";
    private static final double BHEIGHT = 0.03125;
    private static final double COLLISION_HEIGHT = 0.0625;
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.03125, 1.0);
    protected static final AxisAlignedBB COLLISION_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    public BlockVectorPlate() {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f).func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setGuiId(16);
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntityVector();
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLISION_AABB;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        boolean powerOk;
        int yFloor = MathHelper.func_76128_c((double)entity.field_70163_u);
        double posWithinBlock = entity.field_70163_u - (double)yFloor;
        TileEntityVector tile = (TileEntityVector)worldIn.func_175625_s(pos);
        entity.field_70143_R = 0.0f;
        boolean bl = powerOk = worldIn.func_175640_z(pos) || tile.func_174887_a_(TileEntityVector.Fields.REDSTONE.ordinal()) == 0;
        if (powerOk && posWithinBlock <= 0.0625 && entity instanceof EntityLivingBase && tile != null) {
            if (tile.playSound()) {
                UtilSound.playSound(worldIn, pos, SoundRegistry.machine_launch, SoundCategory.BLOCKS);
            }
            float rotationPitch = tile.getAngle();
            float rotationYaw = tile.getYaw();
            float power = tile.getActualPower();
            if (rotationPitch > 0.0f) {
                UtilEntity.centerEntityHoriz(entity, pos);
            }
            UtilNBT.setEntityInt(entity, NBT_MOMENTUM, 15);
            UtilEntity.setVelocity(entity, rotationPitch, rotationYaw, power);
        }
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (UtilNBT.getEntityInt((Entity)entity, NBT_MOMENTUM) > 0) {
            UtilEntity.dragEntityMomentum(entity, 0.917);
            UtilNBT.setEntityInt((Entity)entity, NBT_MOMENTUM, UtilNBT.getEntityInt((Entity)entity, NBT_MOMENTUM) - 1);
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
        if (!player.func_70093_af() && world.func_175625_s(pos) instanceof TileEntityVector && stack != null && Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockVectorPlate) {
            IBlockState iblockstate = world.func_180495_p(pos);
            Block block = iblockstate.func_177230_c();
            TileEntityVector tile = (TileEntityVector)world.func_175625_s(pos);
            if (stack.func_77942_o()) {
                ((BlockVectorPlate)block).saveStackDataTotile(stack, tile);
                if (world.field_72995_K) {
                    UtilChat.addChatMessage(player, "tile.plate_vector.copied");
                }
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = super.getPickBlock(state, target, world, pos, player);
        if (stack == null || !(world.func_175625_s(pos) instanceof TileEntityVector)) {
            return null;
        }
        TileEntityVector tile = (TileEntityVector)world.func_175625_s(pos);
        this.saveTileDataToStack(stack, tile);
        return stack;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    @SubscribeEvent
    public void onBreakEvent(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null && event.getPlayer().field_71075_bZ.field_75098_d) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getState();
        TileEntity ent = world.func_175625_s(pos);
        if (ent != null && ent instanceof TileEntityVector) {
            TileEntityVector t = (TileEntityVector)ent;
            ItemStack stack = new ItemStack(state.func_177230_c());
            this.saveTileDataToStack(stack, t);
            UtilItemStack.dropItemStackInWorld(world, pos, stack);
        }
    }

    private void saveTileDataToStack(ItemStack stack, TileEntityVector tile) {
        UtilNBT.setItemStackNBTVal(stack, "vectorAngle", tile.getAngle());
        UtilNBT.setItemStackNBTVal(stack, "vectorPower", tile.getPower());
        UtilNBT.setItemStackNBTVal(stack, "vectorYaw", tile.getYaw());
        UtilNBT.setItemStackNBTVal(stack, "sound", tile.func_174887_a_(TileEntityVector.Fields.SOUND.ordinal()));
        UtilNBT.setItemStackNBTVal(stack, "redst", tile.func_174887_a_(TileEntityVector.Fields.REDSTONE.ordinal()));
    }

    private void saveStackDataTotile(ItemStack stack, TileEntityVector tile) {
        if (stack.func_77942_o()) {
            tile.func_174885_b(TileEntityVector.Fields.ANGLE.ordinal(), UtilNBT.getItemStackNBTVal(stack, "vectorAngle"));
            tile.func_174885_b(TileEntityVector.Fields.POWER.ordinal(), UtilNBT.getItemStackNBTVal(stack, "vectorPower"));
            tile.func_174885_b(TileEntityVector.Fields.YAW.ordinal(), UtilNBT.getItemStackNBTVal(stack, "vectorYaw"));
            tile.func_174885_b(TileEntityVector.Fields.SOUND.ordinal(), UtilNBT.getItemStackNBTVal(stack, "sound"));
            tile.func_174885_b(TileEntityVector.Fields.REDSTONE.ordinal(), UtilNBT.getItemStackNBTVal(stack, "redst"));
        }
    }

    public static void saveStackDefault(ItemStack stack) {
        UtilNBT.setItemStackNBTVal(stack, "vectorAngle", 45);
        UtilNBT.setItemStackNBTVal(stack, "vectorPower", 60);
        UtilNBT.setItemStackNBTVal(stack, "vectorYaw", 90);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        stack.func_77973_b().func_179215_a(stack.func_77978_p());
        TileEntityVector tile = (TileEntityVector)worldIn.func_175625_s(pos);
        if (tile != null) {
            this.saveStackDataTotile(stack, tile);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 6), " t ", "idi", "bbb", Character.valueOf('i'), "ingotIron", Character.valueOf('d'), "dustRedstone", Character.valueOf('b'), Blocks.field_150452_aw, Character.valueOf('t'), "dustGlowstone");
    }
}

