/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.screen;

import com.lothrazar.cyclicmagic.block.screen.TileEntityScreen;
import com.lothrazar.cyclicmagic.core.block.BaseTESR;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import java.util.List;
import net.minecraft.block.Block;

public class ScreenTESR<T extends TileEntityScreen>
extends BaseTESR<T> {
    public static final int SCREEN_WIDTH = 96;
    private static final int MAX_WIDTH = 16;
    private static final int MAX_LINES = 8;
    public static final int MAX_TOTAL = 128;
    public static final float rowHeight = -0.11f;

    public ScreenTESR(Block block) {
        super(block);
    }

    public void render(TileEntityScreen te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        int tePadding = te.getPadding();
        float leftPadding = (float)tePadding / 2.0f / 100.0f;
        float leftEdge = 0.0f + leftPadding;
        float rightEdge = 1.05f;
        float width = 1.05f - leftEdge;
        float xt = leftEdge;
        float yt = 0.0f;
        float zt = 0.0f;
        int angle = this.angleOfFace(te.getCurrentFacing());
        this.fixLighting(te);
        List<String> lines = UtilChat.splitIntoEqualLengths(this.func_147498_b(), te.getText(), 96 - tePadding);
        int ln = 0;
        TileEntityScreen.Justification justif = te.getJustification();
        for (String line : lines) {
            float lnWidth = (float)this.func_147498_b().func_78256_a(line) / 96.0f;
            switch (justif) {
                case CENTER: {
                    float spRemainder = width - lnWidth;
                    xt = leftEdge + spRemainder / 2.0f;
                    break;
                }
                case RIGHT: {
                    float spRemainders = width - lnWidth;
                    xt = leftEdge + spRemainders - 0.05f;
                }
            }
            this.renderTextAt(line, x, y, z, destroyStage, xt, yt, zt, angle, te.getColor());
            if (++ln >= 8) break;
            y += (double)-0.11f;
        }
    }
}

