/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.firestarter;

import com.lothrazar.cyclicmagic.block.firestarter.BlockFireStarter;
import com.lothrazar.cyclicmagic.core.block.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileEntityFireStarter
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITickable {
    private int yOffset = 0;
    private int fireType = 0;
    private int needsRedstone = 1;
    private int hOffset = 0;
    private int delay;
    @GameRegistry.ObjectHolder(value="cyclicmagic:fire_dark")
    public static final Block fireDark = null;
    @GameRegistry.ObjectHolder(value="cyclicmagic:fire_frost")
    public static final Block fireFrost = null;

    public TileEntityFireStarter() {
        super(1);
        this.timer = this.delay = 11;
        this.setSlotsForInsert(0);
        this.initEnergy(BlockFireStarter.FUEL_COST, 8000);
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        BlockPos target = this.getCurrentFacingPos().func_177967_a(this.getCurrentFacing(), this.hOffset).func_177967_a(EnumFacing.UP, this.yOffset);
        if (!this.field_145850_b.func_175623_d(target)) {
            return;
        }
        if (!this.updateEnergyIsBurning()) {
            return;
        }
        if (this.updateTimerIsZero()) {
            this.timer = this.delay;
            Block fire = null;
            switch (FireType.values()[this.fireType]) {
                case DARK: {
                    fire = fireDark;
                    break;
                }
                case FROST: {
                    fire = fireFrost;
                    break;
                }
                case NORMAL: {
                    fire = Blocks.field_150480_ab;
                }
            }
            this.field_145850_b.func_175656_a(target, fire.func_176223_P());
        }
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case DELAY: {
                return this.delay;
            }
            case OFFSET: {
                return this.hOffset;
            }
            case FIRETYPE: {
                return this.fireType;
            }
            case Y_OFFSET: {
                return this.yOffset;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case DELAY: {
                this.delay = value;
                break;
            }
            case OFFSET: {
                this.hOffset = value;
                break;
            }
            case FIRETYPE: {
                this.fireType = value % FireType.values().length;
                break;
            }
            case Y_OFFSET: {
                if (value > 1) {
                    value = -1;
                }
                this.yOffset = value;
            }
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = (this.needsRedstone + 1) % 2;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.needsRedstone = compound.func_74762_e("redstone");
        this.delay = compound.func_74762_e("delay");
        this.hOffset = compound.func_74762_e("hOffset");
        this.fireType = compound.func_74762_e("fireType");
        this.yOffset = compound.func_74762_e("yoff");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("redstone", this.needsRedstone);
        compound.func_74768_a("delay", this.delay);
        compound.func_74768_a("hOffset", this.hOffset);
        compound.func_74768_a("fireType", this.fireType);
        compound.func_74768_a("yoff", this.yOffset);
        return super.func_189515_b(compound);
    }

    public static enum Fields {
        TIMER,
        REDSTONE,
        DELAY,
        OFFSET,
        FIRETYPE,
        Y_OFFSET;

    }

    static enum FireType {
        NORMAL,
        DARK,
        FROST;

    }
}

