/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.cable;

import com.google.common.collect.Maps;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.core.block.TileEntityBaseMachineFluid;
import com.lothrazar.cyclicmagic.core.liquid.FluidTankBase;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilFluid;
import com.lothrazar.cyclicmagic.core.util.UtilItemStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public abstract class TileEntityCableBase
extends TileEntityBaseMachineFluid
implements ITickable {
    private static final int TIMER_SIDE_INPUT = 15;
    public static final int TRANSFER_FLUID_PER_TICK = 1000;
    public static final int TRANSFER_ENERGY_PER_TICK = 16000;
    private static final int TICKS_TEXT_CACHED = 30;
    private int labelTimer = 0;
    private String labelText = "";
    private boolean itemTransport = false;
    private boolean fluidTransport = false;
    private boolean energyTransport = false;
    private Map<EnumFacing, Integer> mapIncomingFluid = Maps.newHashMap();
    protected Map<EnumFacing, Integer> mapIncomingItems = Maps.newHashMap();
    private Map<EnumFacing, Integer> mapIncomingEnergy = Maps.newHashMap();
    private Map<EnumFacing, Boolean> mapBlacklist = Maps.newHashMap();

    public TileEntityCableBase(boolean hasItems, boolean hasFluid, boolean hasEnergy) {
        super(hasItems ? 1 : 0);
        if (hasFluid) {
            this.tank = new FluidTankBase(1000);
        }
        if (hasEnergy) {
            this.initEnergy(0, 16000);
        }
        this.itemTransport = hasItems;
        this.fluidTransport = hasFluid;
        this.energyTransport = hasEnergy;
        for (EnumFacing f : EnumFacing.values()) {
            this.mapIncomingFluid.put(f, 0);
            this.mapIncomingItems.put(f, 0);
            this.mapIncomingEnergy.put(f, 0);
            this.mapBlacklist.put(f, false);
        }
    }

    public boolean isItemPipe() {
        return this.itemTransport;
    }

    public boolean isFluidPipe() {
        return this.fluidTransport;
    }

    public boolean isEnergyPipe() {
        return this.energyTransport;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.labelText = compound.func_74779_i("label");
        this.labelTimer = compound.func_74762_e("labelt");
        for (EnumFacing f : EnumFacing.values()) {
            this.mapIncomingItems.put(f, compound.func_74762_e(f.func_176610_l() + "_incoming"));
            this.mapIncomingFluid.put(f, compound.func_74762_e(f.func_176610_l() + "_incfluid"));
            this.mapIncomingEnergy.put(f, compound.func_74762_e(f.func_176610_l() + "_incenergy"));
            this.mapBlacklist.put(f, compound.func_74767_n(f.func_176610_l() + "_blocked"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("label", this.labelText);
        compound.func_74768_a("labelt", this.labelTimer);
        for (EnumFacing f : EnumFacing.values()) {
            compound.func_74768_a(f.func_176610_l() + "_incoming", this.mapIncomingItems.get(f).intValue());
            compound.func_74768_a(f.func_176610_l() + "_incfluid", this.mapIncomingFluid.get(f).intValue());
            compound.func_74768_a(f.func_176610_l() + "_incenergy", this.mapIncomingEnergy.get(f).intValue());
            compound.func_74757_a(f.func_176610_l() + "_blocked", this.mapBlacklist.get(f).booleanValue());
        }
        return compound;
    }

    public String getLabelTextOrEmpty() {
        return this.labelText.isEmpty() ? UtilChat.lang("cyclic.item.empty") : this.labelText;
    }

    private void tickLabelText() {
        --this.labelTimer;
        if (this.labelTimer > 0) {
            return;
        }
        this.labelTimer = 0;
        this.labelText = "";
        ArrayList<String> validLabels = new ArrayList<String>();
        if (this.isItemPipe() && !this.func_70301_a(0).func_190926_b()) {
            validLabels.add(this.getIncomingStringsItem());
        }
        if (this.isFluidPipe() && this.getCurrentFluidStack() != null) {
            validLabels.add(this.getIncomingStringsFluid());
        }
        if (this.isEnergyPipe() && this.energyStorage != null && this.energyStorage.getEnergyStored() > 0) {
            validLabels.add(this.getIncomingStringsEnergy());
        }
        if (validLabels.size() > 0) {
            this.labelText = (String)validLabels.get(MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)0, (int)(validLabels.size() - 1)));
            this.labelTimer = 30;
        }
    }

    private String getIncomingStringsFromMap(Map<EnumFacing, Integer> map) {
        String in = "";
        for (EnumFacing f : EnumFacing.values()) {
            if (map.get(f) <= 0) continue;
            in = in + f.name().toLowerCase() + " ";
        }
        return in.trim();
    }

    private String getIncomingStringsFluid() {
        String tmpName = this.getCurrentFluidStackAmount() + " " + this.getCurrentFluidStack().getLocalizedName();
        String incoming = this.getIncomingStringsFromMap(this.mapIncomingFluid);
        if (!incoming.isEmpty()) {
            tmpName = tmpName + " " + UtilChat.lang("cyclic.fluid.flowing") + incoming;
        }
        return tmpName;
    }

    private String getIncomingStringsItem() {
        String tmpName = this.func_70301_a(0).func_82833_r();
        String incoming = this.getIncomingStringsFromMap(this.mapIncomingItems);
        if (!incoming.isEmpty()) {
            tmpName = tmpName + " " + UtilChat.lang("cyclic.item.flowing") + incoming;
        }
        return tmpName;
    }

    private String getIncomingStringsEnergy() {
        String tmpName = this.energyStorage.getEnergyStored() + "";
        String incoming = this.getIncomingStringsFromMap(this.mapIncomingEnergy);
        if (!incoming.isEmpty()) {
            tmpName = tmpName + " " + UtilChat.lang("cyclic.fluid.flowing") + incoming;
        }
        return tmpName;
    }

    public void updateIncomingFluidFace(EnumFacing inputFrom) {
        this.mapIncomingFluid.put(inputFrom, 15);
    }

    private boolean isFluidIncomingFromFace(EnumFacing face) {
        return this.mapIncomingFluid.get(face) > 0;
    }

    private boolean isEnergyIncomingFromFace(EnumFacing face) {
        return this.mapIncomingEnergy.get(face) > 0;
    }

    public void updateIncomingEnergyFace(EnumFacing inputFrom) {
        this.mapIncomingEnergy.put(inputFrom, 15);
    }

    public void updateIncomingItemFace(EnumFacing inputFrom) {
        this.mapIncomingItems.put(inputFrom, 15);
    }

    private boolean isItemIncomingFromFace(EnumFacing face) {
        return this.mapIncomingItems.get(face) > 0;
    }

    public void func_73660_a() {
        this.tickLabelText();
        if (this.fluidTransport) {
            this.tickDownIncomingFluidFaces();
        }
        if (this.itemTransport) {
            this.tickDownIncomingItemFaces();
        }
        if (this.energyTransport) {
            this.tickDownIncomingPowerFaces();
        }
        try {
            this.tickCableFlow();
        }
        catch (Exception e) {
            ModCyclic.logger.error("Error outputing from cable");
            e.printStackTrace();
        }
    }

    private void tickCableFlow() {
        ArrayList<Integer> shuffledFaces = new ArrayList<Integer>();
        for (int i = 0; i < EnumFacing.values().length; ++i) {
            shuffledFaces.add(i);
        }
        Collections.shuffle(shuffledFaces);
        Iterator iterator = shuffledFaces.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            EnumFacing f = EnumFacing.values()[i];
            if (this.isItemPipe() && !this.isItemIncomingFromFace(f) && !this.getBlacklist(f)) {
                this.moveItems(f);
            }
            if (this.isFluidPipe() && !this.isFluidIncomingFromFace(f) && !this.getBlacklist(f)) {
                this.moveFluid(f);
            }
            if (!this.isEnergyPipe() || this.isEnergyIncomingFromFace(f) || this.getBlacklist(f)) continue;
            this.moveEnergy(f);
        }
    }

    private void moveItems(EnumFacing myFacingDir) {
        TileEntityCableBase cable;
        if (this.func_70301_a(0).func_190926_b()) {
            return;
        }
        EnumFacing themFacingMe = myFacingDir.func_176734_d();
        ItemStack stackToExport = this.func_70301_a(0).func_77946_l();
        BlockPos posTarget = this.field_174879_c.func_177972_a(myFacingDir);
        TileEntity tileTarget = this.field_145850_b.func_175625_s(posTarget);
        if (tileTarget == null) {
            return;
        }
        boolean outputSuccess = false;
        ItemStack leftAfterDeposit = UtilItemStack.tryDepositToHandler(this.field_145850_b, posTarget, themFacingMe, stackToExport);
        if (leftAfterDeposit.func_190916_E() < stackToExport.func_190916_E()) {
            this.func_70299_a(0, leftAfterDeposit);
            outputSuccess = true;
        }
        if (outputSuccess && tileTarget instanceof TileEntityCableBase && (cable = (TileEntityCableBase)tileTarget).isItemPipe()) {
            cable.updateIncomingItemFace(themFacingMe);
        }
    }

    private void moveFluid(EnumFacing myFacingDir) {
        TileEntityCableBase cable;
        TileEntity tileTarget;
        BlockPos posTarget;
        boolean outputSuccess;
        EnumFacing themFacingMe = myFacingDir.func_176734_d();
        if (this.tank.getFluidAmount() <= 0) {
            return;
        }
        int toFlow = 1000;
        if (this.hasAnyIncomingFluidFaces() && toFlow >= this.tank.getFluidAmount()) {
            toFlow = this.tank.getFluidAmount();
        }
        if ((outputSuccess = UtilFluid.tryFillPositionFromTank(this.field_145850_b, posTarget = this.field_174879_c.func_177972_a(myFacingDir), themFacingMe, this.tank, toFlow)) && (tileTarget = this.field_145850_b.func_175625_s(posTarget)) instanceof TileEntityCableBase && (cable = (TileEntityCableBase)tileTarget).isFluidPipe()) {
            cable.updateIncomingFluidFace(themFacingMe);
        }
    }

    private void moveEnergy(EnumFacing myFacingDir) {
        int drain;
        IEnergyStorage handlerHere = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, myFacingDir);
        if (handlerHere.getEnergyStored() == 0) {
            return;
        }
        EnumFacing themFacingMe = myFacingDir.func_176734_d();
        BlockPos posTarget = this.field_174879_c.func_177972_a(myFacingDir);
        TileEntity tileTarget = this.field_145850_b.func_175625_s(posTarget);
        if (tileTarget == null || !tileTarget.hasCapability(CapabilityEnergy.ENERGY, themFacingMe)) {
            return;
        }
        IEnergyStorage handlerOutput = (IEnergyStorage)tileTarget.getCapability(CapabilityEnergy.ENERGY, themFacingMe);
        if (handlerHere != null && handlerOutput != null && handlerHere.canExtract() && handlerOutput.canReceive() && (drain = handlerHere.extractEnergy(16000, true)) > 0) {
            TileEntityCableBase cable;
            int filled = handlerOutput.receiveEnergy(drain, false);
            handlerHere.extractEnergy(filled, false);
            if (filled > 0 && tileTarget instanceof TileEntityCableBase && (cable = (TileEntityCableBase)tileTarget).isEnergyPipe()) {
                cable.updateIncomingEnergyFace(themFacingMe);
            }
        }
    }

    public boolean hasAnyIncomingFluidFaces() {
        for (EnumFacing f : EnumFacing.values()) {
            if (this.mapIncomingFluid.get(f) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyIncomingEnergyFaces() {
        for (EnumFacing f : EnumFacing.values()) {
            if (this.mapIncomingEnergy.get(f) <= 0) continue;
            return true;
        }
        return false;
    }

    public void tickDownIncomingFluidFaces() {
        for (EnumFacing f : EnumFacing.values()) {
            if (this.mapIncomingFluid.get(f) <= 0) continue;
            this.mapIncomingFluid.put(f, this.mapIncomingFluid.get(f) - 1);
        }
    }

    public void tickDownIncomingItemFaces() {
        for (EnumFacing f : EnumFacing.values()) {
            if (this.mapIncomingItems.get(f) <= 0) continue;
            this.mapIncomingItems.put(f, this.mapIncomingItems.get(f) - 1);
        }
    }

    public void tickDownIncomingPowerFaces() {
        for (EnumFacing f : EnumFacing.values()) {
            if (this.mapIncomingEnergy.get(f) <= 0) continue;
            this.mapIncomingEnergy.put(f, this.mapIncomingEnergy.get(f) - 1);
        }
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        double renderExtention = 1.0;
        AxisAlignedBB bb = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - renderExtention, (double)this.field_174879_c.func_177956_o() - renderExtention, (double)this.field_174879_c.func_177952_p() - renderExtention, (double)(this.field_174879_c.func_177958_n() + 1) + renderExtention, (double)(this.field_174879_c.func_177956_o() + 1) + renderExtention, (double)(this.field_174879_c.func_177952_p() + 1) + renderExtention);
        return bb;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.mapBlacklist != null && facing != null && this.mapBlacklist.get(facing).booleanValue()) {
            return false;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return this.isEnergyPipe();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.isFluidPipe();
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.isEnergyPipe() && capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
        }
        if (facing == null) {
            return super.getCapability(capability, null);
        }
        return super.getCapability(capability, facing.func_176734_d());
    }

    public boolean getBlacklist(EnumFacing side) {
        return this.mapBlacklist.get(side);
    }

    public void toggleBlacklist(EnumFacing side) {
        this.mapBlacklist.put(side, this.mapBlacklist.get(side) == false);
    }
}

