/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.builderpattern;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.builderpattern.TileEntityPatternBuilder;
import com.lothrazar.cyclicmagic.core.block.BaseMachineTESR;
import com.lothrazar.cyclicmagic.core.block.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.core.util.UtilWorld;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PatternBuilderTESR
extends BaseMachineTESR<TileEntityPatternBuilder> {
    @Override
    public void renderBasic(TileEntityBaseMachineInvo te) {
    }

    @Override
    public void render(TileEntityBaseMachineInvo te, double x, double y, double z, float partialTicks, int destroyStage, float p) {
        super.render(te, x, y, z, partialTicks, destroyStage, p);
        if (!(te instanceof TileEntityPatternBuilder)) {
            return;
        }
        TileEntityPatternBuilder tile = (TileEntityPatternBuilder)te;
        TileEntityPatternBuilder.RenderType render = tile.getRenderType();
        if (render == TileEntityPatternBuilder.RenderType.OFF) {
            return;
        }
        List<BlockPos> targetShape = tile.getTargetShape();
        if (render == TileEntityPatternBuilder.RenderType.OUTLINE) {
            UtilWorld.RenderShadow.renderBlockPos(tile.getSourceCenter().func_177981_b(tile.getHeight() / 2), te.func_174877_v(), x, y, z, 0.0f, 0.0f, 0.5f);
            UtilWorld.RenderShadow.renderBlockPos(tile.getTargetCenter().func_177981_b(tile.getHeight() / 2), te.func_174877_v(), x, y, z, 0.5f, 0.0f, 0.0f);
            UtilWorld.RenderShadow.renderBlockList(tile.getSourceFrameOutline(), te.func_174877_v(), x, y, z, 0.7f, 0.0f, 1.0f);
            UtilWorld.RenderShadow.renderBlockList(tile.getTargetFrameOutline(), te.func_174877_v(), x, y, z, 1.0f, 1.0f, 1.0f);
            UtilWorld.RenderShadow.renderBlockList(targetShape, te.func_174877_v(), x, y, z, 0.1f, 0.1f, 0.1f);
        } else if (targetShape.size() > 0) {
            boolean isSolid = render == TileEntityPatternBuilder.RenderType.SOLID;
            try {
                Map<BlockPos, IBlockState> shapeModel = tile.getShapeFancy(tile.getSourceShape(), targetShape);
                for (Map.Entry<BlockPos, IBlockState> entry : shapeModel.entrySet()) {
                    UtilWorld.RenderShadow.renderBlockPhantom(te.func_145831_w(), te.func_174877_v(), entry.getValue(), x, y, z, entry.getKey(), isSolid);
                }
            }
            catch (Exception e) {
                ModCyclic.logger.error("render blockModel phantom error", e);
            }
        }
    }
}

