/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.battery;

import com.lothrazar.cyclicmagic.block.battery.TileEntityBattery;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.block.BlockBaseHasTile;
import com.lothrazar.cyclicmagic.energy.EnergyStore;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class BlockBattery
extends BlockBaseHasTile
implements IHasRecipe {
    public static final PropertyEnum<EnergyFlatMap> AMOUNT = PropertyEnum.func_177709_a((String)"amount", EnergyFlatMap.class);

    public BlockBattery(boolean creat) {
        super(Material.field_151576_e);
        this.setGuiId(38);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedOreRecipe(new ItemStack((Block)this), "cbc", "bab", "cbc", Character.valueOf('c'), Items.field_151119_aD, Character.valueOf('b'), Blocks.field_150359_w, Character.valueOf('a'), "blockRedstone");
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntityBattery();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Item item = Item.func_150898_a((Block)this);
        TileEntity ent = world.func_175625_s(pos);
        ItemStack stack = new ItemStack(item);
        if (ent != null && ent.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage handlerHere = (IEnergyStorage)ent.getCapability(CapabilityEnergy.ENERGY, null);
            if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                EnergyStore storage = (EnergyStore)((Object)stack.getCapability(CapabilityEnergy.ENERGY, null));
                storage.setEnergyStored(handlerHere.getEnergyStored());
            }
        }
        ret.add(stack);
        return ret;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBattery) {
            IEnergyStorage handlerHere = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, null);
            double percent = (double)handlerHere.getEnergyStored() / (double)handlerHere.getMaxEnergyStored();
            EnergyFlatMap p = EnergyFlatMap.AMOUNT_G0;
            p = percent == 0.0 ? EnergyFlatMap.AMOUNT_G0 : (percent < 0.0625 ? EnergyFlatMap.AMOUNT_G1 : (percent < 0.125 ? EnergyFlatMap.AMOUNT_G2 : (percent < 0.1875 ? EnergyFlatMap.AMOUNT_G3 : (percent < 0.25 ? EnergyFlatMap.AMOUNT_G4 : (percent < 0.3125 ? EnergyFlatMap.AMOUNT_G5 : (percent < 0.375 ? EnergyFlatMap.AMOUNT_G6 : (percent < 0.4375 ? EnergyFlatMap.AMOUNT_G7 : (percent < 0.5 ? EnergyFlatMap.AMOUNT_G8 : (percent < 0.5625 ? EnergyFlatMap.AMOUNT_G9 : (percent < 0.625 ? EnergyFlatMap.AMOUNT_G10 : (percent < 0.6875 ? EnergyFlatMap.AMOUNT_G11 : (percent < 0.75 ? EnergyFlatMap.AMOUNT_G12 : (percent < 0.8125 ? EnergyFlatMap.AMOUNT_G13 : (percent < 0.875 ? EnergyFlatMap.AMOUNT_G14 : (percent < 0.9375 ? EnergyFlatMap.AMOUNT_G15 : EnergyFlatMap.AMOUNT_G16)))))))))))))));
            return state.func_177226_a(AMOUNT, (Comparable)((Object)p));
        }
        return super.func_176221_a(state, world, pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AMOUNT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            TileEntityBattery container = (TileEntityBattery)world.func_175625_s(pos);
            container.setEnergyCurrent(storage.getEnergyStored());
        } else if (stack.func_77978_p() != null && world.func_175625_s(pos) instanceof TileEntityBattery) {
            NBTTagCompound tags = stack.func_77978_p();
            int energy = tags.func_74762_e("energy");
            TileEntityBattery container = (TileEntityBattery)world.func_175625_s(pos);
            container.setEnergyCurrent(energy);
        }
    }

    static enum EnergyFlatMap implements IStringSerializable
    {
        AMOUNT_G0("g0"),
        AMOUNT_G1("g1"),
        AMOUNT_G2("g2"),
        AMOUNT_G3("g3"),
        AMOUNT_G4("g4"),
        AMOUNT_G5("g5"),
        AMOUNT_G6("g6"),
        AMOUNT_G7("g7"),
        AMOUNT_G8("g8"),
        AMOUNT_G9("g9"),
        AMOUNT_G10("g10"),
        AMOUNT_G11("g11"),
        AMOUNT_G12("g12"),
        AMOUNT_G13("g13"),
        AMOUNT_G14("g14"),
        AMOUNT_G15("g15"),
        AMOUNT_G16("g16");

        private final String name;

        private EnergyFlatMap(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

