/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.applesprout;

import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.block.BlockBase;
import com.lothrazar.cyclicmagic.core.util.UtilOreDictionary;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarrot;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAppleCrop
extends BlockBase
implements IGrowable,
IHasRecipe {
    private static final int LIGHT_GROWTH = 5;
    private static final double BONEMEAL_CHANCE = 0.45;
    private static final int MAX_AGE = 7;
    private static final PropertyInteger AGE = BlockCarrot.field_176488_a;
    private static final AxisAlignedBB[] GROWING_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.9, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.8, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.7, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.5, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.4, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.3, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.2, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.2, 0.25, 0.75, 1.0, 0.75)};

    public BlockAppleCrop() {
        super(Material.field_151585_k);
        this.func_149711_c(0.5f);
        this.func_149713_g(0);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_175684_a(new BlockPos((Vec3i)pos), (Block)this, this.func_149738_a(world));
    }

    public void observedNeighborChange(IBlockState observerState, World world, BlockPos pos, Block changedBlock, BlockPos changedBlockPos) {
        if (!this.canStay(world, pos)) {
            world.func_175655_b(pos, true);
        } else {
            super.observedNeighborChange(observerState, world, pos, changedBlock, changedBlockPos);
        }
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        if (!this.canStay(world, pos)) {
            return false;
        }
        return this.func_176196_c(world, pos);
    }

    public int func_149738_a(World world) {
        return 11800;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!this.canStay(world, pos)) {
            world.func_175655_b(pos, true);
        } else {
            this.func_176474_b(world, rand, pos, state);
        }
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return world.func_175699_k(pos) > 5;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return (double)world.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        int age;
        if (!this.canStay(world, pos)) {
            world.func_175655_b(pos, true);
        } else if (!world.field_72995_K && (age = ((Integer)state.func_177229_b((IProperty)AGE)).intValue()) < 7) {
            world.func_180501_a(pos, this.getStateForAge(age + 1), 3);
            world.func_175684_a(new BlockPos((Vec3i)pos), (Block)this, this.func_149738_a(world));
        }
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.isMaxAge(state) ? Items.field_151034_e : Item.func_150898_a((Block)this);
    }

    private IBlockState getStateForAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) >= 7;
    }

    public IBlockState func_176203_a(int meta) {
        return this.getStateForAge(meta);
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return GROWING_AABB[(Integer)state.func_177229_b((IProperty)AGE)];
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapelessRecipe(new ItemStack((Block)this, 2), new ItemStack(Items.field_151034_e), "stickWood");
    }

    private boolean canStay(World world, BlockPos pos) {
        Block blockAbove = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        return UtilOreDictionary.doesMatchOreDict(new ItemStack(blockAbove), "treeLeaves");
    }
}

