/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.block.BlockBase;
import com.lothrazar.cyclicmagic.core.util.UtilFakePlayer;
import com.lothrazar.cyclicmagic.core.util.UtilSound;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.FakePlayer;

public class BlockSpikesRetractable
extends BlockBase
implements IHasRecipe,
IHasConfig {
    private static final PropertyBool ACTIVATED = PropertyBool.func_177716_a((String)"activated");
    private static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);
    private static final float LARGE = 0.9375f;
    private static final float SMALL = 0.0625f;
    private static final AxisAlignedBB NORTH_BOX = new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB EAST_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0);
    private static final AxisAlignedBB SOUTH_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
    private static final AxisAlignedBB WEST_BOX = new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB UP_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    private static final AxisAlignedBB DOWN_BOX = new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);
    private static WeakReference<FakePlayer> fakePlayer;
    private static UUID uuid;
    private boolean doesPlayerDamage;
    private int damageIron = 1;
    private int damageDiamond = 2;

    public BlockSpikesRetractable(boolean doesPlayer) {
        super(Material.field_151573_f);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.setTranslucent();
        this.doesPlayerDamage = doesPlayer;
    }

    public static EnumFacing getFacing(int meta) {
        return EnumFacing.func_82600_a((int)(meta & 7));
    }

    public static EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b(FACING);
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)BlockSpikesRetractable.getFacing(meta)).func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    private int getDamage() {
        return this.doesPlayerDamage ? this.damageDiamond : this.damageIron;
    }

    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int i = b0 | ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)ACTIVATED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase && ((Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)ACTIVATED)).booleanValue()) {
            if (this.doesPlayerDamage) {
                if (worldIn instanceof WorldServer) {
                    if (uuid == null) {
                        uuid = UUID.randomUUID();
                    }
                    if (fakePlayer == null && (fakePlayer = UtilFakePlayer.initFakePlayer((WorldServer)worldIn, uuid, "spikes")) == null) {
                        ModCyclic.logger.error("Fake player failed to init ");
                        return;
                    }
                    entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)fakePlayer.get())), (float)this.getDamage());
                }
            } else {
                entity.func_70097_a(DamageSource.field_76367_g, (float)this.getDamage());
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVATED});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)ACTIVATED)).booleanValue()) {
            return field_185505_j;
        }
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b(FACING);
        switch (enumfacing) {
            case NORTH: {
                return NORTH_BOX;
            }
            case EAST: {
                return EAST_BOX;
            }
            case SOUTH: {
                return SOUTH_BOX;
            }
            case WEST: {
                return WEST_BOX;
            }
            case UP: {
                return UP_BOX;
            }
            case DOWN: {
                return DOWN_BOX;
            }
        }
        return field_185505_j;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing facState = BlockSpikesRetractable.getFacing(state);
        if (!(this.func_176196_c(world, pos) && world.isSideSolid(pos.func_177972_a(facState.func_176734_d()), facState, true) || !world.func_175698_g(pos))) {
            this.func_176226_b(world, pos, this.func_176223_P(), 0);
            return;
        }
        if (!((Boolean)state.func_177229_b((IProperty)ACTIVATED)).booleanValue() && world.func_175640_z(pos)) {
            UtilSound.playSoundFromServer(SoundRegistry.spikes_on, SoundCategory.BLOCKS, pos, world.field_73011_w.getDimension(), 16);
            world.func_175656_a(pos, state.func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(true)));
        } else if (((Boolean)state.func_177229_b((IProperty)ACTIVATED)).booleanValue() && !world.func_175640_z(pos)) {
            UtilSound.playSoundFromServer(SoundRegistry.spikes_off, SoundCategory.BLOCKS, pos, world.field_73011_w.getDimension(), 16);
            world.func_175656_a(pos, state.func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        this.func_189540_a(state, worldIn, pos, this, pos);
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase player, EnumHand hand) {
        return worldIn.isSideSolid(pos.func_177972_a(facing.func_176734_d()), facing, true) ? this.func_176223_P().func_177226_a(FACING, (Comparable)facing).func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(false)) : this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return worldIn.isSideSolid(pos.func_177972_a(side.func_176734_d()), side, true);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing fac : EnumFacing.values()) {
            if (!worldIn.isSideSolid(pos.func_177972_a(fac), fac.func_176734_d(), true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IRecipe addRecipe() {
        if (this.doesPlayerDamage) {
            return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 2), " s ", "s s", "ttt", Character.valueOf('s'), Items.field_151045_i, Character.valueOf('t'), "blockIron");
        }
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 2), " s ", "s s", "ttt", Character.valueOf('s'), Blocks.field_150411_aY, Character.valueOf('t'), Blocks.field_150456_au);
    }

    @Override
    public void syncConfig(Configuration config) {
        this.damageIron = config.getInt("SpikeIronDamage", "modpacks", 1, 1, 99, "Damage per second of iron spikes");
        this.damageDiamond = config.getInt("SpikeDiamondDamage", "modpacks", 5, 1, 99, "Damage per second of iron spikes");
    }
}

