/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic;

import com.lothrazar.cyclicmagic.core.log.ModLogger;
import com.lothrazar.cyclicmagic.core.util.UtilString;
import com.lothrazar.cyclicmagic.creativetab.CreativeTabCyclic;
import com.lothrazar.cyclicmagic.gui.ForgeGuiHandler;
import com.lothrazar.cyclicmagic.item.cannon.ParticleEventManager;
import com.lothrazar.cyclicmagic.module.ICyclicModule;
import com.lothrazar.cyclicmagic.potion.PotionEffectRegistry;
import com.lothrazar.cyclicmagic.potion.PotionTypeRegistry;
import com.lothrazar.cyclicmagic.proxy.CommonProxy;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.CapabilityRegistry;
import com.lothrazar.cyclicmagic.registry.ConfigRegistry;
import com.lothrazar.cyclicmagic.registry.EnchantRegistry;
import com.lothrazar.cyclicmagic.registry.EventRegistry;
import com.lothrazar.cyclicmagic.registry.InterModCommsRegistry;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.MaterialRegistry;
import com.lothrazar.cyclicmagic.registry.ModuleRegistry;
import com.lothrazar.cyclicmagic.registry.PacketRegistry;
import com.lothrazar.cyclicmagic.registry.PermissionRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.ReflectionRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.registry.VillagerProfRegistry;
import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

@Mod(modid="cyclicmagic", useMetadata=true, dependencies="before:guideapi;after:jei;after:baubles,crafttweaker", canBeDeactivated=false, updateJSON="https://raw.githubusercontent.com/PrinceOfAmber/CyclicMagic/master/update.json", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12,)", guiFactory="com.lothrazar.cyclicmagic.config.IngameConfigFactory")
public class ModCyclic {
    @Mod.Instance(value="cyclicmagic")
    public static ModCyclic instance;
    @SidedProxy(clientSide="com.lothrazar.cyclicmagic.proxy.ClientProxy", serverSide="com.lothrazar.cyclicmagic.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static ModLogger logger;
    public EventRegistry events;
    public static SimpleNetworkWrapper network;
    public static final CreativeTabCyclic TAB;
    @CapabilityInject(value=CapabilityRegistry.IPlayerExtendedProperties.class)
    public static final Capability<CapabilityRegistry.IPlayerExtendedProperties> CAPABILITYSTORAGE;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        logger = new ModLogger(event.getModLog());
        ConfigRegistry.oreConfig = new Configuration(new File(event.getModConfigurationDirectory(), "cyclic_ores.cfg"));
        ConfigRegistry.init(new Configuration(event.getSuggestedConfigurationFile()));
        ConfigRegistry.register(logger);
        MinecraftForge.EVENT_BUS.register((Object)new ParticleEventManager());
        network = NetworkRegistry.INSTANCE.newSimpleChannel("cyclicmagic");
        PacketRegistry.register(network);
        SoundRegistry.register();
        CapabilityRegistry.register();
        ReflectionRegistry.register();
        MaterialRegistry.register();
        this.events = new EventRegistry();
        this.events.registerCoreEvents();
        ModuleRegistry.init();
        ModuleRegistry.registerAll();
        ConfigRegistry.syncAllConfig();
        for (ICyclicModule module : ModuleRegistry.modules) {
            module.onPreInit();
        }
        proxy.preInit();
        MinecraftForge.EVENT_BUS.register(ItemRegistry.class);
        MinecraftForge.EVENT_BUS.register(BlockRegistry.class);
        MinecraftForge.EVENT_BUS.register(RecipeRegistry.class);
        MinecraftForge.EVENT_BUS.register(SoundRegistry.class);
        MinecraftForge.EVENT_BUS.register(PotionEffectRegistry.class);
        MinecraftForge.EVENT_BUS.register(PotionTypeRegistry.class);
        MinecraftForge.EVENT_BUS.register(EnchantRegistry.class);
        MinecraftForge.EVENT_BUS.register(VillagerProfRegistry.class);
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        for (ICyclicModule module : ModuleRegistry.modules) {
            module.onInit();
        }
        proxy.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new ForgeGuiHandler());
        ConfigRegistry.syncAllConfig();
        this.events.registerAll();
        PermissionRegistry.register();
        InterModCommsRegistry.register();
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        for (ICyclicModule module : ModuleRegistry.modules) {
            module.onPostInit();
        }
        if (logger.runUnitTests()) {
            UtilString.unitTests();
        }
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        for (ICyclicModule module : ModuleRegistry.modules) {
            module.onServerStarting(event);
        }
    }

    static {
        TAB = new CreativeTabCyclic();
        CAPABILITYSTORAGE = null;
        FluidRegistry.enableUniversalBucket();
    }
}

