/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.util;

import io.netty.buffer.ByteBuf;
import java.awt.Desktop;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class NetworkUtil {
    public static NBTTagCompound readNBTTagCompound(ByteBuf buf) {
        try {
            short as = buf.readShort();
            if (as < 0) {
                return null;
            }
            byte[] ba = new byte[as];
            buf.readBytes(ba);
            return CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(ba));
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "NBT Packet Read", true);
            return null;
        }
    }

    public static void writeNBTTagCompound(NBTTagCompound nbt, ByteBuf buf) {
        try {
            if (nbt == null) {
                buf.writeShort(-1);
            } else {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)os);
                byte[] ba = os.toByteArray();
                buf.writeShort((int)((short)ba.length));
                buf.writeBytes(ba);
            }
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "NBT Packet Write", true);
        }
    }

    public static void openLink(String url) {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(url));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

