/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.tile.energy;

import com.valkyrieofnight.vlib.lib.tile.VLTileTickable;
import com.valkyrieofnight.vlib.lib.tilemodule.energyu.ITileUEConsumer;
import com.valkyrieofnight.vlib.lib.tilemodule.energyu.TileModuleUEnergy;
import com.valkyrieofnight.vlib.lib.tilemodule.energyu.storage.UEnergyConsumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;

public abstract class VLTileEnergyConsumer
extends VLTileTickable
implements ITileUEConsumer {
    protected boolean ic2EU = false;
    protected boolean bcMJ = false;
    protected UEnergyConsumer eBuffer;

    public VLTileEnergyConsumer(int capacity) {
        this(capacity, capacity);
    }

    public VLTileEnergyConsumer(int capacity, int maxReceive) {
        this.eBuffer = new UEnergyConsumer(capacity, maxReceive);
        this.addModule(new TileModuleUEnergy(this));
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.canEnergyConnect(facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && this.canEnergyConnect(facing)) {
            return (T)this.eBuffer;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.eBuffer.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.eBuffer.readFromNBT(nbt);
    }

    public UEnergyConsumer getEBuffer() {
        return this.eBuffer;
    }

    protected abstract boolean canEnergyConnect(EnumFacing var1);

    @Optional.Method(modid="valkyriecompat")
    public boolean acceptsIc2EnergyFrom(EnumFacing side) {
        return !this.ic2EU ? false : this.canEnergyConnect(side);
    }

    @Optional.Method(modid="valkyriecompat")
    public double injectIc2Energy(EnumFacing directionFrom, double amount, double voltage) {
        return this.eBuffer.injectIc2Energy(amount, voltage);
    }

    @Optional.Method(modid="valkyriecompat")
    public double getIc2DemandedEnergy() {
        return this.eBuffer.getIc2DemandedEnergy();
    }

    @Optional.Method(modid="valkyriecompat")
    public int getIc2Tier() {
        return Integer.MAX_VALUE;
    }
}

