/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.tile;

import com.valkyrieofnight.vlib.lib.tile.VLTile;
import com.valkyrieofnight.vlib.lib.tilemodule.ITileModule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;

public abstract class VLTileTickable
extends VLTile
implements ITickable {
    private List<ITileModule> modules = new ArrayList<ITileModule>();

    protected void addModule(ITileModule module) {
        if (module != null) {
            this.modules.add(module);
        }
    }

    public void func_73660_a() {
        for (ITileModule iTileModule : this.modules) {
            iTileModule.update();
        }
    }

    public void func_145843_s() {
        for (ITileModule iTileModule : this.modules) {
            iTileModule.invalidate();
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        for (ITileModule iTileModule : this.modules) {
            iTileModule.onChunkUnload();
        }
        super.onChunkUnload();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        for (ITileModule iTileModule : this.modules) {
            if (!iTileModule.hasCapability(capability, facing)) continue;
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        for (ITileModule iTileModule : this.modules) {
            if (!iTileModule.hasCapability(capability, facing)) continue;
            return (T)iTileModule.getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        for (ITileModule iTileModule : this.modules) {
            iTileModule.writeToNBT(nbt);
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (ITileModule iTileModule : this.modules) {
            iTileModule.readFromNBT(nbt);
        }
    }
}

