/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.client.gui;

import com.valkyrieofnight.vlib.lib.client.gui.VLGui;
import com.valkyrieofnight.vlib.lib.client.gui.base.IGuiDraw;
import com.valkyrieofnight.vlib.lib.client.gui.base.IGuiDrawTooltip;
import com.valkyrieofnight.vlib.lib.client.gui.base.IGuiInput;
import com.valkyrieofnight.vlib.lib.client.gui.base.IGuiInputAction;
import com.valkyrieofnight.vlib.lib.client.gui.base.IGuiUpdate;
import com.valkyrieofnight.vlib.lib.client.gui.elements.VLElement;
import com.valkyrieofnight.vlib.lib.inventory.VLContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class VLGuiContainer
extends GuiContainer
implements IGuiInput,
IGuiInputAction,
IGuiDraw,
IGuiUpdate,
VLGui {
    public int field_147003_i = 0;
    public int field_147009_r = 0;
    public int sizeX = 0;
    public int sizeY = 0;
    public int maxWidth = 0;
    public int maxHeight = 0;
    public int border = 8;
    public int dimModulus = 16;
    public boolean initSizeComplete = false;
    protected List<VLElement> elements = new ArrayList<VLElement>();
    boolean init = false;
    private int blmx = 0;
    private int blmy = 0;
    boolean down = false;

    public VLGuiContainer(VLContainer inventorySlotsIn) {
        super((Container)inventorySlotsIn);
    }

    public void setGuiMaxSize(int maxX, int maxY) {
        this.maxWidth = maxX;
        this.maxHeight = maxY;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public void setDimModulus(int modulus) {
        this.dimModulus = modulus;
    }

    public void addElement(VLElement ele) {
        ele.setGui(this);
        this.elements.add(ele);
    }

    public boolean allowResize() {
        return false;
    }

    public void resize() {
        this.sizeX = this.field_146294_l - this.border * 2;
        this.sizeY = this.field_146295_m - this.border * 2;
        this.sizeX = this.maxWidth <= 0 ? this.sizeX : Math.min(this.maxWidth, this.sizeX);
        this.sizeY = this.maxHeight <= 0 ? this.sizeY : Math.min(this.maxHeight, this.sizeY);
        this.sizeX -= this.sizeX % this.dimModulus;
        this.sizeY -= this.sizeY % this.dimModulus;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.update();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.allowResize()) {
            if (!this.initSizeComplete) {
                this.resize();
                this.initSizeComplete = true;
            }
        } else {
            this.resize();
        }
        this.field_147003_i = (int)Math.floor(((double)this.field_146294_l - (double)this.sizeX) / 2.0);
        this.field_147009_r = (int)Math.floor(((double)this.field_146295_m - (double)this.sizeY) / 2.0);
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.onMouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public Gui getGui() {
        return this;
    }

    @Override
    public int getGuiLeft() {
        return this.field_147003_i;
    }

    @Override
    public int getGuiTop() {
        return this.field_147009_r;
    }

    @Override
    public int getGuiSizeX() {
        return this.sizeX;
    }

    @Override
    public int getGuiSizeY() {
        return this.sizeY;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    @Override
    public boolean isInGUI(int x, int y) {
        return this.isInBox(x, y, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public void onElementResize(VLElement ele) {
    }

    @Override
    public void update() {
        for (VLElement ele : this.elements) {
            if (!(ele instanceof IGuiUpdate)) continue;
            ((IGuiUpdate)((Object)ele)).update();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackgroundLayer(mouseX, mouseY, partialTicks);
        this.blmx = mouseX;
        this.blmy = mouseY;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawForegroundLayer(this.blmx, this.blmy, 0.0f);
        super.func_146979_b(this.blmx, this.blmy);
    }

    @Override
    public void drawBackgroundLayer(int mx, int my, float partialTicks) {
        for (VLElement ele : this.elements) {
            if (!(ele instanceof IGuiDraw) || !((IGuiDraw)((Object)ele)).isBackgroundVisible()) continue;
            ((IGuiDraw)((Object)ele)).drawBackgroundLayer(mx, my, partialTicks);
        }
    }

    @Override
    public void drawForegroundLayer(int mx, int my, float partialTicks) {
        for (VLElement ele : this.elements) {
            if (!(ele instanceof IGuiDraw) || !((IGuiDraw)((Object)ele)).isForegroundVisible()) continue;
            ((IGuiDraw)((Object)ele)).drawForegroundLayer(mx, my, partialTicks);
        }
        for (VLElement ele : this.elements) {
            if (!(ele instanceof IGuiDrawTooltip)) continue;
            ((IGuiDrawTooltip)((Object)ele)).drawToolTip(mx, my);
        }
    }

    @Override
    public boolean onMouseClicked(int mx, int my, int mouseButton) {
        if (mouseButton == 0) {
            if (this.down) {
                this.down = false;
                return false;
            }
            this.down = true;
        }
        boolean any = false;
        for (VLElement ele : this.elements) {
            if (!(ele instanceof IGuiInput)) continue;
            ((IGuiInput)((Object)ele)).onMouseClicked(mx, my, mouseButton);
            this.mouseClicked(ele, mx, my, mouseButton);
        }
        return any;
    }

    @Override
    public boolean onMouseScrolled(int mx, int my, int scroll) {
        boolean any = false;
        for (VLElement ele : this.elements) {
            if (!(ele instanceof IGuiInput)) continue;
            ((IGuiInput)((Object)ele)).onMouseScrolled(mx, my, scroll);
            this.mouseScrolled(ele, mx, my, scroll);
        }
        return any;
    }

    @Override
    public boolean onKeyTyped(char character, int keyCode) {
        boolean any = false;
        for (VLElement ele : this.elements) {
            if (!(ele instanceof IGuiInput)) continue;
            ((IGuiInput)((Object)ele)).onKeyTyped(character, keyCode);
            this.keyTyped(ele, character, keyCode);
        }
        return any;
    }

    @Override
    public void mouseClicked(VLElement ele, int mx, int my, int mouseButton) {
    }

    @Override
    public void mouseScrolled(VLElement ele, int mx, int my, int scroll) {
    }

    @Override
    public void keyTyped(VLElement ele, char character, int keyCode) {
    }

    @Override
    public void drawHoverText(List<String> list, int x, int y) {
        super.func_146283_a(list, x, y);
    }

    @Override
    public int getScreenSizeX() {
        return this.field_146294_l;
    }

    @Override
    public int getScreenSizeY() {
        return this.field_146295_m;
    }
}

