/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.network;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.capability.inventorystate.IInventoryState;
import org.cyclops.commoncapabilities.api.capability.itemhandler.DefaultSlotlessItemHandlerWrapper;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.network.PositionedAddonsNetwork;
import org.cyclops.integratedtunnels.Capabilities;
import org.cyclops.integratedtunnels.api.network.IItemNetwork;
import org.cyclops.integratedtunnels.core.TunnelItemHelpers;
import org.cyclops.integratedtunnels.core.network.ItemChannel;

public class ItemNetwork
extends PositionedAddonsNetwork
implements IItemNetwork,
IInventoryState {
    private static final Cache<PartPos, IItemHandler> CACHE_ITEMHANDLER = CacheBuilder.newBuilder().weakValues().expireAfterAccess(50L, TimeUnit.MILLISECONDS).build();
    private static final Cache<PartPos, ISlotlessItemHandler> CACHE_SLOTLESSITEMHANDLER = CacheBuilder.newBuilder().weakValues().expireAfterAccess(50L, TimeUnit.MILLISECONDS).build();

    protected IItemHandler getItemHandler(IPositionedAddonsNetwork.PrioritizedPartPos pos) {
        if (this.isPositionDisabled(pos.getPartPos())) {
            return null;
        }
        IItemHandler itemHandler = (IItemHandler)CACHE_ITEMHANDLER.getIfPresent((Object)pos.getPartPos());
        if (itemHandler == null && (itemHandler = (IItemHandler)TileHelpers.getCapability((DimPos)pos.getPartPos().getPos(), (EnumFacing)pos.getPartPos().getSide(), (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) != null) {
            CACHE_ITEMHANDLER.put((Object)pos.getPartPos(), (Object)itemHandler);
        }
        return itemHandler;
    }

    protected ISlotlessItemHandler getSlotlessItemHandler(IPositionedAddonsNetwork.PrioritizedPartPos pos) {
        if (this.isPositionDisabled(pos.getPartPos())) {
            return null;
        }
        ISlotlessItemHandler slotlessItemHandler = (ISlotlessItemHandler)CACHE_SLOTLESSITEMHANDLER.getIfPresent((Object)pos.getPartPos());
        if (slotlessItemHandler == null) {
            IItemHandler itemHandler;
            slotlessItemHandler = (ISlotlessItemHandler)TileHelpers.getCapability((DimPos)pos.getPartPos().getPos(), (EnumFacing)pos.getPartPos().getSide(), Capabilities.SLOTLESS_ITEMHANDLER);
            if (slotlessItemHandler == null && (itemHandler = this.getItemHandler(pos)) != null) {
                slotlessItemHandler = new DefaultSlotlessItemHandlerWrapper(itemHandler);
            }
            CACHE_SLOTLESSITEMHANDLER.put((Object)pos.getPartPos(), (Object)slotlessItemHandler);
        }
        return slotlessItemHandler;
    }

    protected IInventoryState getInventoryState(IPositionedAddonsNetwork.PrioritizedPartPos pos) {
        if (this.isPositionDisabled(pos.getPartPos())) {
            return null;
        }
        return (IInventoryState)TileHelpers.getCapability((DimPos)pos.getPartPos().getPos(), (EnumFacing)pos.getPartPos().getSide(), Capabilities.INVENTORY_STATE);
    }

    public boolean addPosition(PartPos pos, int priority, int channel) {
        IItemHandler itemHandler = (IItemHandler)TileHelpers.getCapability((DimPos)pos.getPos(), (EnumFacing)pos.getSide(), (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        return itemHandler != null && super.addPosition(pos, priority, channel);
    }

    public int getHash() {
        int hash = 0;
        int i = 0;
        for (IPositionedAddonsNetwork.PrioritizedPartPos partPos : this.getPositions()) {
            IItemHandler itemHandler = this.getItemHandler(partPos);
            if (itemHandler == null) continue;
            hash += TunnelItemHelpers.calculateInventoryState(itemHandler, this.getInventoryState(partPos)) + i++;
        }
        return hash;
    }

    public IItemNetwork.IItemChannel getChannel(int channel) {
        return new ItemChannel(this, channel);
    }
}

