/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.integratedtunnels.GeneralConfig;

public class ItemHandlerWorldEntityImportWrapper
implements IItemHandler {
    private final WorldServer world;
    private final BlockPos pos;
    private final EnumFacing facing;
    private final List<EntityItem> entities;

    public ItemHandlerWorldEntityImportWrapper(WorldServer world, BlockPos pos, EnumFacing facing, boolean ignorePickupDelay) {
        this(world, pos, facing, new AxisAlignedBB(pos), ignorePickupDelay);
    }

    public ItemHandlerWorldEntityImportWrapper(WorldServer world, BlockPos pos, EnumFacing facing, AxisAlignedBB area, final boolean ignorePickupDelay) {
        this.world = world;
        this.pos = pos;
        this.facing = facing;
        this.entities = world.func_175647_a(EntityItem.class, area, (Predicate)new Predicate<EntityItem>(){

            public boolean apply(EntityItem input) {
                return (ignorePickupDelay || !input.func_174874_s()) && !input.field_70128_L;
            }
        });
    }

    public int getSlots() {
        return this.entities.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return slot < this.entities.size() ? this.entities.get(slot).func_92059_d() : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot >= this.entities.size()) {
            return ItemStack.field_190927_a;
        }
        EntityItem entity = this.entities.get(slot);
        ItemStack itemStack = entity.func_92059_d();
        itemStack = itemStack.func_77946_l();
        ItemStack ret = itemStack.func_77979_a(amount);
        if (!simulate) {
            if (itemStack.func_190926_b()) {
                entity.func_70106_y();
            } else {
                entity.func_92058_a(itemStack);
            }
            if (GeneralConfig.worldInteractionEvents) {
                this.world.func_175718_b(1000, this.pos, 0);
                this.world.func_175718_b(2000, this.pos.func_177972_a(this.facing.func_176734_d()), this.facing.func_82601_c() + 1 + (this.facing.func_82599_e() + 1) * 3);
            }
        }
        return ret;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }
}

