/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.Registry;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.client.render.RenderRegistry;
import shetiphian.endertanks.common.misc.ProxyCommon;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.modintegration.ModIntegration;

@Mod(modid="endertanks", name="EnderTanks", version="1.6.6", dependencies="required-after:shetiphiancore@[v3.5.5,)", updateJSON="https://gist.githubusercontent.com/ShetiPhian/5a4332ca6221ae61ab3c6d531a989f21/raw/EnderTanks", acceptedMinecraftVersions="[1.12]")
@Mod.EventBusSubscriber
public class EnderTanks {
    @SidedProxy(clientSide="shetiphian.endertanks.client.misc.ProxyClient", serverSide="shetiphian.endertanks.common.misc.ProxyCommon")
    public static ProxyCommon proxy;
    @Mod.Instance(value="endertanks")
    public static EnderTanks INSTANCE;
    public static final String MOD_ID = "endertanks";

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        Registry.INSTANCE.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Registry.INSTANCE.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
        Registry.INSTANCE.registerItems((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelRegistryEvent event) throws Exception {
        RenderRegistry.renderingPreInt();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Values.logEnderTanks = event.getModLog();
        Values.minecraftDir = event.getModConfigurationDirectory().getParentFile().getAbsolutePath();
        proxy.renderingPreInt();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        Registry.INSTANCE.doRegistration();
        proxy.renderingInt();
        proxy.registerEventHandlers();
        new ModIntegration();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Configuration.EventHandler.process();
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        TankHelper.INSTANCE.loadTankData();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        TankHelper.INSTANCE.unloadTankData();
    }

    @Nonnull
    public static ItemStack getCustomItemStack(String name, int ... amount) {
        return Values.stacks.get(name, amount);
    }
}

