/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks;

import com.google.common.base.Strings;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.core.common.Function;
import shetiphian.endertanks.Values;

@Config(modid="endertanks", name="endertanks")
public class Configuration {
    @Config.Comment(value={"With this disabled tanks are essentially locked to the crafted color as dyes will no longer work"})
    public static boolean enableInWorldRecoloring = true;
    @Config.Comment(value={"Items used to upgrade the EnderTanks"})
    public static Menu_Upgrade UPGRADE_ITEMS = new Menu_Upgrade();
    @Config.RequiresMcRestart
    @Config.Comment(value={"NOTE: Capacity numbers are in buckets"})
    public static Menu_Settings UPGRADE_SETTINGS = new Menu_Settings();
    @Config.Comment(value={" "})
    public static Menu_Access ACCESS_SETTINGS = new Menu_Access();
    @Config.Comment(value={"Color Values for Bands,", "Format: Decimal Values (0 to 16,777,215)", "You can use this website to get the decimal value of any color:", "http://www.colorhexa.com", "Or by using the Color Mixer from this website:", "http://www.mathsisfun.com/hexadecimal-decimal-colors.html"})
    public static Menu_Color COLOR_VALUES = new Menu_Color();

    @Mod.EventBusSubscriber
    static class EventHandler {
        EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("endertanks")) {
                ConfigManager.sync((String)"endertanks", (Config.Type)Config.Type.INSTANCE);
                EventHandler.process();
            }
        }

        static void process() {
            int temp;
            if (Configuration.UPGRADE_SETTINGS.tankSizeMax < Configuration.UPGRADE_SETTINGS.tankSizeMin) {
                temp = Configuration.UPGRADE_SETTINGS.tankSizeMin;
                Configuration.UPGRADE_SETTINGS.tankSizeMin = Configuration.UPGRADE_SETTINGS.tankSizeMax;
                Configuration.UPGRADE_SETTINGS.tankSizeMax = temp;
            }
            if (Configuration.UPGRADE_SETTINGS.largeCapacity < Configuration.UPGRADE_SETTINGS.smallCapacity) {
                temp = Configuration.UPGRADE_SETTINGS.smallCapacity;
                Configuration.UPGRADE_SETTINGS.smallCapacity = Configuration.UPGRADE_SETTINGS.largeCapacity;
                Configuration.UPGRADE_SETTINGS.largeCapacity = temp;
            }
            Values.colorValues[0] = Configuration.COLOR_VALUES.white;
            Values.colorValues[1] = Configuration.COLOR_VALUES.orange;
            Values.colorValues[2] = Configuration.COLOR_VALUES.magenta;
            Values.colorValues[3] = Configuration.COLOR_VALUES.light_blue;
            Values.colorValues[4] = Configuration.COLOR_VALUES.yellow;
            Values.colorValues[5] = Configuration.COLOR_VALUES.lime;
            Values.colorValues[6] = Configuration.COLOR_VALUES.pink;
            Values.colorValues[7] = Configuration.COLOR_VALUES.gray;
            Values.colorValues[8] = Configuration.COLOR_VALUES.light_gray;
            Values.colorValues[9] = Configuration.COLOR_VALUES.cyan;
            Values.colorValues[10] = Configuration.COLOR_VALUES.purple;
            Values.colorValues[11] = Configuration.COLOR_VALUES.blue;
            Values.colorValues[12] = Configuration.COLOR_VALUES.brown;
            Values.colorValues[13] = Configuration.COLOR_VALUES.green;
            Values.colorValues[14] = Configuration.COLOR_VALUES.red;
            Values.colorValues[15] = Configuration.COLOR_VALUES.black;
            EventHandler.process(Configuration.UPGRADE_ITEMS.personalItems, Values.itemPersonal, new ItemStack(Items.field_151045_i));
            EventHandler.process(Configuration.UPGRADE_ITEMS.teamItems, Values.itemTeam, new ItemStack(Items.field_151166_bC));
            EventHandler.process(Configuration.UPGRADE_ITEMS.sCapacityItems, Values.itemCapacitySmall, new ItemStack(Items.field_151079_bi));
            EventHandler.process(Configuration.UPGRADE_ITEMS.lCapacityItems, Values.itemCapacityLarge, new ItemStack(Items.field_151061_bv));
            EventHandler.process(Configuration.UPGRADE_ITEMS.pumpItems, Values.itemPump, new ItemStack((Block)Blocks.field_150331_J));
        }

        private static void process(String[] names, ArrayList<ItemStack> list, ItemStack basic) {
            list.clear();
            for (String name : names) {
                String nameId;
                if (Strings.isNullOrEmpty((String)name)) continue;
                int meta = Short.MAX_VALUE;
                if (name.contains("@")) {
                    try {
                        meta = Integer.valueOf(name.split("@")[1]);
                        name = name.substring(0, name.lastIndexOf(64));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String modId = name.contains(":") ? name.split(":")[0] : "minecraft";
                String string = nameId = name.contains(":") ? name.split(":")[1] : name;
                if (modId.equalsIgnoreCase("ore") || modId.equalsIgnoreCase("oredictionary")) {
                    NonNullList ores = OreDictionary.getOres((String)nameId);
                    for (ItemStack ore : ores) {
                        EventHandler.addToList(ore, list);
                    }
                    continue;
                }
                EventHandler.addToList(Function.findItemStack((String)modId, (String)nameId, (int)meta), list);
            }
            if (list.isEmpty()) {
                list.add(basic);
            }
        }

        private static void addToList(ItemStack stack, ArrayList<ItemStack> list) {
            if (list != null && !stack.func_190926_b() && !list.contains(stack)) {
                list.add(stack);
            }
        }
    }

    public static class Menu_Color {
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int white = 0xFFFFFF;
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int orange = 14517579;
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int magenta = 12411333;
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int light_blue = 8296912;
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int yellow = 12892206;
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int lime = 4832573;
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int pink = 14195370;
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int gray = 0x464646;
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int light_gray = 0xA9AFAF;
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int cyan = 3373205;
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int purple = 8996546;
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int blue = 3292826;
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int brown = 5650466;
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int green = 3821086;
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int red = 0xA53A35;
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int black = 0x262626;
    }

    public static class Menu_Access {
        @Config.Comment(value={"Enables the usage of public tanks, if disabled tanks must be upgraded before use"})
        public boolean allowPublicTanks = true;
        @Config.Comment(value={"Enables the creation of personal tanks, if disabled tanks can not set personal.", "Does not effect tanks that are already set as personal"})
        public boolean allowPersonalTanks = true;
        @Config.Comment(value={"Enables the creation of team tanks, if disabled tanks can not be set team.", "Does not effect tanks that are already set as team"})
        public boolean allowTeamTanks = true;
        @Config.Comment(value={"Enables the usage of public buckets, if disabled buckets must be linked to an upgraded tank before use"})
        public boolean allowPublicBuckets = true;
        @Config.Comment(value={"Enables the linking of buckets to personal tanks.", "Does not effect buckets that are already linked to personal tanks"})
        public boolean allowPersonalBuckets = true;
        @Config.Comment(value={"Enables the linking of buckets to team tanks.", "Does not effect buckets that are already linked to team tanks"})
        public boolean allowTeamBuckets = true;
        @Config.Comment(value={"Public tanks can be used with automation.", "The internal pump is unaffected by this setting"})
        public boolean enableAutomationPublic = true;
        @Config.Comment(value={"Personal tanks can be used with automation.", "The internal pump is unaffected by this setting"})
        public boolean enableAutomationPersonal = true;
        @Config.Comment(value={"Team tanks can be used with automation.", "The internal pump is unaffected by this setting"})
        public boolean enableAutomationTeam = true;
        @Config.Comment(value={"While true a Personal tank can only be edited (upgrade, move, etc) by the owner"})
        public boolean lockPersonalEdit = true;
        @Config.Comment(value={"While true a Team tank can only be edited (upgrade, move, etc) by a team member"})
        public boolean lockTeamEdit = true;
        @Config.Comment(value={"While true only the owner can link a bucket to their tanks"})
        public boolean lockPersonalLink = true;
        @Config.Comment(value={"While true only a team member can link a bucket to team tanks"})
        public boolean lockTeamLink = true;
        @Config.Comment(value={"While true only the owner can use the tank"})
        public boolean lockPersonalUse = false;
        @Config.Comment(value={"While true only a team member can use the tank"})
        public boolean lockTeamUse = false;
    }

    public static class Menu_Settings {
        @Config.Comment(value={"How many internal pump upgrades can a tank have?", " default internal pump is only 1/4 bucket, upgrades make it a bucket per upgrade"})
        @Config.Name(value="PumpUpgrades")
        @Config.RangeInt(min=0, max=8)
        public int tankPumpMax = 4;
        @Config.Comment(value={"Minimum capacity an EnderTank holds"})
        @Config.Name(value="CapacityMin")
        @Config.RangeInt(min=4, max=128)
        public int tankSizeMin = 32;
        @Config.Comment(value={"Maximum capacity an EnderTank holds"})
        @Config.Name(value="CapacityMax")
        @Config.RangeInt(min=4, max=512)
        public int tankSizeMax = 256;
        @Config.Comment(value={"Capacity increased by 'SmallCapacity' Items"})
        @Config.Name(value="SmallCapacityUpgrade")
        @Config.RangeInt(min=2, max=16)
        public int smallCapacity = 8;
        @Config.Comment(value={"Capacity increased by 'LargeCapacity' Items"})
        @Config.Name(value="LargeCapacityUpgrade")
        @Config.RangeInt(min=4, max=32)
        public int largeCapacity = 16;
    }

    public static class Menu_Upgrade {
        @Config.Comment(value={"Items Listed are used to make the tanks personal"})
        @Config.Name(value="Personal")
        public String[] personalItems = new String[]{"ore:gemDiamond"};
        @Config.Comment(value={"Items Listed are used to make the tanks team tanks"})
        @Config.Name(value="Team")
        public String[] teamItems = new String[]{"ore:gemEmerald"};
        @Config.Comment(value={"Items Listed upgrade storage capacity by 'SmallCapacityUpgrade'"})
        @Config.Name(value="SmallCapacity")
        public String[] sCapacityItems = new String[]{"ore:enderpearl"};
        @Config.Comment(value={"Items Listed upgrade storage capacity by 'LargeCapacityUpgrade'"})
        @Config.Name(value="LargeCapacity")
        public String[] lCapacityItems = new String[]{"minecraft:ender_eye"};
        @Config.Comment(value={"Items Listed are used to increase the tanks internal pump"})
        @Config.Name(value="Pump")
        public String[] pumpItems = new String[]{"minecraft:piston"};
    }
}

