/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.dave.compactmachines3.reference.EnumMachineSize;
import org.dave.compactmachines3.tile.TileEntityMachine;
import org.dave.compactmachines3.utility.ChunkUtils;
import org.dave.compactmachines3.utility.DimensionBlockPos;
import org.dave.compactmachines3.world.WorldSavedDataMachines;
import org.dave.compactmachines3.world.tools.DimensionTools;

public class MessageMachineContent
implements IMessage {
    protected NBTTagCompound data;
    protected int machineSize;
    protected int coords;
    protected DimensionBlockPos machinePos;
    protected String owner;
    protected String customName;

    public MessageMachineContent(int coords) {
        TileEntity te;
        this.coords = coords;
        WorldSavedDataMachines data = WorldSavedDataMachines.INSTANCE;
        this.machinePos = data.getMachinePosition(coords);
        this.machineSize = data.machineSizes.getOrDefault(coords, EnumMachineSize.MAXIMUM).getDimension();
        Chunk chunk = DimensionTools.getServerMachineWorld().func_175726_f(new BlockPos(coords * 1024, 40, 0));
        this.data = ChunkUtils.writeChunkToNBT(chunk, (World)DimensionTools.getServerMachineWorld(), new NBTTagCompound());
        if (this.machinePos != null && (te = DimensionTools.getWorldServerForDimension(this.machinePos.getDimension()).func_175625_s(this.machinePos.getBlockPos())) != null && te instanceof TileEntityMachine) {
            TileEntityMachine machine = (TileEntityMachine)te;
            this.owner = machine.getOwnerName();
            this.customName = machine.getCustomName();
        }
    }

    public MessageMachineContent() {
    }

    public void setData(NBTTagCompound data) {
        this.data = data;
    }

    public void setMachineSize(int machineSize) {
        this.machineSize = machineSize;
    }

    public void setCoords(int coords) {
        this.coords = coords;
    }

    public void setMachinePos(DimensionBlockPos machinePos) {
        this.machinePos = machinePos;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public void fromBytes(ByteBuf buf) {
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
        this.machineSize = buf.readInt();
        this.coords = buf.readInt();
        boolean hasMachineBlock = buf.readBoolean();
        if (hasMachineBlock) {
            this.machinePos = new DimensionBlockPos(buf);
            this.owner = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.customName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
        buf.writeInt(this.machineSize);
        buf.writeInt(this.coords);
        if (this.machinePos != null) {
            buf.writeBoolean(true);
            this.machinePos.writeToByteBuf(buf);
            String owner = this.owner == null ? "" : this.owner;
            String customName = this.customName == null ? "" : this.customName;
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)owner);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)customName);
        } else {
            buf.writeBoolean(false);
        }
    }
}

