/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.gui.machine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.dave.compactmachines3.gui.machine.GuiMachineContainer;
import org.dave.compactmachines3.gui.machine.GuiMachineData;
import org.dave.compactmachines3.misc.ConfigurationHandler;
import org.dave.compactmachines3.misc.RenderTickCounter;
import org.dave.compactmachines3.utility.ChunkUtils;
import org.dave.compactmachines3.utility.Logz;

public class GuiMachine
extends GuiContainer {
    protected static final int GUI_WIDTH = 256;
    protected static final int GUI_HEIGHT = 256;
    private int prevMouseX = -1;
    private int prevMouseY = -1;
    protected double rotateX = 0.0;
    protected double rotateY = -25.0;
    int glListId = -1;

    public GuiMachine() {
        super((Container)new GuiMachineContainer());
        this.field_146294_l = 256;
        this.field_146295_m = 256;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (!GuiMachineData.canRender) {
            return;
        }
        if (GuiMachineData.requiresNewDisplayList) {
            TileEntityRendererDispatcher.field_147556_a.func_147543_a((World)GuiMachineData.proxyWorld);
            if (this.glListId != -1) {
                GLAllocation.func_74523_b((int)this.glListId);
            }
            this.glListId = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.glListId, (int)4864);
            GlStateManager.func_179123_a();
            GlStateManager.func_179094_E();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            ArrayList<BlockPos> toRenderCopy = new ArrayList<BlockPos>(GuiMachineData.toRender);
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            GlStateManager.func_179118_c();
            this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.SOLID, toRenderCopy);
            GlStateManager.func_179141_d();
            this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.CUTOUT_MIPPED, toRenderCopy);
            this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.CUTOUT, toRenderCopy);
            GlStateManager.func_179103_j((int)7424);
            this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.TRANSLUCENT, toRenderCopy);
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179099_b();
            GlStateManager.func_187415_K();
        }
        if (GuiMachineData.chunk != null) {
            this.renderChunk();
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.prevMouseX = mouseX;
        this.prevMouseY = mouseY;
        if (this.rotateX == 0.0 && mouseX > 84) {
            this.rotateX = (float)RenderTickCounter.renderTicks * 45.0f / 128.0f;
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (this.prevMouseX != mouseX || this.prevMouseY != mouseY) {
            int relativeX = mouseX - this.prevMouseX;
            int relativeY = mouseY - this.prevMouseY;
            this.rotateX += (double)relativeX;
            this.rotateY -= (double)relativeY;
            this.prevMouseX = mouseX;
            this.prevMouseY = mouseY;
        }
    }

    public void renderChunk() {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179106_n();
        GlStateManager.func_179140_f();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179089_o();
        GlStateManager.func_179141_d();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179109_b((float)(this.field_146294_l / 2), (float)(this.field_146295_m / 2), (float)180.0f);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)((float)this.rotateY), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)(this.rotateX == 0.0 ? (float)RenderTickCounter.renderTicks * 45.0f / 128.0f : (float)this.rotateX), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-8.0f, (float)-8.0f, (float)-8.0f);
        float shift = (float)(GuiMachineData.machineSize - 1) * -4.0f;
        GlStateManager.func_179109_b((float)shift, (float)shift, (float)shift);
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        GlStateManager.func_179148_o((int)this.glListId);
        GlStateManager.func_179117_G();
        if (ConfigurationHandler.MachineSettings.renderTileEntitiesInGUI) {
            this.renderTileEntities(TileEntityRendererDispatcher.field_147556_a, new ArrayList<BlockPos>(GuiMachineData.toRender));
        }
        if (ConfigurationHandler.MachineSettings.renderLivingEntitiesInGUI) {
            this.renderEntities();
            GlStateManager.func_179147_l();
        }
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
    }

    public void renderLayer(BlockRendererDispatcher blockrendererdispatcher, BufferBuilder buffer, BlockRenderLayer renderLayer, List<BlockPos> toRender) {
        IBlockAccess blockAccess = ChunkUtils.getBlockAccessFromChunk(GuiMachineData.chunk);
        for (BlockPos pos : toRender) {
            IBlockState state = blockAccess.func_180495_p(pos);
            if (!state.func_177230_c().canRenderInLayer(state, renderLayer)) continue;
            try {
                state = state.func_185899_b(blockAccess, pos);
            }
            catch (Exception e) {
                Logz.debug("Could not determine actual state of block: %s", state.func_177230_c());
            }
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)renderLayer);
            try {
                blockrendererdispatcher.func_175018_a(state, pos, blockAccess, buffer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ForgeHooksClient.setRenderLayer(null);
        }
    }

    private void renderEntities() {
        ClassInheritanceMultiMap entities = GuiMachineData.chunk.func_177429_s()[2];
        for (Entity entity : entities) {
            GuiMachine.renderEntity(entity);
        }
    }

    private static void renderEntity(Entity entity) {
        GlStateManager.func_179094_E();
        double x = entity.field_70165_t % 1024.0;
        double y = entity.field_70163_u - 40.0;
        double z = entity.field_70161_v;
        RenderHelper.func_74519_b();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        try {
            Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, x, y, z, entity.field_70177_z, 1.0f, false);
        }
        catch (Exception e) {
            Logz.debug("Could not render entity '%s': %s", entity.getClass().getSimpleName(), e.getMessage());
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    private void renderTileEntities(TileEntityRendererDispatcher renderer, List<BlockPos> toRender) {
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)BlockRenderLayer.SOLID);
        IBlockAccess blockAccess = ChunkUtils.getBlockAccessFromChunk(GuiMachineData.chunk);
        for (BlockPos pos : toRender) {
            TileEntity te = blockAccess.func_175625_s(pos);
            if (te == null) continue;
            te.func_145834_a((World)GuiMachineData.proxyWorld);
            te.func_174878_a(pos);
            if (te instanceof ITickable) {
                try {
                    ((ITickable)te).func_73660_a();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179123_a();
            renderer.field_147553_e = Minecraft.func_71410_x().field_71446_o;
            renderer.preDrawBatch();
            try {
                renderer.func_147549_a(te, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f);
            }
            catch (Exception e) {
                Logz.warn("Could not render tile entity '%s': %s", te.getClass().getSimpleName(), e.getMessage());
            }
            renderer.drawBatch(0);
            GlStateManager.func_179099_b();
            GlStateManager.func_179121_F();
        }
        ForgeHooksClient.setRenderLayer(null);
    }

    public boolean func_73868_f() {
        return false;
    }
}

