/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.block;

import java.util.ArrayList;
import java.util.List;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dave.compactmachines3.CompactMachines3;
import org.dave.compactmachines3.block.BlockBase;
import org.dave.compactmachines3.block.IMetaBlockName;
import org.dave.compactmachines3.compat.ITopInfoProvider;
import org.dave.compactmachines3.init.Blockss;
import org.dave.compactmachines3.item.ItemPersonalShrinkingDevice;
import org.dave.compactmachines3.misc.CreativeTabCompactMachines3;
import org.dave.compactmachines3.network.MessageMachineContent;
import org.dave.compactmachines3.network.PackageHandler;
import org.dave.compactmachines3.reference.EnumMachineSize;
import org.dave.compactmachines3.reference.GuiIds;
import org.dave.compactmachines3.tile.TileEntityMachine;
import org.dave.compactmachines3.tile.TileEntityRedstoneTunnel;
import org.dave.compactmachines3.tile.TileEntityTunnel;
import org.dave.compactmachines3.world.ChunkLoadingMachines;
import org.dave.compactmachines3.world.WorldSavedDataMachines;
import org.dave.compactmachines3.world.data.RedstoneTunnelData;
import org.dave.compactmachines3.world.tools.DimensionTools;
import org.dave.compactmachines3.world.tools.StructureTools;
import org.dave.compactmachines3.world.tools.TeleportationTools;

public class BlockMachine
extends BlockBase
implements IMetaBlockName,
ITileEntityProvider,
ITopInfoProvider {
    public static final PropertyEnum<EnumMachineSize> SIZE = PropertyEnum.func_177709_a((String)"size", EnumMachineSize.class);

    public BlockMachine(Material material) {
        super(material);
        this.func_149711_c(8.0f);
        this.func_149752_b(20.0f);
        this.func_149647_a(CreativeTabCompactMachines3.COMPACTMACHINES3_TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SIZE, (Comparable)((Object)EnumMachineSize.TINY)));
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        Item itemBlockMachine = Item.func_150898_a((Block)Blockss.machine);
        for (EnumMachineSize size : EnumMachineSize.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)itemBlockMachine, (int)size.getMeta(), (ModelResourceLocation)new ModelResourceLocation(itemBlockMachine.getRegistryName(), "size=" + size.func_176610_l()));
        }
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return 0;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!(blockAccess.func_175625_s(pos) instanceof TileEntityMachine)) {
            return 0;
        }
        TileEntityMachine machine = (TileEntityMachine)blockAccess.func_175625_s(pos);
        if (machine.isInsideItself()) {
            return 0;
        }
        return machine.getRedstonePowerOutput(side.func_176734_d());
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos what) {
        BlockPos redstoneNeighborPos;
        RedstoneTunnelData tunnelData;
        super.func_189540_a(state, world, pos, blockIn, what);
        if (world.field_72995_K) {
            return;
        }
        if (!(world.func_175625_s(pos) instanceof TileEntityMachine)) {
            return;
        }
        EnumFacing facing = null;
        for (EnumFacing dir : EnumFacing.values()) {
            if (!pos.func_177972_a(dir).equals((Object)what)) continue;
            facing = dir;
            break;
        }
        if (facing == null) {
            return;
        }
        TileEntityMachine te = (TileEntityMachine)world.func_175625_s(pos);
        if (te.isInsideItself()) {
            return;
        }
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        BlockPos neighborPos = te.getTunnelForSide(facing);
        if (neighborPos != null && machineWorld.func_175625_s(neighborPos) instanceof TileEntityTunnel && te.lastNeighborUpdateTick != world.func_82737_E()) {
            machineWorld.func_175685_c(neighborPos, (Block)Blockss.tunnel, false);
            te.lastNeighborUpdateTick = world.func_82737_E();
        }
        if ((tunnelData = te.getRedstoneTunnelForSide(facing)) != null && !tunnelData.isOutput && (redstoneNeighborPos = tunnelData.pos) != null && machineWorld.func_175625_s(redstoneNeighborPos) instanceof TileEntityRedstoneTunnel) {
            machineWorld.func_175685_c(redstoneNeighborPos, (Block)Blockss.redstoneTunnel, false);
        }
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumMachineSize size : EnumMachineSize.values()) {
            items.add((Object)new ItemStack((Block)this, 1, size.getMeta()));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SIZE});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMachineSize)((Object)state.func_177229_b(SIZE))).getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SIZE, (Comparable)((Object)EnumMachineSize.getFromMeta(meta)));
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return ((EnumMachineSize)((Object)this.func_176203_a(stack.func_77952_i()).func_177229_b(SIZE))).func_176610_l();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMachine();
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            super.func_180663_b(world, pos, state);
            return;
        }
        if (!(world.func_175625_s(pos) instanceof TileEntityMachine)) {
            return;
        }
        TileEntityMachine te = (TileEntityMachine)world.func_175625_s(pos);
        WorldSavedDataMachines.INSTANCE.removeMachinePosition(te.coords);
        BlockMachine.spawnItemWithNBT(world, pos, (EnumMachineSize)((Object)state.func_177229_b(SIZE)), te);
        ChunkLoadingMachines.unforceChunk(te.coords);
        world.func_175713_t(pos);
        super.func_180663_b(world, pos, state);
    }

    public static void spawnItemWithNBT(World world, BlockPos pos, EnumMachineSize size, TileEntityMachine te) {
        if (world.field_72995_K) {
            return;
        }
        ItemStack stack = new ItemStack((Block)Blockss.machine, 1, size.getMeta());
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("coords", te.coords);
        if (te.hasOwner()) {
            compound.func_186854_a("owner", te.getOwner());
        }
        stack.func_77982_d(compound);
        if (te.getCustomName().length() > 0) {
            stack.func_151001_c(te.getCustomName());
        }
        EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), stack);
        entityItem.lifespan = 1200;
        entityItem.func_174867_a(10);
        float motionMultiplier = 0.02f;
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = (float)world.field_73012_v.nextGaussian() * motionMultiplier + 0.1f;
        entityItem.field_70179_y = 0.0;
        world.func_72838_d((Entity)entityItem);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!(world.func_175625_s(pos) instanceof TileEntityMachine)) {
            return;
        }
        TileEntityMachine tileEntityMachine = (TileEntityMachine)world.func_175625_s(pos);
        if (tileEntityMachine.coords != -1) {
            return;
        }
        if (stack.func_77942_o()) {
            int coords;
            if (stack.func_77978_p().func_74764_b("coords") && (coords = stack.func_77978_p().func_74762_e("coords")) != -1) {
                tileEntityMachine.coords = coords;
                if (!world.field_72995_K) {
                    WorldSavedDataMachines.INSTANCE.addMachinePosition(tileEntityMachine.coords, pos, world.field_73011_w.getDimension(), tileEntityMachine.getSize());
                    StructureTools.setBiomeForCoords(coords, world.func_180494_b(pos));
                }
            }
            if (stack.func_82837_s()) {
                tileEntityMachine.setCustomName(stack.func_82833_r());
            }
            if (stack.func_77978_p().func_74764_b("owner")) {
                tileEntityMachine.setOwner(stack.func_77978_p().func_186857_a("owner"));
            }
        }
        if (!tileEntityMachine.hasOwner() && placer instanceof EntityPlayer) {
            tileEntityMachine.setOwner((EntityPlayer)placer);
        }
        tileEntityMachine.func_70296_d();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        Item playerItem;
        if (player.func_70093_af()) {
            return false;
        }
        if (world.field_72995_K || !(player instanceof EntityPlayerMP)) {
            return true;
        }
        if (!(world.func_175625_s(pos) instanceof TileEntityMachine)) {
            return false;
        }
        TileEntityMachine machine = (TileEntityMachine)world.func_175625_s(pos);
        if (machine.isInsideItself()) {
            return true;
        }
        ItemStack playerStack = player.func_184614_ca();
        if (!playerStack.func_190926_b() && (playerItem = playerStack.func_77973_b()) instanceof ItemPersonalShrinkingDevice) {
            if (machine.coords == -1) {
                StructureTools.generateCubeForMachine(machine);
                double[] destination = new double[]{(double)(machine.coords * 1024) + 0.5 + (double)(machine.getSize().getDimension() / 2), 42.0, 0.5 + (double)(machine.getSize().getDimension() / 2)};
                WorldSavedDataMachines.INSTANCE.addSpawnPoint(machine.coords, destination);
            }
            WorldSavedDataMachines.INSTANCE.addMachinePosition(machine.coords, pos, world.field_73011_w.getDimension(), machine.getSize());
            TeleportationTools.teleportPlayerToMachine((EntityPlayerMP)player, machine);
            StructureTools.setBiomeForCoords(machine.coords, world.func_180494_b(pos));
            return true;
        }
        player.openGui((Object)CompactMachines3.instance, GuiIds.MACHINE_VIEW.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        PackageHandler.instance.sendTo((IMessage)new MessageMachineContent(machine.coords), (EntityPlayerMP)player);
        return true;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof TileEntityMachine) {
            TileEntityMachine machine = (TileEntityMachine)te;
            if (machine.isInsideItself()) {
                probeInfo.horizontal().text(TextFormatting.DARK_RED + "{*tooltip.compactmachines3.machine.stopitsoaryn*}" + TextFormatting.RESET);
                return;
            }
            String nameOrId = "";
            nameOrId = machine.coords < 0 && machine.getCustomName().length() == 0 ? "{*tooltip.compactmachines3.machine.coords.unused*}" : (machine.getCustomName().length() > 0 ? machine.getCustomName() : "#" + machine.coords);
            probeInfo.horizontal().text(TextFormatting.GREEN + "{*tooltip.compactmachines3.machine.coords*} " + TextFormatting.YELLOW + nameOrId + TextFormatting.RESET);
            if (player.func_184812_l_() && mode == ProbeMode.EXTENDED && machine.hasNewSchema()) {
                String schemaName = machine.getSchemaName();
                probeInfo.horizontal().text(TextFormatting.RED + "{*tooltip.compactmachines3.machine.schema*} " + TextFormatting.YELLOW + schemaName + TextFormatting.RESET);
            }
            String translate = "enumfacing." + data.getSideHit().func_176610_l();
            probeInfo.horizontal().item(new ItemStack(Items.field_151111_aL)).text(TextFormatting.YELLOW + "{*" + translate + "*}" + TextFormatting.RESET);
            ItemStack connectedStack = machine.getConnectedPickBlock(data.getSideHit());
            if (connectedStack != null && !connectedStack.func_190926_b()) {
                probeInfo.horizontal().item(connectedStack).itemLabel(connectedStack);
            }
        }
    }
}

