/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import teamroots.embers.EventManager;
import teamroots.embers.RegistryManager;
import teamroots.embers.block.BlockSeed;
import teamroots.embers.tileentity.ITileEntityBase;

public class TileEntitySeed
extends TileEntity
implements ITileEntityBase,
ITickable {
    int size = 0;
    int ticksExisted = 0;
    int material = -1;
    boolean[] willSpawn = new boolean[12];
    Random random = new Random();
    public boolean dirty = false;

    public TileEntitySeed() {
        this.resetSpawns();
    }

    public void resetSpawns() {
        for (int i = 0; i < 12; ++i) {
            this.willSpawn[i] = this.random.nextInt(3) == 0;
        }
    }

    public TileEntitySeed setMaterial(int material) {
        this.material = material;
        return this;
    }

    public String getSpawnString() {
        String result = "";
        for (int i = 0; i < 12; ++i) {
            result = result + (this.willSpawn[i] ? "1" : "0");
        }
        return result;
    }

    public void loadSpawnsFromString(String s) {
        for (int i = 0; i < 12; ++i) {
            this.willSpawn[i] = s.substring(i, i + 1).compareTo("1") == 0;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74778_a("spawns", this.getSpawnString());
        tag.func_74768_a("size", this.size);
        tag.func_74768_a("material", this.material);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.loadSpawnsFromString(tag.func_74779_i("spawns"));
        this.size = tag.func_74762_e("size");
        this.material = tag.func_74762_e("material");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        if (this.material == -1) {
            this.material = (Integer)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockSeed.type);
        }
        ++this.ticksExisted;
        if (this.size > 1000) {
            this.size = 0;
            for (int i = 0; i < 12; ++i) {
                if (!this.willSpawn[i] || this.func_145831_w().field_72995_K) continue;
                ItemStack nuggetStack = ItemStack.field_190927_a;
                if (this.material == 0) {
                    nuggetStack = new ItemStack(RegistryManager.nugget_iron, 1);
                }
                if (this.material == 1) {
                    nuggetStack = new ItemStack(Items.field_151074_bl, 1);
                }
                if (this.material == 2) {
                    nuggetStack = new ItemStack(RegistryManager.nugget_copper, 1);
                }
                if (this.material == 3) {
                    nuggetStack = new ItemStack(RegistryManager.nugget_lead, 1);
                }
                if (this.material == 4) {
                    nuggetStack = new ItemStack(RegistryManager.nugget_silver, 1);
                }
                float offX = 0.4f * (float)Math.sin(Math.toRadians((double)i * 30.0));
                float offZ = 0.4f * (float)Math.cos(Math.toRadians((double)i * 30.0));
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5 + (double)offX, (double)((float)this.func_174877_v().func_177956_o() + 0.5f), (double)this.func_174877_v().func_177952_p() + 0.5 + (double)offZ, nuggetStack));
            }
            this.resetSpawns();
            this.func_70296_d();
        }
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }
}

