/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import teamroots.embers.EventManager;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.power.EmberCapabilityProvider;
import teamroots.embers.power.IEmberCapability;
import teamroots.embers.recipe.ItemMeltingOreRecipe;
import teamroots.embers.recipe.ItemMeltingRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityFurnaceTop;

public class TileEntityFurnaceBottom
extends TileEntity
implements ITileEntityBase,
ITickable {
    public IEmberCapability capability = new DefaultEmberCapability();
    Random random = new Random();
    int progress = -1;
    public boolean dirty = false;

    public TileEntityFurnaceBottom() {
        this.capability.setEmberCapacity(8000.0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        tag.func_74768_a("progress", this.progress);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmberCapabilityProvider.emberCapability) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmberCapabilityProvider.emberCapability) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_73660_a() {
        ItemMeltingOreRecipe oreRecipe;
        ItemMeltingRecipe recipe;
        TileEntityFurnaceTop furnace = (TileEntityFurnaceTop)this.func_145831_w().func_175625_s(this.func_174877_v().func_177984_a());
        if (furnace == null) return;
        if (furnace.inventory.getStackInSlot(0).func_190926_b()) {
            if (this.progress == -1) return;
            this.progress = -1;
            this.func_70296_d();
            return;
        }
        if (this.progress == -1) {
            this.progress = 200;
            this.func_70296_d();
            return;
        }
        if (!(this.capability.getEmber() >= 1.0)) return;
        this.capability.removeAmount(1.0, true);
        if (this.field_145850_b.field_72995_K) {
            if (this.random.nextInt(20) == 0) {
                ParticleUtil.spawnParticleSpark(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 1.25f, (float)this.func_174877_v().func_177952_p() + 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * this.random.nextFloat(), 0.125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, this.random.nextFloat() * 0.75f + 0.45f, 80);
            }
            if (this.random.nextInt(10) == 0) {
                for (int i = 0; i < 12; ++i) {
                    ParticleUtil.spawnParticleSmoke(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 1.25f, (float)this.func_174877_v().func_177952_p() + 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), 0.0f, 0.03125f + 0.03125f * this.random.nextFloat(), 0.0f, 64.0f, 64.0f, 64.0f, 0.125f, 5.0f + 3.0f * this.random.nextFloat(), 80);
                }
            }
        }
        --this.progress;
        this.func_70296_d();
        if (this.progress != 0) return;
        ItemStack stack = furnace.inventory.getStackInSlot(0);
        ItemStack recipeStack = new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
        if (stack.func_77942_o()) {
            recipeStack.func_77982_d(stack.func_77978_p());
        }
        if ((recipe = RecipeRegistry.getMeltingRecipe(recipeStack)) != null && !this.func_145831_w().field_72995_K) {
            TileEntityFurnaceTop t = (TileEntityFurnaceTop)this.func_145831_w().func_175625_s(this.func_174877_v().func_177984_a());
            if (t.getFluid() != null) {
                if (recipe.getFluid().getFluid().getName().compareTo(t.getFluid().getName()) == 0 && t.getAmount() < t.getCapacity()) {
                    ((IFluidHandler)t.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).fill(recipe.getFluid(), true);
                    t.func_70296_d();
                    if (!this.func_145831_w().field_72995_K) {
                        furnace.inventory.getStackInSlot(0).func_190918_g(1);
                        if (furnace.inventory.getStackInSlot(0).func_190916_E() <= 0) {
                            furnace.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                        }
                    }
                    this.func_70296_d();
                    return;
                }
            } else {
                ((IFluidHandler)t.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).fill(recipe.getFluid(), true);
                t.func_70296_d();
                if (!this.func_145831_w().field_72995_K) {
                    furnace.inventory.getStackInSlot(0).func_190918_g(1);
                    if (furnace.inventory.getStackInSlot(0).func_190916_E() <= 0) {
                        furnace.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                    }
                }
                this.func_70296_d();
                return;
            }
        }
        if ((oreRecipe = RecipeRegistry.getMeltingOreRecipe(recipeStack)) == null) return;
        if (this.func_145831_w().field_72995_K) return;
        TileEntityFurnaceTop t = (TileEntityFurnaceTop)this.func_145831_w().func_175625_s(this.func_174877_v().func_177984_a());
        if (t.getFluid() != null) {
            if (oreRecipe.getFluid().getFluid().getName().compareTo(t.getFluid().getName()) != 0) return;
            if (t.getAmount() >= t.getCapacity()) return;
            ((IFluidHandler)t.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).fill(oreRecipe.getFluid(), true);
            t.func_70296_d();
            if (!this.func_145831_w().field_72995_K) {
                furnace.inventory.getStackInSlot(0).func_190918_g(1);
                if (furnace.inventory.getStackInSlot(0).func_190916_E() <= 0) {
                    furnace.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                }
            }
            this.func_70296_d();
            return;
        }
        ((IFluidHandler)t.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).fill(oreRecipe.getFluid(), true);
        t.func_70296_d();
        furnace.inventory.getStackInSlot(0).func_190918_g(1);
        if (furnace.inventory.getStackInSlot(0).func_190916_E() <= 0) {
            furnace.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        }
        this.func_70296_d();
    }
}

