/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.EventManager;
import teamroots.embers.RegistryManager;
import teamroots.embers.block.BlockBeamCannon;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageBeamCannonFX;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.power.EmberCapabilityProvider;
import teamroots.embers.power.IEmberCapability;
import teamroots.embers.power.IEmberPacketReceiver;
import teamroots.embers.tileentity.ITargetable;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityAlchemyTablet;

public class TileEntityBeamCannon
extends TileEntity
implements ITileEntityBase,
ITickable,
ITargetable {
    public IEmberCapability capability = new DefaultEmberCapability();
    public BlockPos target = null;
    public long ticksExisted = 0L;
    public Random random = new Random();
    int offset = this.random.nextInt(40);
    public boolean dirty = false;

    public TileEntityBeamCannon() {
        this.onLoad();
        this.capability.setEmberCapacity(2000.0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.target != null) {
            tag.func_74768_a("targetX", this.target.func_177958_n());
            tag.func_74768_a("targetY", this.target.func_177956_o());
            tag.func_74768_a("targetZ", this.target.func_177952_p());
        }
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("targetX")) {
            this.target = new BlockPos(tag.func_74762_e("targetX"), tag.func_74762_e("targetY"), tag.func_74762_e("targetZ"));
        }
        this.capability.readFromNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }

    public void func_73660_a() {
        if (this.target == null && this.ticksExisted == 0L) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.target = this.func_174877_v().func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockBeamCannon.facing));
        }
        ++this.ticksExisted;
        if (this.capability.getEmber() >= 400.0 && this.ticksExisted % 200L == 0L && this.func_145831_w().func_175687_A(this.func_174877_v()) != 0) {
            Vec3d ray = new Vec3d((double)(this.target.func_177958_n() - this.func_174877_v().func_177958_n()), (double)(this.target.func_177956_o() - this.func_174877_v().func_177956_o()), (double)(this.target.func_177952_p() - this.func_174877_v().func_177952_p())).func_72432_b();
            if (!this.func_145831_w().field_72995_K) {
                double posX = (double)this.func_174877_v().func_177958_n() + 0.5;
                double posY = (double)this.func_174877_v().func_177956_o() + 0.5;
                double posZ = (double)this.func_174877_v().func_177952_p() + 0.5;
                boolean doContinue = true;
                for (int i = 0; i < 640 && doContinue; ++i) {
                    IBlockState state = this.func_145831_w().func_180495_p(new BlockPos(posX += ray.field_72450_a * 0.1, posY += ray.field_72448_b * 0.1, posZ += ray.field_72449_c * 0.1));
                    TileEntity tile = this.func_145831_w().func_175625_s(new BlockPos(posX, posY, posZ));
                    if (tile instanceof TileEntityAlchemyTablet) {
                        ((TileEntityAlchemyTablet)tile).sparkProgress();
                        doContinue = false;
                    }
                    if (tile instanceof IEmberPacketReceiver) {
                        if (tile.hasCapability(EmberCapabilityProvider.emberCapability, null)) {
                            ((IEmberCapability)tile.getCapability(EmberCapabilityProvider.emberCapability, null)).addAmount(this.capability.getEmber(), true);
                            tile.func_70296_d();
                        }
                        doContinue = false;
                    }
                    if (state.func_185917_h() && state.func_185914_p()) {
                        doContinue = false;
                    }
                    List rawEntities = this.func_145831_w().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(posX - 0.85, posY - 0.85, posZ - 0.85, posX + 0.85, posY + 0.85, posZ + 0.85));
                    for (int j = 0; j < rawEntities.size(); ++j) {
                        ((EntityLivingBase)rawEntities.get(j)).func_70097_a(RegistryManager.damage_ember, 25.0f);
                    }
                }
                this.capability.setEmber(0.0);
                this.func_70296_d();
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageBeamCannonFX(this));
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmberCapabilityProvider.emberCapability) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmberCapabilityProvider.emberCapability) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void setTarget(BlockPos pos) {
        this.target = pos;
        this.func_70296_d();
    }
}

