/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import teamroots.embers.Embers;
import teamroots.embers.RegistryManager;
import teamroots.embers.block.IDial;
import teamroots.embers.gui.GuiCodex;
import teamroots.embers.item.IEmberChargedTool;
import teamroots.embers.item.ItemAshenCloak;
import teamroots.embers.item.ItemEmberGauge;
import teamroots.embers.item.ItemGrandhammer;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberBurstFX;
import teamroots.embers.network.message.MessageEmberGenOffset;
import teamroots.embers.network.message.MessageTEUpdate;
import teamroots.embers.network.message.MessageTyrfingBurstFX;
import teamroots.embers.proxy.ClientProxy;
import teamroots.embers.research.ResearchBase;
import teamroots.embers.tileentity.ITileEntitySpecialRendererLater;
import teamroots.embers.util.EmberGenUtil;
import teamroots.embers.util.FluidTextureUtil;
import teamroots.embers.util.ItemModUtil;
import teamroots.embers.util.Misc;
import teamroots.embers.util.RenderUtil;
import teamroots.embers.world.EmberWorldData;

public class EventManager {
    double gaugeAngle = 0.0;
    public static boolean hasRenderedParticles = false;
    Random random = new Random();
    public static float emberEyeView = 0.0f;
    public static ResearchBase lastResearch = null;
    public static float frameTime = 0.0f;
    public static float frameCounter = 0.0f;
    public static long prevTime = 0L;
    public static EnumHand lastHand = EnumHand.MAIN_HAND;
    public static float starlightRed = 255.0f;
    public static float starlightGreen = 32.0f;
    public static float starlightBlue = 255.0f;
    public static float tickCounter = 0.0f;
    public static double currentEmber = 0.0;
    public static boolean allowPlayerRenderEvent = true;
    public static int ticks = 0;
    public static float prevCooledStrength = 0.0f;
    public static boolean acceptUpdates = true;
    public static Map<BlockPos, TileEntity> toUpdate = new HashMap<BlockPos, TileEntity>();
    public static Map<BlockPos, TileEntity> overflow = new HashMap<BlockPos, TileEntity>();
    static EntityPlayer clientPlayer = null;

    public static void markTEForUpdate(BlockPos pos, TileEntity tile) {
        if (!tile.func_145831_w().field_72995_K && acceptUpdates) {
            if (!toUpdate.containsKey(pos)) {
                toUpdate.put(pos, tile);
            } else {
                toUpdate.replace(pos, tile);
            }
        } else if (!tile.func_145831_w().field_72995_K) {
            if (!overflow.containsKey(pos)) {
                overflow.put(pos, tile);
            } else {
                overflow.replace(pos, tile);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        FluidTextureUtil.initTextures(event.getMap());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent event) {
        ResourceLocation particleGlow = new ResourceLocation("embers:entity/particle_mote");
        event.getMap().func_174942_a(particleGlow);
        ResourceLocation particleSparkle = new ResourceLocation("embers:entity/particle_star");
        event.getMap().func_174942_a(particleSparkle);
        ResourceLocation particleSmoke = new ResourceLocation("embers:entity/particle_smoke");
        event.getMap().func_174942_a(particleSmoke);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.WorldTickEvent event) {
        if (event.world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            if (Misc.random.nextInt(400) == 0) {
                ++EmberGenUtil.offX;
                EmberWorldData.get(event.world).func_76185_a();
            }
            if (Misc.random.nextInt(400) == 0) {
                ++EmberGenUtil.offZ;
                EmberWorldData.get(event.world).func_76185_a();
            }
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberGenOffset(EmberGenUtil.offX, EmberGenUtil.offZ));
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingHurtEvent event) {
        EntityPlayer damager;
        ItemStack s2;
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            String source = event.getSource().func_76355_l();
            if (source.compareTo("mob") != 0 && source.compareTo("generic") != 0 && source.compareTo("player") != 0 && source.compareTo("arrow") != 0) {
                if (player.func_184614_ca() != ItemStack.field_190927_a && player.func_184614_ca().func_77973_b() == RegistryManager.inflictor_gem && player.func_184614_ca().func_77942_o()) {
                    player.func_184614_ca().func_77964_b(1);
                    player.func_184614_ca().func_77978_p().func_74778_a("type", event.getSource().func_76355_l());
                }
                if (player.func_184592_cb() != ItemStack.field_190927_a && player.func_184592_cb().func_77973_b() == RegistryManager.inflictor_gem && player.func_184592_cb().func_77942_o()) {
                    player.func_184592_cb().func_77964_b(1);
                    player.func_184592_cb().func_77978_p().func_74778_a("type", event.getSource().func_76355_l());
                }
            }
        }
        if (event.getEntityLiving().func_184582_a(EntityEquipmentSlot.HEAD) != ItemStack.field_190927_a && event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST) != ItemStack.field_190927_a && event.getEntityLiving().func_184582_a(EntityEquipmentSlot.LEGS) != ItemStack.field_190927_a && event.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET) != ItemStack.field_190927_a && event.getEntityLiving().func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof ItemAshenCloak && event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemAshenCloak && event.getEntityLiving().func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() instanceof ItemAshenCloak && event.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemAshenCloak) {
            float mult = Math.max(0.0f, 1.0f - ItemAshenCloak.getDamageMultiplier(event.getSource(), event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST)));
            if (mult == 0.0f) {
                event.setCanceled(true);
            }
            event.setAmount(event.getAmount() * mult);
        }
        for (ItemStack s2 : event.getEntityLiving().func_184209_aF()) {
            if (!(s2.func_77973_b() instanceof ItemArmor) || !ItemModUtil.hasHeat(s2)) continue;
            ItemModUtil.addHeat(s2, 5.0f);
        }
        if (event.getSource().func_76346_g() instanceof EntityPlayer && !(s2 = (damager = (EntityPlayer)event.getSource().func_76346_g()).func_184614_ca()).func_190926_b() && ItemModUtil.hasHeat(s2)) {
            ItemModUtil.addHeat(s2, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGameOverlayRender(RenderGameOverlayEvent.Post e) {
        IBlockState state;
        World world;
        if (e.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            frameCounter += 1.0f;
            frameTime = (float)(System.nanoTime() - prevTime) / 1.0E9f;
            prevTime = System.nanoTime();
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean showBar = false;
        int w = e.getResolution().func_78326_a();
        int h = e.getResolution().func_78328_b();
        int x = w / 2;
        int y = h / 2;
        if (player.func_184614_ca() != ItemStack.field_190927_a && player.func_184614_ca().func_77973_b() instanceof ItemEmberGauge) {
            showBar = true;
        }
        if (player.func_184592_cb() != ItemStack.field_190927_a && player.func_184592_cb().func_77973_b() instanceof ItemEmberGauge) {
            showBar = true;
        }
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder b = tess.func_178180_c();
        if (showBar) {
            world = player.func_130014_f_();
            if (e.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
                GlStateManager.func_179097_i();
                GlStateManager.func_179129_p();
                GlStateManager.func_179094_E();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("embers:textures/gui/ember_meter_overlay.png"));
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean offsetX = false;
                b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                RenderUtil.drawQuadGui(b, 0.0, x - 16, y - 4, x + 16, y - 4, x + 16, y - 36, x - 16, y - 36, 0.0, 0.0, 1.0, 1.0);
                tess.func_78381_a();
                double angle = 195.0;
                EmberWorldData data = EmberWorldData.get(world);
                if (player != null) {
                    double ratio = EmberGenUtil.getEmberDensity(world.func_72905_C(), player.func_180425_c().func_177958_n(), player.func_180425_c().func_177952_p());
                    this.gaugeAngle = this.gaugeAngle == 0.0 ? 165.0 + 210.0 * ratio : this.gaugeAngle * 0.99 + 0.01 * (165.0 + 210.0 * ratio);
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("embers:textures/gui/ember_meter_pointer.png"));
                GlStateManager.func_179109_b((float)x, (float)(y - 20), (float)0.0f);
                GlStateManager.func_179114_b((float)((float)this.gaugeAngle), (float)0.0f, (float)0.0f, (float)1.0f);
                b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                RenderUtil.drawQuadGui(b, 0.0, -2.5, 13.5, 13.5, 13.5, 13.5, -2.5, -2.5, -2.5, 0.0, 0.0, 1.0, 1.0);
                tess.func_78381_a();
                GlStateManager.func_179121_F();
                GlStateManager.func_179089_o();
                GlStateManager.func_179126_j();
            }
        }
        world = player.func_130014_f_();
        RayTraceResult result = player.func_174822_a(6.0, e.getPartialTicks());
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && (state = world.func_180495_p(result.func_178782_a())).func_177230_c() instanceof IDial) {
            List<String> text = ((IDial)state.func_177230_c()).getDisplayInfo(world, result.func_178782_a(), state);
            for (int i = 0; i < text.size(); ++i) {
                Minecraft.func_71410_x().field_71466_p.func_175063_a(text.get(i), (float)(x - Minecraft.func_71410_x().field_71466_p.func_78256_a(text.get(i)) / 2), (float)(y + 40 + 11 * i), 0xFFFFFF);
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("minecraft:textures/gui/icons.png"));
        GlStateManager.func_179126_j();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.START) {
            ++ticks;
            ClientProxy.particleRenderer.updateParticles();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                IBlockState state;
                World world = player.func_130014_f_();
                RayTraceResult result = player.func_174822_a(6.0, Minecraft.func_71410_x().func_184121_ak());
                if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && (state = world.func_180495_p(result.func_178782_a())).func_177230_c() instanceof IDial) {
                    ((IDial)state.func_177230_c()).updateTEData(world, state, result.func_178782_a());
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRender(RenderPlayerEvent.Pre event) {
        if (event.getEntityPlayer() != null && (Minecraft.func_71410_x().field_71415_G || event.getEntityPlayer().func_110124_au().compareTo(Minecraft.func_71410_x().field_71439_g.func_110124_au()) != 0)) {
            event.setCanceled(!allowPlayerRenderEvent);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityDamaged(LivingHurtEvent event) {
        if (event.getSource().field_76373_n == RegistryManager.damage_ember.field_76373_n && event.getEntityLiving().func_70644_a(Potion.func_180142_b((String)"fire_resistance"))) {
            event.setAmount(event.getAmount() * 0.5f);
        }
        if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityPlayer) {
            if (((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca().func_77973_b() == RegistryManager.tyrfing) {
                if (!event.getEntity().field_70170_p.field_72995_K) {
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTyrfingBurstFX(event.getEntity().field_70165_t, event.getEntity().field_70163_u + (double)(event.getEntity().field_70131_O / 2.0f), event.getEntity().field_70161_v));
                }
                EntityPlayer p = (EntityPlayer)event.getSource().func_76346_g();
                event.setAmount(event.getAmount() / 4.0f * (4.0f + (float)event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e() * 1.0f));
            }
            if (((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca() != ItemStack.field_190927_a && ((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca().func_77973_b() instanceof IEmberChargedTool) {
                if (((IEmberChargedTool)((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca().func_77973_b()).hasEmber(((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca()) || ((EntityPlayer)event.getSource().func_76346_g()).field_71075_bZ.field_75098_d) {
                    event.getEntityLiving().func_70015_d(1);
                    if (!event.getEntityLiving().func_130014_f_().field_72995_K) {
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberBurstFX(event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u + (double)event.getEntityLiving().func_70047_e() / 1.5, event.getEntityLiving().field_70161_v));
                        ((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca().func_77978_p().func_74757_a("didUse", true);
                    }
                } else {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null && event.getPlayer().func_184614_ca() != ItemStack.field_190927_a) {
            ItemStack s = event.getPlayer().func_184614_ca();
            if (!s.func_190926_b() && event.getState().func_185887_b(event.getWorld(), event.getPos()) > 0.0f && ItemModUtil.hasHeat(s)) {
                ItemModUtil.addHeat(s, 1.0f);
            }
            if (event.getPlayer().func_184614_ca().func_77973_b() instanceof ItemGrandhammer) {
                event.setCanceled(true);
                event.getWorld().func_175698_g(event.getPos());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (ItemModUtil.hasHeat(event.getItemStack())) {
            event.getToolTip().add("");
            if (ItemModUtil.hasHeat(event.getItemStack()) && ItemModUtil.getLevel(event.getItemStack()) > 0) {
                event.getToolTip().add("");
            }
            event.getToolTip().add("                        ");
            if (ItemModUtil.hasHeat(event.getItemStack()) && event.getItemStack().func_77978_p().func_74775_l("embers:heat_tag").func_150295_c("modifiers", 10).func_74745_c() > 1) {
                event.getToolTip().add(TextFormatting.GRAY + I18n.func_135052_a((String)"embers.tooltip.modifiers", (Object[])new Object[0]));
                int c = event.getItemStack().func_77978_p().func_74775_l("embers:heat_tag").func_150295_c("modifiers", 10).func_74745_c();
                for (int i = 0; i < c - 1; ++i) {
                    event.getToolTip().add("");
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTooltipRender(RenderTooltipEvent.PostText event) {
        if (event.getStack() != null && ItemModUtil.hasHeat(event.getStack())) {
            for (int i = 0; i < event.getLines().size(); ++i) {
                if (((String)event.getLines().get(i)).compareTo(TextFormatting.GRAY + "" + TextFormatting.GRAY + I18n.func_135052_a((String)"embers.tooltip.modifiers", (Object[])new Object[0])) == 0) {
                    ArrayList<String> modifiers = new ArrayList<String>();
                    NBTTagList l = event.getStack().func_77978_p().func_74775_l("embers:heat_tag").func_150295_c("modifiers", 10);
                    for (int j = 0; j < l.func_74745_c(); ++j) {
                        if (l.func_150305_b(j).func_74779_i("name").compareTo(ItemModUtil.modifierRegistry.get((Object)RegistryManager.ancient_motive_core).name) == 0) continue;
                        modifiers.add(l.func_150305_b(j).func_74779_i("name"));
                    }
                    GlStateManager.func_179097_i();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    if (ItemModUtil.getLevel(event.getStack()) > 0) {
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179141_d();
                        int func = GL11.glGetInteger((int)3009);
                        float ref = GL11.glGetFloat((int)3010);
                        GlStateManager.func_179092_a((int)519, (float)0.0f);
                        for (int j = 0; j < modifiers.size(); ++j) {
                            GuiCodex.drawTextGlowingAura(event.getFontRenderer(), I18n.func_135052_a((String)("embers.tooltip.modifier." + (String)modifiers.get(j)), (Object[])new Object[0]) + " " + I18n.func_135052_a((String)("embers.tooltip.num" + ItemModUtil.getModifierLevel(event.getStack(), (String)modifiers.get(j))), (Object[])new Object[0]), event.getX(), event.getY() + (event.getFontRenderer().field_78288_b + 1) * (i + j + 1) + 2);
                        }
                        GlStateManager.func_179092_a((int)func, (float)ref);
                        GlStateManager.func_179118_c();
                        GlStateManager.func_179084_k();
                    }
                }
                if (((String)event.getLines().get(i)).compareTo(TextFormatting.GRAY + "                        ") != 0) continue;
                GlStateManager.func_179097_i();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                if (ItemModUtil.getLevel(event.getStack()) > 0) {
                    event.getFontRenderer().func_175063_a(TextFormatting.GRAY + I18n.func_135052_a((String)"embers.tooltip.heat_level", (Object[])new Object[0]), (float)event.getX(), (float)(event.getY() + (event.getFontRenderer().field_78288_b + 1) * (i - 1) + 2), -1);
                    int level_x = event.getFontRenderer().func_78256_a(I18n.func_135052_a((String)"embers.tooltip.heat_level", (Object[])new Object[0])) + 2;
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179141_d();
                    int func = GL11.glGetInteger((int)3009);
                    float ref = GL11.glGetFloat((int)3010);
                    GlStateManager.func_179092_a((int)519, (float)0.0f);
                    GuiCodex.drawTextGlowingAura(event.getFontRenderer(), "" + ItemModUtil.getLevel(event.getStack()), event.getX() + level_x, event.getY() + (event.getFontRenderer().field_78288_b + 1) * (i - 1) + 2);
                    GlStateManager.func_179092_a((int)func, (float)ref);
                    GlStateManager.func_179118_c();
                    GlStateManager.func_179084_k();
                }
                event.getFontRenderer().func_175063_a(TextFormatting.GRAY + I18n.func_135052_a((String)"embers.tooltip.heat_amount", (Object[])new Object[0]), (float)event.getX(), (float)(event.getY() + (event.getFontRenderer().field_78288_b + 1) * i + 2), -1);
                double x = (double)event.getFontRenderer().func_78256_a(I18n.func_135052_a((String)"embers.tooltip.heat_amount", (Object[])new Object[0])) + 1.0;
                double w = event.getFontRenderer().func_78256_a("                        ");
                Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("embers:textures/gui/heat_bar.png"));
                Tessellator tess = Tessellator.func_178181_a();
                BufferBuilder b = tess.func_178180_c();
                GlStateManager.func_179090_x();
                GlStateManager.func_179141_d();
                int func = GL11.glGetInteger((int)3009);
                float ref = GL11.glGetFloat((int)3010);
                GlStateManager.func_179092_a((int)519, (float)0.0f);
                GlStateManager.func_179147_l();
                double baseX = event.getX();
                double baseY = event.getY() + (event.getFontRenderer().field_78288_b + 1) * i + 2;
                GlStateManager.func_179103_j((int)7425);
                b.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                double x1 = baseX + x + 4.0;
                double x2 = baseX + w - 3.0;
                x2 = x1 + (x2 - x1) * (double)(ItemModUtil.getHeat(event.getStack()) / ItemModUtil.getMaxHeat(event.getStack()));
                for (double j = 0.0; j < 10.0; j += 1.0) {
                    double coeff = j / 10.0;
                    double coeff2 = (j + 1.0) / 10.0;
                    for (double k = 0.0; k < 4.0; k += 0.5) {
                        float thick = (float)(k / 4.0);
                        RenderUtil.drawColorRectBatched(b, x1 * (1.0 - coeff) + x2 * coeff, baseY + k, 0.0, (x2 - x1) / 10.0, 8.0 - 2.0 * k, 1.0f, 0.25f, 0.0625f, Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff) + x2 * coeff)), 4 * (int)(baseY + k))), 1.0f, 0.25f, 0.0625f, Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff2) + x2 * coeff2)), 4 * (int)(baseY + k))), 1.0f, 0.25f, 0.0625f, Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff2) + x2 * coeff2)), 4 * (int)(baseY + (8.0 - k)))), 1.0f, 0.25f, 0.0625f, Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff) + x2 * coeff)), 4 * (int)(baseY + (8.0 - k)))));
                    }
                }
                x1 = baseX + x + 4.0;
                x2 = baseX + w - 3.0;
                double point = x1 + (x2 - x1) * (double)(ItemModUtil.getHeat(event.getStack()) / ItemModUtil.getMaxHeat(event.getStack()));
                for (double k = 0.0; k < 4.0; k += 0.5) {
                    float thick = (float)(k / 4.0);
                    RenderUtil.drawColorRectBatched(b, point, baseY + k, 0.0, Math.min(x2 - point, (x2 - x1) / 10.0), 8.0 - 2.0 * k, 1.0f, 0.25f, 0.0625f, 1.0f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * point), 4 * (int)(baseY + k))), 0.25f, 0.0625f, 0.015625f, 0.0f, 0.25f, 0.0625f, 0.015625f, 0.0f, 1.0f, 0.25f, 0.0625f, 1.0f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * point), 4 * (int)(baseY + (8.0 - k)))));
                }
                tess.func_78381_a();
                b.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                x1 = baseX + x + 4.0;
                x2 = baseX + w - 3.0;
                x1 = x2 - (x2 - x1) * (double)(1.0f - ItemModUtil.getHeat(event.getStack()) / ItemModUtil.getMaxHeat(event.getStack()));
                for (double j = 0.0; j < 10.0; j += 1.0) {
                    double coeff = j / 10.0;
                    double coeff2 = (j + 1.0) / 10.0;
                    for (double k = 0.0; k < 4.0; k += 0.5) {
                        float thick = (float)(k / 4.0);
                        RenderUtil.drawColorRectBatched(b, x1 * (1.0 - coeff) + x2 * coeff, baseY + k, 0.0, (x2 - x1) / 10.0, 8.0 - 2.0 * k, 0.25f, 0.0625f, 0.015625f, 0.75f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff) + x2 * coeff)), 4 * (int)(baseY + k))), 0.25f, 0.0625f, 0.015625f, 0.75f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff2) + x2 * coeff2)), 4 * (int)(baseY + k))), 0.25f, 0.0625f, 0.015625f, 0.75f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff2) + x2 * coeff2)), 4 * (int)(baseY + (8.0 - k)))), 0.25f, 0.0625f, 0.015625f, 0.75f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff) + x2 * coeff)), 4 * (int)(baseY + (8.0 - k)))));
                    }
                }
                tess.func_78381_a();
                GlStateManager.func_179103_j((int)7424);
                GlStateManager.func_179098_w();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179092_a((int)func, (float)ref);
                b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                RenderUtil.drawTexturedModalRectBatched(b, (int)(baseX + x + 1.0), (int)baseY - 1, 0.0, 0.0, 0.0, 0.5, 0.625, 8, 10);
                RenderUtil.drawTexturedModalRectBatched(b, (int)(baseX + w - 8.0), (int)baseY - 1, 0.0, 0.5, 0.0, 1.0, 0.625, 8, 10);
                tess.func_78381_a();
                GlStateManager.func_179084_k();
                GlStateManager.func_179118_c();
                GlStateManager.func_179126_j();
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderAfterWorld(RenderWorldLastEvent event) {
        tickCounter += 1.0f;
        if (Embers.proxy instanceof ClientProxy) {
            GlStateManager.func_179094_E();
            ClientProxy.particleRenderer.renderParticles(clientPlayer, event.getPartialTicks());
            GlStateManager.func_179121_F();
        }
        List list = Minecraft.func_71410_x().field_71441_e.field_147482_g;
        GlStateManager.func_179094_E();
        for (int i = 0; i < list.size(); ++i) {
            TileEntitySpecialRenderer render = TileEntityRendererDispatcher.field_147556_a.func_147547_b((TileEntity)list.get(i));
            if (!(render instanceof ITileEntitySpecialRendererLater)) continue;
            double x = Minecraft.func_71410_x().field_71439_g.field_70142_S + (double)Minecraft.func_71410_x().func_184121_ak() * (Minecraft.func_71410_x().field_71439_g.field_70165_t - Minecraft.func_71410_x().field_71439_g.field_70142_S);
            double y = Minecraft.func_71410_x().field_71439_g.field_70137_T + (double)Minecraft.func_71410_x().func_184121_ak() * (Minecraft.func_71410_x().field_71439_g.field_70163_u - Minecraft.func_71410_x().field_71439_g.field_70137_T);
            double z = Minecraft.func_71410_x().field_71439_g.field_70136_U + (double)Minecraft.func_71410_x().func_184121_ak() * (Minecraft.func_71410_x().field_71439_g.field_70161_v - Minecraft.func_71410_x().field_71439_g.field_70136_U);
            ((ITileEntitySpecialRendererLater)render).renderLater((TileEntity)list.get(i), (double)((TileEntity)list.get(i)).func_174877_v().func_177958_n() - x, (double)((TileEntity)list.get(i)).func_174877_v().func_177956_o() - y, (double)((TileEntity)list.get(i)).func_174877_v().func_177952_p() - z, Minecraft.func_71410_x().func_184121_ak());
        }
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void onBlockBreak(PlayerEvent.BreakSpeed event) {
        event.getOriginalSpeed();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawScaledCustomSizeModalRect(double x, double y, float u, float v, float uWidth, float vHeight, double width, double height, float tileWidth, float tileHeight) {
        float f = 1.0f / tileWidth;
        float f1 = 1.0f / tileHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder BufferBuilder2 = tessellator.func_178180_c();
        BufferBuilder2.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        BufferBuilder2.func_181662_b(x, y + height, 0.0).func_187315_a((double)(u * f), (double)((v + vHeight) * f1)).func_181675_d();
        BufferBuilder2.func_181662_b(x + width, y + height, 0.0).func_187315_a((double)((u + uWidth) * f), (double)((v + vHeight) * f1)).func_181675_d();
        BufferBuilder2.func_181662_b(x + width, y, 0.0).func_187315_a((double)((u + uWidth) * f), (double)(v * f1)).func_181675_d();
        BufferBuilder2.func_181662_b(x, y, 0.0).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.phase == TickEvent.Phase.END) {
            NBTTagList list = new NBTTagList();
            acceptUpdates = false;
            TileEntity[] updateArray = toUpdate.values().toArray(new TileEntity[0]);
            acceptUpdates = true;
            for (Map.Entry<BlockPos, TileEntity> e : overflow.entrySet()) {
                toUpdate.put(e.getKey(), e.getValue());
            }
            overflow.clear();
            for (int i = 0; i < updateArray.length; ++i) {
                TileEntity t = updateArray[i];
                list.func_74742_a((NBTBase)t.func_189517_E_());
            }
            if (!list.func_82582_d()) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74782_a("data", (NBTBase)list);
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(tag));
            }
            toUpdate.clear();
        }
    }
}

