/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.m_multiblocks.m_teg.tile;

import com.valkyrieofnight.et.base.tile.ETControllerEProducer;
import com.valkyrieofnight.vlib.api.multiblock.structure.IMultiBlockStructure;
import com.valkyrieofnight.vlib.api.multiblock.structure.IStructureComponent;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public abstract class TileThermalGenBase
extends ETControllerEProducer {
    public static int BASE_DURATION = 10;

    public static IMultiBlockStructure createCustomPanel(IMultiBlockStructure structure, IStructureComponent structureBlock, IStructureComponent cellBlock, int panelTier) {
        int panelHalf = panelTier + 1;
        for (int x = -panelHalf; x < panelHalf + 1; ++x) {
            for (int z = -panelHalf; z < panelHalf + 1; ++z) {
                if (x == -panelHalf || z == -panelHalf || x == panelHalf || z == panelHalf) {
                    structure.addRequiredBlock(structureBlock, x, -1, z);
                    continue;
                }
                structure.addRequiredBlock(cellBlock, x, -1, z);
            }
        }
        return structure;
    }

    public TileThermalGenBase(int maxExtract) {
        super(maxExtract);
    }

    protected int getRFforCell(BlockPos cell, int degreesPerRF) {
        int rf = 0;
        int[] heat = new int[]{this.getHeatFromSide(cell, EnumFacing.NORTH), this.getHeatFromSide(cell, EnumFacing.SOUTH), this.getHeatFromSide(cell, EnumFacing.EAST), this.getHeatFromSide(cell, EnumFacing.WEST)};
        int coldest = 0;
        for (int i = 0; i < heat.length; ++i) {
            if (heat[i] >= heat[coldest]) continue;
            coldest = i;
        }
        return rf;
    }

    protected int getHeatFromSide(BlockPos cell, EnumFacing dir) {
        Fluid fl;
        IBlockState bs = this.func_145831_w().func_180495_p(cell.func_177972_a(dir));
        if (bs != null && (fl = FluidRegistry.lookupFluidForBlock((Block)bs.func_177230_c())) != null) {
            return fl.getTemperature();
        }
        return 0;
    }

    public void onProcessStart() {
    }

    public void onProcessTick(int processedTicks) {
    }

    public void onProcessComplete() {
    }

    public void onIdleTick() {
    }

    public EnumFacing[] validEnergyDirections() {
        return null;
    }

    public int getBaseDuration() {
        return BASE_DURATION;
    }

    public int getMinDuration() {
        return this.getBaseDuration();
    }

    public int getMaxDuration() {
        return this.getBaseDuration();
    }

    public int modifyDuration(int unmodifiedDuration) {
        return 0;
    }

    protected abstract int getScanRate();
}

