/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.m_multiblocks.m_nanobot.tile;

import com.valkyrieofnight.et.base.tile.ETControllerEConsumer;
import com.valkyrieofnight.et.m_multiblocks.m_nanobot.applicator.IAttributeApplicator;
import com.valkyrieofnight.et.m_multiblocks.m_nanobot.registry.BeaconInfo;
import com.valkyrieofnight.um.api.attribute.AttributeCache;
import com.valkyrieofnight.um.api.attribute.AttributeID;
import com.valkyrieofnight.um.api.base.attributes.AttributeForgeEnergyFixed;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;

public abstract class NBBContBase
extends ETControllerEConsumer {
    private boolean enabled = false;

    public NBBContBase(int capacitorSize) {
        super(capacitorSize);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            // empty if block
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.disableEffects();
    }

    @Override
    public void deformMultiblock() {
        this.disableEffects();
        super.deformMultiblock();
    }

    protected void disableEffects() {
        this.enabled = false;
        List<EntityPlayer> players = this.getEffected();
        Map<AttributeID, IAttributeApplicator> apps = this.getBeaconInfo().getApplicatorRegistry().getAll();
        for (EntityPlayer player : players) {
            if (!this.canPlayerGetEffects(player)) continue;
            for (AttributeID atid : apps.keySet()) {
                if (!this.modifierHandler.hasAttribute(atid) || !this.canApplyEffect(atid, player)) continue;
                System.out.println("Disable: " + atid + " " + player.func_70005_c_());
                IAttributeApplicator app = apps.get(atid);
                AttributeCache cache = this.modifierHandler.getAttributeCache(atid);
                app.onDisableAttribute(cache, this.func_145831_w(), player);
            }
        }
    }

    protected void updateEffects() {
        List<EntityPlayer> players = this.getEffected();
        Map<AttributeID, IAttributeApplicator> apps = this.getBeaconInfo().getApplicatorRegistry().getAll();
        for (EntityPlayer player : players) {
            if (!this.canPlayerGetEffects(player)) continue;
            for (AttributeID atid : apps.keySet()) {
                if (!this.modifierHandler.hasAttribute(atid) || !this.canApplyEffect(atid, player)) continue;
                IAttributeApplicator app = apps.get(atid);
                AttributeCache cache = this.modifierHandler.getAttributeCache(atid);
                app.onUpdateAttribute(cache, this.func_145831_w(), player);
            }
        }
    }

    protected void enableEffects() {
        this.enabled = true;
        List<EntityPlayer> players = this.getEffected();
        Map<AttributeID, IAttributeApplicator> apps = this.getBeaconInfo().getApplicatorRegistry().getAll();
        for (EntityPlayer player : players) {
            if (!this.canPlayerGetEffects(player)) continue;
            for (AttributeID atid : apps.keySet()) {
                if (!this.modifierHandler.hasAttribute(atid) || !this.canApplyEffect(atid, player)) continue;
                IAttributeApplicator app = apps.get(atid);
                AttributeCache cache = this.modifierHandler.getAttributeCache(atid);
                app.onEnableAttribute(cache, this.func_145831_w(), player);
            }
        }
    }

    public String getInfo() {
        return super.getInfo() + " FE/T: " + this.getEnergyCostPerTick();
    }

    public void onLoad() {
        super.onLoad();
    }

    public void onProcessStart() {
    }

    public void onProcessTick(int processedTicks) {
        this.eBuffer.iExtractFE(this.getEnergyCostPerTick(), false);
    }

    public void onProcessComplete() {
        if (!this.enabled) {
            this.enableEffects();
        }
        this.updateEffects();
    }

    @Override
    public boolean canProcess() {
        if (this.eBuffer.getEnergyStored() < this.getEnergyCostPerTick()) {
            return false;
        }
        return super.canProcess();
    }

    public int getEnergyCostPerTick() {
        if (this.modifierHandler.hasAttribute(AttributeForgeEnergyFixed.FORGE_ENERGY_FIXED)) {
            int e = 0;
            Object finalValue = this.modifierHandler.getAttributeFinalValue(AttributeForgeEnergyFixed.FORGE_ENERGY_FIXED);
            e = (Integer)AttributeForgeEnergyFixed.FORGE_ENERGY_FIXED.getCalculator().calculateModifiedValue(finalValue != null ? finalValue : Integer.valueOf(0), (Object)e);
            return e;
        }
        return 0;
    }

    public void onIdleTick() {
    }

    @Override
    public EnumFacing[] validEnergyDirections() {
        return EnumFacing.field_82609_l;
    }

    public int getBaseDuration() {
        return 20;
    }

    public int getMinDuration() {
        return this.getBaseDuration();
    }

    public int getMaxDuration() {
        return this.getBaseDuration();
    }

    public int modifyDuration(int unmodifiedDuration) {
        return unmodifiedDuration;
    }

    public abstract List<EntityPlayer> getEffected();

    public abstract boolean canPlayerGetEffects(EntityPlayer var1);

    public abstract boolean canApplyEffect(AttributeID var1, EntityPlayer var2);

    public abstract BeaconInfo getBeaconInfo();
}

