/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.dynamo.compression;

import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoCompression;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.dynamo.BaseFuelCategory;
import cofh.thermalexpansion.plugins.jei.dynamo.compression.CompressionFuelWrapper;
import cofh.thermalexpansion.util.managers.dynamo.CompressionManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CompressionFuelCategory
extends BaseFuelCategory<CompressionFuelWrapper> {
    public static boolean enable = true;
    IDrawableStatic tank;

    public static void register(IRecipeCategoryRegistration registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CompressionFuelCategory(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(CompressionFuelCategory.getRecipes(registry, guiHelper), "thermalexpansion.compression");
        registry.addRecipeClickArea(GuiDynamoCompression.class, 115, 35, 16, 16, new String[]{"thermalexpansion.compression"});
        registry.addRecipeCatalyst((Object)BlockDynamo.dynamoCompression, new String[]{"thermalexpansion.compression"});
    }

    public static List<CompressionFuelWrapper> getRecipes(IModRegistry registry, IGuiHelper guiHelper) {
        ArrayList<CompressionFuelWrapper> recipes = new ArrayList<CompressionFuelWrapper>();
        for (String fluidName : CompressionManager.getFuels()) {
            FluidStack fuelStack = new FluidStack(FluidRegistry.getFluid((String)fluidName), 1000);
            recipes.add(new CompressionFuelWrapper(guiHelper, fuelStack, CompressionManager.getFuelEnergy(fuelStack)));
        }
        return recipes;
    }

    public CompressionFuelCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiDynamoCompression.TEXTURE, 26, 11, 70, 62, 0, 0, 16, 78);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.durationEmpty = Drawables.getDrawables(guiHelper).getScale(4);
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.dynamo.compression.name");
        this.tank = Drawables.getDrawables(guiHelper).getTank(2);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.compression";
    }

    @Override
    public void drawExtras(@Nonnull Minecraft minecraft) {
        super.drawExtras(minecraft);
        this.tank.draw(minecraft, 33, 7);
    }

    public void setRecipe(IRecipeLayout recipeLayout, CompressionFuelWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(FluidStack.class);
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiFluidStacks.init(0, true, 34, 8, 16, 30, 1000, false, null);
        guiFluidStacks.set(0, (List)inputs.get(0));
    }
}

