/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block;

import codechicken.lib.render.particle.CustomParticleHandler;
import cofh.api.block.IConfigGui;
import cofh.core.block.BlockCoreTile;
import cofh.core.block.TileAugmentableSecure;
import cofh.core.block.TileNameable;
import cofh.core.util.CoreUtils;
import cofh.core.util.RayTracer;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.WrenchHelper;
import cofh.thermalexpansion.ThermalExpansion;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockTEBase
extends BlockCoreTile
implements IConfigGui {
    protected boolean standardGui = true;
    protected boolean configGui = false;
    public static final float[] HARDNESS = new float[]{5.0f, 10.0f, 10.0f, 15.0f, 20.0f};
    public static final int[] RESISTANCE = new int[]{15, 30, 30, 45, 120};
    public static final float HARDNESS_CREATIVE = -1.0f;
    public static final float RESISTANCE_CREATIVE = 1200.0f;

    protected BlockTEBase(Material material) {
        super(material, "thermalexpansion");
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(ThermalExpansion.tabCommon);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileNameable) {
            ((TileNameable)tile).setCustomName(ItemHelper.getNameFromItemStack((ItemStack)stack));
        }
        super.func_180633_a(world, pos, state, living, stack);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)player);
        if (traceResult == null) {
            return false;
        }
        PlayerInteractEvent.RightClickBlock event = new PlayerInteractEvent.RightClickBlock(player, hand, pos, side, traceResult.field_72307_f);
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.getResult() == Event.Result.DENY) {
            return false;
        }
        if (player.func_70093_af() && WrenchHelper.isHoldingUsableWrench((EntityPlayer)player, (RayTraceResult)traceResult)) {
            if (ServerHelper.isServerWorld((World)world) && this.canDismantle(world, pos, state, player)) {
                this.dismantleBlock(world, pos, state, player, false);
                WrenchHelper.usedWrench((EntityPlayer)player, (RayTraceResult)traceResult);
            }
            return true;
        }
        TileNameable tile = (TileNameable)world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r()) {
            return false;
        }
        if (WrenchHelper.isHoldingUsableWrench((EntityPlayer)player, (RayTraceResult)traceResult)) {
            if (tile.canPlayerAccess(player)) {
                if (ServerHelper.isServerWorld((World)world)) {
                    tile.onWrench(player, side);
                }
                WrenchHelper.usedWrench((EntityPlayer)player, (RayTraceResult)traceResult);
            }
            return true;
        }
        if (this.onBlockActivatedDelegate(world, pos, state, player, hand, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (this.standardGui && ServerHelper.isServerWorld((World)world)) {
            return tile.openGui(player);
        }
        return this.standardGui;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        TileNameable tile = (TileNameable)world.func_175625_s(pos);
        if (tile instanceof TileAugmentableSecure) {
            return ((TileAugmentableSecure)tile).isCreative ? -1.0f : HARDNESS[((TileAugmentableSecure)tile).getLevel() % HARDNESS.length];
        }
        return this.field_149782_v;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileNameable tile = (TileNameable)world.func_175625_s(pos);
        if (tile instanceof TileAugmentableSecure) {
            return ((TileAugmentableSecure)tile).isCreative ? 1200.0f : (float)RESISTANCE[((TileAugmentableSecure)tile).getLevel() % RESISTANCE.length];
        }
        return this.field_149781_w / 5.0f;
    }

    public boolean onBlockActivatedDelegate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean openConfigGui(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        TileNameable tile = (TileNameable)world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r()) {
            return false;
        }
        if (this.configGui && ServerHelper.isServerWorld((World)world)) {
            return tile.openConfigGui(player);
        }
        return this.configGui;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return CustomParticleHandler.handleLandingEffects((WorldServer)world, (BlockPos)pos, (EntityLivingBase)entity, (int)numberOfParticles);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        return CustomParticleHandler.handleRunningEffects((World)world, (BlockPos)pos, (IBlockState)state, (Entity)entity);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult trace, ParticleManager manager) {
        return CustomParticleHandler.handleHitEffects((IBlockState)state, (World)world, (RayTraceResult)trace, (ParticleManager)manager);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return CustomParticleHandler.handleDestroyEffects((World)world, (BlockPos)pos, (ParticleManager)manager);
    }

    public boolean canDismantle(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileNameable tile = (TileNameable)world.func_175625_s(pos);
        if (tile instanceof TileAugmentableSecure && ((TileAugmentableSecure)tile).isCreative && !CoreUtils.isOp((EntityPlayer)player)) {
            return false;
        }
        return super.canDismantle(world, pos, state, player);
    }
}

